/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.documentmodel;

import com.yahoo.vespa.objects.FieldBase;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class FieldView
implements Serializable {
    private final String name;
    private final Map<String, FieldBase> fields = new LinkedHashMap<String, FieldBase>();

    public FieldView(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Collection<FieldBase> getFields() {
        return this.fields.values();
    }

    public FieldBase get(String name) {
        return this.fields.get(name);
    }

    public void remove(String name) {
        this.fields.remove(name);
    }

    public FieldView add(FieldBase field) {
        if (this.fields.containsKey(field.getName())) {
            if (!this.fields.get(field.getName()).equals((Object)field)) {
                throw new IllegalArgumentException("View '" + this.name + "' already contains a field with name '" + field.getName() + "' and definition : " + this.fields.get(field.getName()).toString() + ". Your is : " + field.toString());
            }
        } else {
            this.fields.put(field.getName(), field);
        }
        return this;
    }

    public FieldView add(FieldView view) {
        for (FieldBase field : view.getFields()) {
            this.add(field);
        }
        return this;
    }
}

