/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.document.CollectionDataType;
import com.yahoo.document.DataType;
import com.yahoo.schema.RankProfileRegistry;
import com.yahoo.schema.Schema;
import com.yahoo.schema.document.Case;
import com.yahoo.schema.document.MatchType;
import com.yahoo.schema.document.Matching;
import com.yahoo.schema.document.SDField;
import com.yahoo.schema.document.Stemming;
import com.yahoo.schema.processing.Processor;
import com.yahoo.schema.processing.TypedTransformProvider;
import com.yahoo.vespa.indexinglanguage.ExpressionSearcher;
import com.yahoo.vespa.indexinglanguage.expressions.ExactExpression;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.ForEachExpression;
import com.yahoo.vespa.indexinglanguage.expressions.IndexExpression;
import com.yahoo.vespa.indexinglanguage.expressions.OutputExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ScriptExpression;
import com.yahoo.vespa.indexinglanguage.linguistics.AnnotatorConfig;
import com.yahoo.vespa.model.container.search.QueryProfiles;

public class ExactMatch
extends Processor {
    public static final String DEFAULT_EXACT_TERMINATOR = "@@";

    ExactMatch(Schema schema, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(schema, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        for (SDField field : this.schema.allConcreteFields()) {
            this.processField(field, this.schema);
        }
    }

    private void processField(SDField field, Schema schema) {
        MatchType matching = field.getMatching().getType();
        if (matching.equals((Object)MatchType.EXACT) || matching.equals((Object)MatchType.WORD)) {
            this.implementExactMatch(field, schema);
        } else if (field.getMatching().getExactMatchTerminator() != null) {
            this.warn(schema, field, "exact-terminator requires 'exact' matching to have any effect.");
        }
        for (SDField structField : field.getStructFields()) {
            this.processField(structField, schema);
        }
    }

    private void implementExactMatch(SDField field, Schema schema) {
        field.setStemming(Stemming.NONE);
        field.getNormalizing().inferLowercase();
        if (field.getMatching().getType().equals((Object)MatchType.WORD)) {
            field.addQueryCommand("word");
        } else {
            String exactTerminator = DEFAULT_EXACT_TERMINATOR;
            if (field.getMatching().getExactMatchTerminator() != null && !field.getMatching().getExactMatchTerminator().isEmpty()) {
                exactTerminator = field.getMatching().getExactMatchTerminator();
            } else {
                this.info(schema, field, "With 'exact' matching, an exact-terminator is needed, using default value '" + exactTerminator + "' as terminator");
            }
            field.addQueryCommand("exact " + exactTerminator);
            if (field.doesIndexing()) {
                this.exactMatchSettingsForField(field);
            }
        }
        ScriptExpression script = field.getIndexingScript();
        if (new ExpressionSearcher(IndexExpression.class).containedIn((Expression)script)) {
            ExactScriptTransformer exactTransformer = new ExactScriptTransformer(schema, this.toAnnotatorConfig(field.getMatching()));
            field.setIndexingScript(schema.getName(), (ScriptExpression)exactTransformer.convert((Expression)field.getIndexingScript()));
        }
    }

    private AnnotatorConfig toAnnotatorConfig(Matching matching) {
        AnnotatorConfig config = new AnnotatorConfig();
        if (matching.maxTokenLength() != null) {
            config.setMaxTokenLength(matching.maxTokenLength().intValue());
        }
        if (matching.getCase() == Case.CASED) {
            config.setLowercase(false);
        }
        return config;
    }

    private void exactMatchSettingsForField(SDField field) {
        field.getRanking().setFilter(true);
    }

    private static class ExactScriptTransformer
    extends TypedTransformProvider {
        private final AnnotatorConfig config;

        ExactScriptTransformer(Schema schema, AnnotatorConfig config) {
            super(ExactExpression.class, schema);
            this.config = config;
        }

        @Override
        protected boolean requiresTransform(Expression exp, DataType fieldType) {
            return exp instanceof OutputExpression;
        }

        @Override
        protected Expression newTransform(DataType fieldType) {
            ExactExpression expression = new ExactExpression(this.config);
            if (fieldType instanceof CollectionDataType) {
                expression = new ForEachExpression((Expression)expression);
            }
            return expression;
        }
    }
}

