/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.document.Field;
import com.yahoo.schema.RankProfileRegistry;
import com.yahoo.schema.Schema;
import com.yahoo.schema.document.Attribute;
import com.yahoo.schema.document.SDDocumentType;
import com.yahoo.schema.document.SDField;
import com.yahoo.schema.processing.Processor;
import com.yahoo.vespa.documentmodel.DocumentSummary;
import com.yahoo.vespa.documentmodel.SummaryField;
import com.yahoo.vespa.documentmodel.SummaryTransform;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import com.yahoo.vespa.objects.FieldBase;

public class AddExtraFieldsToDocument
extends Processor {
    AddExtraFieldsToDocument(Schema schema, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(schema, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        SDDocumentType document = this.schema.getDocument();
        if (document != null) {
            for (SDField field : this.schema.extraFieldList()) {
                this.addSdField(this.schema, document, field, validate);
            }
            for (DocumentSummary docsum : this.schema.getSummaries().values()) {
                for (SummaryField summaryField : docsum.getSummaryFields().values()) {
                    this.considerCopyTransformForExtraSummaryField(this.schema, summaryField);
                }
            }
        }
    }

    private void addSdField(Schema schema, SDDocumentType document, SDField field, boolean validate) {
        if (!field.hasIndex() && field.getAttributes().isEmpty() && !field.doesSummarying()) {
            return;
        }
        for (Attribute atr : field.getAttributes().values()) {
            if (atr.getName().equals(field.getName())) continue;
            this.addField(schema, document, new SDField(document, atr.getName(), atr.getDataType()), validate);
        }
        this.addField(schema, document, field, validate);
    }

    private void addField(Schema schema, SDDocumentType document, Field field, boolean validate) {
        if (document.getField(field.getName()) != null && document.getField(field.getName()) != field && validate) {
            throw this.newProcessException(schema, (FieldBase)field, "Field shadows another.");
        }
        document.addField(field);
    }

    private void considerCopyTransformForExtraSummaryField(Schema schema, SummaryField field) {
        if (field.getTransform() == SummaryTransform.NONE && field.hasExplicitSingleSource() && this.fieldIsExtraSummaryField(schema, field.getName())) {
            field.setTransform(SummaryTransform.COPY);
        }
    }

    private boolean fieldIsExtraSummaryField(Schema schema, String name) {
        SDField field = schema.getConcreteField(name);
        return field == null;
    }
}

