/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema;

import com.yahoo.schema.Schema;
import com.yahoo.schema.document.BooleanIndexDefinition;
import com.yahoo.schema.document.HnswIndexParams;
import com.yahoo.schema.document.RankType;
import com.yahoo.schema.document.Stemming;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class Index
implements Cloneable,
Serializable {
    private String name;
    private RankType rankType = null;
    private boolean prefix;
    private Set<String> aliases = new LinkedHashSet<String>(1);
    private Stemming stemming = null;
    private Type type = Type.VESPA;
    private BooleanIndexDefinition boolIndex;
    private Optional<HnswIndexParams> hnswIndexParams = Optional.empty();
    private boolean interleavedFeatures = false;

    public Index(String name) {
        this(name, false);
    }

    public Index(String name, boolean prefix) {
        this.name = name;
        this.prefix = prefix;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setRankType(RankType rankType) {
        this.rankType = rankType;
    }

    public RankType getRankType() {
        return this.rankType;
    }

    public Stemming getStemming() {
        return this.stemming;
    }

    public Stemming getStemming(Schema schema) {
        if (this.stemming != null) {
            return this.stemming;
        }
        return schema.getStemming();
    }

    public void setStemming(Stemming stemming) {
        this.stemming = stemming;
    }

    public boolean isPrefix() {
        return this.prefix;
    }

    public void setPrefix(boolean prefix) {
        this.prefix = prefix;
    }

    public void addAlias(String alias) {
        this.aliases.add(alias);
    }

    public Iterator<String> aliasIterator() {
        return Collections.unmodifiableSet(this.aliases).iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Index index = (Index)o;
        return this.prefix == index.prefix && this.interleavedFeatures == index.interleavedFeatures && Objects.equals(this.name, index.name) && this.rankType == index.rankType && Objects.equals(this.aliases, index.aliases) && this.stemming == index.stemming && this.type == index.type && Objects.equals(this.boolIndex, index.boolIndex) && Objects.equals(this.hnswIndexParams, index.hnswIndexParams);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.rankType, this.prefix, this.aliases, this.stemming, this.type, this.boolIndex, this.hnswIndexParams, this.interleavedFeatures});
    }

    public String toString() {
        String rankTypeName = this.rankType == null ? "(none)" : this.rankType.name();
        return "index '" + this.name + "' [ranktype: " + rankTypeName + ", prefix: " + this.prefix + "]";
    }

    public Object clone() {
        try {
            Index copy = (Index)super.clone();
            copy.aliases = new LinkedHashSet<String>(this.aliases);
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Programming error", e);
        }
    }

    public Index copy() {
        return (Index)this.clone();
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public BooleanIndexDefinition getBooleanIndexDefiniton() {
        return this.boolIndex;
    }

    public void setBooleanIndexDefiniton(BooleanIndexDefinition def) {
        this.boolIndex = def;
    }

    public Optional<HnswIndexParams> getHnswIndexParams() {
        return this.hnswIndexParams;
    }

    public void setHnswIndexParams(HnswIndexParams params) {
        this.hnswIndexParams = Optional.of(params);
    }

    public void setInterleavedFeatures(boolean value) {
        this.interleavedFeatures = value;
    }

    public boolean useInterleavedFeatures() {
        return this.interleavedFeatures;
    }

    public static enum Type {
        VESPA("vespa");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

