/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.builder.xml.dom;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AnyConfigProducer;
import com.yahoo.config.model.producer.TreeConfigProducer;
import com.yahoo.container.bundle.BundleInstantiationSpecification;
import com.yahoo.osgi.provider.model.ComponentModel;
import com.yahoo.text.XML;
import com.yahoo.vespa.model.builder.xml.dom.DomComponentBuilder;
import com.yahoo.vespa.model.builder.xml.dom.VespaDomBuilder;
import com.yahoo.vespa.model.container.ApplicationContainerCluster;
import com.yahoo.vespa.model.container.ContainerCluster;
import com.yahoo.vespa.model.container.component.BindingPattern;
import com.yahoo.vespa.model.container.component.Handler;
import com.yahoo.vespa.model.container.component.UserBindingPattern;
import com.yahoo.vespa.model.container.xml.BundleInstantiationSpecificationBuilder;
import java.util.Collection;
import java.util.Set;
import java.util.logging.Level;
import org.w3c.dom.Element;

public class DomHandlerBuilder
extends VespaDomBuilder.DomConfigProducerBuilderBase<Handler> {
    private static final Set<BindingPattern> reservedBindings = Set.of(ApplicationContainerCluster.METRICS_V2_HANDLER_BINDING_1, ApplicationContainerCluster.METRICS_V2_HANDLER_BINDING_2, ContainerCluster.STATE_HANDLER_BINDING_1, ContainerCluster.STATE_HANDLER_BINDING_2, ContainerCluster.VIP_HANDLER_BINDING);
    private final ApplicationContainerCluster cluster;
    private final Set<Integer> portBindingOverride;

    public DomHandlerBuilder(ApplicationContainerCluster cluster, Set<Integer> portBindingOverride) {
        this.cluster = cluster;
        this.portBindingOverride = portBindingOverride;
    }

    @Override
    protected Handler doBuild(DeployState deployState, TreeConfigProducer<AnyConfigProducer> parent, Element handlerElement) {
        Handler handler = this.createHandler(handlerElement);
        Set<Integer> ports = deployState.isHosted() ? this.portBindingOverride : Set.of();
        for (Element xmlBinding : XML.getChildren((Element)handlerElement, (String)"binding")) {
            for (UserBindingPattern binding : DomHandlerBuilder.userBindingPattern(XML.getValue((Element)xmlBinding), ports)) {
                this.addServerBinding(handler, binding, deployState.getDeployLogger());
            }
        }
        DomComponentBuilder.addChildren(deployState, parent, handlerElement, handler);
        return handler;
    }

    private static Collection<UserBindingPattern> userBindingPattern(String path, Set<Integer> portBindingOverride) {
        UserBindingPattern bindingPattern = UserBindingPattern.fromPattern(path);
        if (portBindingOverride.isEmpty()) {
            return Set.of(bindingPattern);
        }
        return portBindingOverride.stream().map(bindingPattern::withOverriddenPort).toList();
    }

    Handler createHandler(Element handlerElement) {
        BundleInstantiationSpecification bundleSpec = BundleInstantiationSpecificationBuilder.build(handlerElement);
        return new Handler(new ComponentModel(bundleSpec));
    }

    private void addServerBinding(Handler handler, BindingPattern binding, DeployLogger log) {
        this.throwIfBindingIsReserved(binding, handler);
        handler.addServerBindings(binding);
        this.removeExistingServerBinding(binding, handler, log);
    }

    private void throwIfBindingIsReserved(BindingPattern binding, Handler newHandler) {
        for (BindingPattern reserved : reservedBindings) {
            if (!binding.hasSamePattern(reserved)) continue;
            throw new IllegalArgumentException("Binding '" + binding.patternString() + "' is a reserved Vespa binding and cannot be used by handler: " + String.valueOf(newHandler.getComponentId()));
        }
    }

    private void removeExistingServerBinding(BindingPattern binding, Handler newHandler, DeployLogger log) {
        for (Handler handler : this.cluster.getHandlers()) {
            for (BindingPattern serverBinding : handler.getServerBindings()) {
                if (!serverBinding.hasSamePattern(binding)) continue;
                handler.removeServerBinding(serverBinding);
                log.logApplicationPackage(Level.INFO, "Binding '" + binding.patternString() + "' was already in use by handler '" + String.valueOf(handler.getComponentId()) + "', but will now be taken over by handler: " + String.valueOf(newHandler.getComponentId()));
            }
        }
    }
}

