/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.builder.xml.dom;

import com.yahoo.text.Lowercase;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BinaryUnit {
    private static final Pattern pattern = Pattern.compile("(\\d+(\\.\\d*)?)\\s*([kmgKMG])?");

    public static double valueOf(String valueString) {
        Matcher matcher = pattern.matcher(valueString);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Value '" + valueString + "' does not match the pattern for binary unit");
        }
        double value = Double.valueOf(matcher.group(1));
        String unit = matcher.group(3);
        if (unit != null) {
            value *= BinaryUnit.unitToValue(Lowercase.toLowerCase((String)unit).charAt(0));
        }
        return value;
    }

    private static double unitToValue(char unit) {
        char[] units = new char[]{'k', 'm', 'g'};
        for (int i = 0; i < units.length; ++i) {
            if (units[i] != unit) continue;
            return Math.pow(2.0, 10 * (i + 1));
        }
        throw new IllegalArgumentException("No such unit: '" + unit + "'");
    }
}

