/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.deploy;

import com.yahoo.config.model.api.ConfigServerSpec;
import com.yahoo.config.model.api.ContainerEndpoint;
import com.yahoo.config.model.api.EndpointCertificateSecrets;
import com.yahoo.config.model.api.ModelContext;
import com.yahoo.config.model.api.Quota;
import com.yahoo.config.model.api.TenantSecretStore;
import com.yahoo.config.model.api.TenantVault;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.AthenzDomain;
import com.yahoo.config.provision.CloudAccount;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.config.provision.DataplaneToken;
import com.yahoo.config.provision.HostName;
import com.yahoo.config.provision.Zone;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class TestProperties
implements ModelContext.Properties,
ModelContext.FeatureFlags {
    private boolean multitenant = false;
    private ApplicationId applicationId = ApplicationId.defaultId();
    private List<ConfigServerSpec> configServerSpecs = List.of();
    private boolean hostedVespa = false;
    private Zone zone = Zone.defaultZone();
    private Set<ContainerEndpoint> endpoints = Set.of();
    private boolean useDedicatedNodeForLogserver = false;
    private String jvmGCOptions = null;
    private String summaryDecodePolicy = "eager";
    private boolean firstTimeDeployment = false;
    private String responseSequencerType = "ADAPTIVE";
    private int responseNumThreads = 2;
    private Optional<EndpointCertificateSecrets> endpointCertificateSecrets = Optional.empty();
    private AthenzDomain athenzDomain;
    private Quota quota = Quota.unlimited();
    private boolean useAsyncMessageHandlingOnSchedule = true;
    private double feedConcurrency = 0.5;
    private double feedNiceness = 0.0;
    private int maxActivationInhibitedOutOfSyncGroups = 0;
    private List<TenantVault> tenantVaults = List.of();
    private List<TenantSecretStore> tenantSecretStores = List.of();
    private boolean allowDisableMtls = true;
    private List<X509Certificate> operatorCertificates = List.of();
    private double resourceLimitDisk = 0.75;
    private double resourceLimitMemory = 0.8;
    private double resourceLimitLowWatermarkDifference = 0.0;
    private double minNodeRatioPerGroup = 0.0;
    private int maxUnCommittedMemory = 123456;
    private String searchMmapAdvise = "SEQUENTIAL";
    private boolean useV8GeoPositions = true;
    private List<String> environmentVariables = List.of();
    private int mbus_java_num_targets = 2;
    private int mbus_java_events_before_wakeup = 1;
    private int mbus_cpp_num_targets = 2;
    private int mbus_cpp_events_before_wakeup = 1;
    private int rpc_num_targets = 2;
    private int rpc_events_before_wakeup = 1;
    private int mbus_network_threads = 1;
    private int heapSizePercentage = 85;
    private Optional<CloudAccount> cloudAccount = Optional.empty();
    private boolean allowUserFilters = true;
    private List<DataplaneToken> dataplaneTokens;
    private int contentLayerMetadataFeatureLevel = 0;
    private int persistenceThreadMaxFeedOpBatchSize = 1;
    private boolean logserverOtelCol = false;
    private boolean symmetricPutAndActivateReplicaSelection = false;
    private int maxContentNodeMaintenanceOpConcurrency = -1;
    private int maxDistributorDocumentOperationSizeMib = -1;

    public ModelContext.FeatureFlags featureFlags() {
        return this;
    }

    public boolean multitenant() {
        return this.multitenant;
    }

    public ApplicationId applicationId() {
        return this.applicationId;
    }

    public List<ConfigServerSpec> configServerSpecs() {
        return this.configServerSpecs;
    }

    public HostName loadBalancerName() {
        return null;
    }

    public URI ztsUrl() {
        return null;
    }

    public AthenzDomain tenantSecretDomain() {
        return null;
    }

    public String athenzDnsSuffix() {
        return null;
    }

    public boolean hostedVespa() {
        return this.hostedVespa;
    }

    public Zone zone() {
        return this.zone;
    }

    public Set<ContainerEndpoint> endpoints() {
        return this.endpoints;
    }

    public String jvmGCOptions(Optional<ClusterSpec.Type> clusterType) {
        return this.jvmGCOptions;
    }

    public boolean isBootstrap() {
        return false;
    }

    public boolean isFirstTimeDeployment() {
        return this.firstTimeDeployment;
    }

    public boolean useDedicatedNodeForLogserver() {
        return this.useDedicatedNodeForLogserver;
    }

    public Optional<EndpointCertificateSecrets> endpointCertificateSecrets() {
        return this.endpointCertificateSecrets;
    }

    public Optional<AthenzDomain> athenzDomain() {
        return Optional.ofNullable(this.athenzDomain);
    }

    public boolean useNonPublicEndpointForTest() {
        return true;
    }

    public String responseSequencerType() {
        return this.responseSequencerType;
    }

    public int defaultNumResponseThreads() {
        return this.responseNumThreads;
    }

    public Quota quota() {
        return this.quota;
    }

    public boolean useAsyncMessageHandlingOnSchedule() {
        return this.useAsyncMessageHandlingOnSchedule;
    }

    public double feedConcurrency() {
        return this.feedConcurrency;
    }

    public double feedNiceness() {
        return this.feedNiceness;
    }

    public int maxActivationInhibitedOutOfSyncGroups() {
        return this.maxActivationInhibitedOutOfSyncGroups;
    }

    public List<TenantVault> tenantVaults() {
        return this.tenantVaults;
    }

    public List<TenantSecretStore> tenantSecretStores() {
        return this.tenantSecretStores;
    }

    public boolean allowDisableMtls() {
        return this.allowDisableMtls;
    }

    public List<X509Certificate> operatorCertificates() {
        return this.operatorCertificates;
    }

    public double resourceLimitDisk() {
        return this.resourceLimitDisk;
    }

    public double resourceLimitMemory() {
        return this.resourceLimitMemory;
    }

    public double resourceLimitLowWatermarkDifference() {
        return this.resourceLimitLowWatermarkDifference;
    }

    public double minNodeRatioPerGroup() {
        return this.minNodeRatioPerGroup;
    }

    public int maxUnCommittedMemory() {
        return this.maxUnCommittedMemory;
    }

    public String searchMmapAdvise() {
        return this.searchMmapAdvise;
    }

    public boolean useV8GeoPositions() {
        return this.useV8GeoPositions;
    }

    public List<String> environmentVariables() {
        return this.environmentVariables;
    }

    public int mbusNetworkThreads() {
        return this.mbus_network_threads;
    }

    public int mbusJavaRpcNumTargets() {
        return this.mbus_java_num_targets;
    }

    public int mbusJavaEventsBeforeWakeup() {
        return this.mbus_java_events_before_wakeup;
    }

    public int mbusCppRpcNumTargets() {
        return this.mbus_cpp_num_targets;
    }

    public int mbusCppEventsBeforeWakeup() {
        return this.mbus_cpp_events_before_wakeup;
    }

    public int rpcNumTargets() {
        return this.rpc_num_targets;
    }

    public int heapSizePercentage() {
        return this.heapSizePercentage;
    }

    public int rpcEventsBeforeWakeup() {
        return this.rpc_events_before_wakeup;
    }

    public String summaryDecodePolicy() {
        return this.summaryDecodePolicy;
    }

    public Optional<CloudAccount> cloudAccount() {
        return this.cloudAccount;
    }

    public boolean allowUserFilters() {
        return this.allowUserFilters;
    }

    public List<DataplaneToken> dataplaneTokens() {
        return this.dataplaneTokens;
    }

    public int contentLayerMetadataFeatureLevel() {
        return this.contentLayerMetadataFeatureLevel;
    }

    public int persistenceThreadMaxFeedOpBatchSize() {
        return this.persistenceThreadMaxFeedOpBatchSize;
    }

    public boolean logserverOtelCol() {
        return this.logserverOtelCol;
    }

    public boolean symmetricPutAndActivateReplicaSelection() {
        return this.symmetricPutAndActivateReplicaSelection;
    }

    public int maxContentNodeMaintenanceOpConcurrency() {
        return this.maxContentNodeMaintenanceOpConcurrency;
    }

    public int maxDistributorDocumentOperationSizeMib() {
        return this.maxDistributorDocumentOperationSizeMib;
    }

    public TestProperties maxUnCommittedMemory(int maxUnCommittedMemory) {
        this.maxUnCommittedMemory = maxUnCommittedMemory;
        return this;
    }

    public TestProperties setSearchMmapAdvise(String searchMmapAdvise) {
        this.searchMmapAdvise = searchMmapAdvise;
        return this;
    }

    public TestProperties setFeedConcurrency(double feedConcurrency) {
        this.feedConcurrency = feedConcurrency;
        return this;
    }

    public TestProperties setFeedNiceness(double feedNiceness) {
        this.feedNiceness = feedNiceness;
        return this;
    }

    public TestProperties setHeapSizePercentage(int percentage) {
        this.heapSizePercentage = percentage;
        return this;
    }

    public TestProperties setAsyncMessageHandlingOnSchedule(boolean value) {
        this.useAsyncMessageHandlingOnSchedule = value;
        return this;
    }

    public TestProperties setJvmGCOptions(String gcOptions) {
        this.jvmGCOptions = gcOptions;
        return this;
    }

    public TestProperties setSummaryDecodePolicy(String type) {
        this.summaryDecodePolicy = type;
        return this;
    }

    public TestProperties setResponseSequencerType(String type) {
        this.responseSequencerType = type;
        return this;
    }

    public TestProperties setFirstTimeDeployment(boolean firstTimeDeployment) {
        this.firstTimeDeployment = firstTimeDeployment;
        return this;
    }

    public TestProperties setResponseNumThreads(int numThreads) {
        this.responseNumThreads = numThreads;
        return this;
    }

    public TestProperties setApplicationId(ApplicationId applicationId) {
        this.applicationId = applicationId;
        return this;
    }

    public TestProperties setHostedVespa(boolean hostedVespa) {
        this.hostedVespa = hostedVespa;
        return this;
    }

    public TestProperties setMultitenant(boolean multitenant) {
        this.multitenant = multitenant;
        return this;
    }

    public TestProperties setConfigServerSpecs(List<Spec> configServerSpecs) {
        this.configServerSpecs = List.copyOf(configServerSpecs);
        return this;
    }

    public TestProperties setUseDedicatedNodeForLogserver(boolean useDedicatedNodeForLogserver) {
        this.useDedicatedNodeForLogserver = useDedicatedNodeForLogserver;
        return this;
    }

    public TestProperties setEndpointCertificateSecrets(Optional<EndpointCertificateSecrets> endpointCertificateSecrets) {
        this.endpointCertificateSecrets = endpointCertificateSecrets;
        return this;
    }

    public TestProperties setZone(Zone zone) {
        this.zone = zone;
        return this;
    }

    public TestProperties setAthenzDomain(AthenzDomain domain) {
        this.athenzDomain = domain;
        return this;
    }

    public TestProperties setQuota(Quota quota) {
        this.quota = quota;
        return this;
    }

    public TestProperties maxActivationInhibitedOutOfSyncGroups(int nGroups) {
        this.maxActivationInhibitedOutOfSyncGroups = nGroups;
        return this;
    }

    public TestProperties setTenantVaults(List<TenantVault> tenantVaults) {
        this.tenantVaults = List.copyOf(tenantVaults);
        return this;
    }

    public TestProperties setTenantSecretStores(List<TenantSecretStore> secretStores) {
        this.tenantSecretStores = List.copyOf(secretStores);
        return this;
    }

    public TestProperties allowDisableMtls(boolean value) {
        this.allowDisableMtls = value;
        return this;
    }

    public TestProperties setOperatorCertificates(List<X509Certificate> operatorCertificates) {
        this.operatorCertificates = List.copyOf(operatorCertificates);
        return this;
    }

    public TestProperties setResourceLimitDisk(double value) {
        this.resourceLimitDisk = value;
        return this;
    }

    public TestProperties setResourceLimitMemory(double value) {
        this.resourceLimitMemory = value;
        return this;
    }

    public TestProperties setResourceLimitLowWatermarkDifference(double value) {
        this.resourceLimitLowWatermarkDifference = value;
        return this;
    }

    public TestProperties setMinNodeRatioPerGroup(double value) {
        this.minNodeRatioPerGroup = value;
        return this;
    }

    public TestProperties setUseV8GeoPositions(boolean value) {
        this.useV8GeoPositions = value;
        return this;
    }

    public TestProperties setEnvironmentVariables(List<String> value) {
        this.environmentVariables = value;
        return this;
    }

    public TestProperties setMbusNetworkThreads(int value) {
        this.mbus_network_threads = value;
        return this;
    }

    public TestProperties setMbusJavaRpcNumTargets(int value) {
        this.mbus_java_num_targets = value;
        return this;
    }

    public TestProperties setMbusJavaEventsBeforeWakeup(int value) {
        this.mbus_java_events_before_wakeup = value;
        return this;
    }

    public TestProperties setMbusCppEventsBeforeWakeup(int value) {
        this.mbus_cpp_events_before_wakeup = value;
        return this;
    }

    public TestProperties setMbusCppRpcNumTargets(int value) {
        this.mbus_cpp_num_targets = value;
        return this;
    }

    public TestProperties setRpcNumTargets(int value) {
        this.rpc_num_targets = value;
        return this;
    }

    public TestProperties setRpcEventsBeforeWakeup(int value) {
        this.rpc_events_before_wakeup = value;
        return this;
    }

    public TestProperties setCloudAccount(CloudAccount cloudAccount) {
        this.cloudAccount = Optional.ofNullable(cloudAccount);
        return this;
    }

    public TestProperties setAllowUserFilters(boolean b) {
        this.allowUserFilters = b;
        return this;
    }

    public TestProperties setDataplaneTokens(Collection<DataplaneToken> tokens) {
        this.dataplaneTokens = List.copyOf(tokens);
        return this;
    }

    public TestProperties setContentLayerMetadataFeatureLevel(int level) {
        this.contentLayerMetadataFeatureLevel = level;
        return this;
    }

    public TestProperties setPersistenceThreadMaxFeedOpBatchSize(int maxBatchSize) {
        this.persistenceThreadMaxFeedOpBatchSize = maxBatchSize;
        return this;
    }

    public TestProperties setLogserverOtelCol(boolean logserverOtelCol) {
        this.logserverOtelCol = logserverOtelCol;
        return this;
    }

    public TestProperties setSymmetricPutAndActivateReplicaSelection(boolean symmetricReplicaSelection) {
        this.symmetricPutAndActivateReplicaSelection = symmetricReplicaSelection;
        return this;
    }

    public TestProperties setContainerEndpoints(Set<ContainerEndpoint> containerEndpoints) {
        this.endpoints = containerEndpoints;
        return this;
    }

    public TestProperties setMaxContentNodeMaintenanceOpConcurrency(int maxConcurrency) {
        this.maxContentNodeMaintenanceOpConcurrency = maxConcurrency;
        return this;
    }

    public TestProperties setMaxDistributorDocumentOperationSizeMib(int maxSizeMib) {
        this.maxDistributorDocumentOperationSizeMib = maxSizeMib;
        return this;
    }

    public static class Spec
    implements ConfigServerSpec {
        private final String hostName;
        private final int configServerPort;
        private final int zooKeeperPort;

        public String getHostName() {
            return this.hostName;
        }

        public int getConfigServerPort() {
            return this.configServerPort;
        }

        public int getZooKeeperPort() {
            return this.zooKeeperPort;
        }

        public boolean equals(Object o) {
            if (o instanceof ConfigServerSpec) {
                ConfigServerSpec rhsSpec = (ConfigServerSpec)o;
                return this.hostName.equals(rhsSpec.getHostName()) && this.configServerPort == rhsSpec.getConfigServerPort() && this.zooKeeperPort == rhsSpec.getZooKeeperPort();
            }
            return false;
        }

        public int hashCode() {
            return this.hostName.hashCode();
        }

        public Spec(String hostName, int configServerPort, int zooKeeperPort) {
            this.hostName = hostName;
            this.configServerPort = configServerPort;
            this.zooKeeperPort = zooKeeperPort;
        }
    }
}

