/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.content;

import com.yahoo.config.model.api.ModelContext;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AnyConfigProducer;
import com.yahoo.config.model.producer.TreeConfigProducer;
import com.yahoo.documentmodel.NewDocumentType;
import com.yahoo.schema.Schema;
import com.yahoo.schema.derived.SchemaInfo;
import com.yahoo.vespa.config.search.DispatchConfig;
import com.yahoo.vespa.config.search.DispatchNodesConfig;
import com.yahoo.vespa.config.search.core.ProtonConfig;
import com.yahoo.vespa.model.builder.xml.dom.DomSearchTuningBuilder;
import com.yahoo.vespa.model.builder.xml.dom.ModelElement;
import com.yahoo.vespa.model.builder.xml.dom.VespaDomBuilder;
import com.yahoo.vespa.model.content.ContentNode;
import com.yahoo.vespa.model.content.Redundancy;
import com.yahoo.vespa.model.content.ResourceLimits;
import com.yahoo.vespa.model.content.StorageGroup;
import com.yahoo.vespa.model.content.TopologicalDocumentTypeSorter;
import com.yahoo.vespa.model.content.cluster.ContentCluster;
import com.yahoo.vespa.model.search.IndexedSearchCluster;
import com.yahoo.vespa.model.search.IndexingDocproc;
import com.yahoo.vespa.model.search.NodeSpec;
import com.yahoo.vespa.model.search.SchemaDefinitionXMLHandler;
import com.yahoo.vespa.model.search.SearchCluster;
import com.yahoo.vespa.model.search.SearchNode;
import com.yahoo.vespa.model.search.Tuning;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.w3c.dom.Element;

public class ContentSearchCluster
extends TreeConfigProducer<AnyConfigProducer>
implements ProtonConfig.Producer,
Redundancy.Provider {
    private static final int DEFAULT_DOC_STORE_COMPRESSION_LEVEL = 3;
    private static final double DEFAULT_DISK_BLOAT = 0.25;
    private final boolean flushOnShutdown;
    private final Boolean syncTransactionLog;
    private IndexedSearchCluster searchCluster;
    private final IndexingDocproc indexingDocproc;
    private Redundancy redundancy;
    private final String clusterName;
    private final Map<String, NewDocumentType> documentDefinitions;
    private final Set<NewDocumentType> globallyDistributedDocuments;
    private Double visibilityDelay = 0.0;
    private final List<SearchNode> nonIndexed = new ArrayList<SearchNode>();
    private final Map<StorageGroup, NodeSpec> groupToSpecMap = new LinkedHashMap<StorageGroup, NodeSpec>();
    private ResourceLimits resourceLimits;
    private final double defaultFeedConcurrency;
    private final double defaultFeedNiceness;
    private final boolean forwardIssuesToQrs;
    private final ProtonConfig.Search.Mmap.Advise.Enum searchMmapAdvise;
    private final double fractionOfMemoryReserved;
    private Tuning tuning;

    private static ProtonConfig.Search.Mmap.Advise.Enum convertSearchMmapAdvise(String searchMmapAdvise) {
        try {
            return ProtonConfig.Search.Mmap.Advise.Enum.valueOf((String)searchMmapAdvise);
        }
        catch (Throwable t) {
            return ProtonConfig.Search.Mmap.Advise.Enum.NORMAL;
        }
    }

    private ContentSearchCluster(TreeConfigProducer<?> parent, String clusterName, ModelContext.FeatureFlags featureFlags, Map<String, NewDocumentType> documentDefinitions, Set<NewDocumentType> globallyDistributedDocuments, boolean flushOnShutdown, Boolean syncTransactionLog, double fractionOfMemoryReserved) {
        super(parent, "search");
        this.indexingDocproc = new IndexingDocproc();
        this.clusterName = clusterName;
        this.documentDefinitions = documentDefinitions;
        this.globallyDistributedDocuments = globallyDistributedDocuments;
        this.flushOnShutdown = flushOnShutdown;
        this.syncTransactionLog = syncTransactionLog;
        this.fractionOfMemoryReserved = fractionOfMemoryReserved;
        this.defaultFeedConcurrency = featureFlags.feedConcurrency();
        this.defaultFeedNiceness = featureFlags.feedNiceness();
        this.forwardIssuesToQrs = featureFlags.forwardIssuesAsErrors();
        this.searchMmapAdvise = ContentSearchCluster.convertSearchMmapAdvise(featureFlags.searchMmapAdvise());
    }

    public void setVisibilityDelay(double delay) {
        this.visibilityDelay = delay;
        if (this.searchCluster != null) {
            this.searchCluster.setVisibilityDelay(delay);
        }
    }

    private void addSearchCluster(DeployState deployState, IndexedSearchCluster cluster, Double queryTimeout, List<ModelElement> documentDefs) {
        this.addSchemas(deployState, documentDefs, cluster);
        if (queryTimeout != null) {
            cluster.setQueryTimeout(queryTimeout);
        }
        cluster.deriveFromSchemas(deployState);
        if (!cluster.schemas().values().stream().allMatch(schemaInfo -> schemaInfo.getIndexMode() == SchemaInfo.IndexMode.STORE_ONLY)) {
            this.addCluster(cluster);
        }
    }

    private void addSchemas(DeployState deployState, List<ModelElement> searchDefs, SearchCluster sc) {
        for (ModelElement e : searchDefs) {
            SchemaDefinitionXMLHandler schemaDefinitionXMLHandler = new SchemaDefinitionXMLHandler(e);
            Schema schema = schemaDefinitionXMLHandler.findResponsibleSchema(deployState.getSchemas());
            if (schema == null) {
                throw new IllegalArgumentException("Schema '" + schemaDefinitionXMLHandler.getName() + "' referenced in " + String.valueOf(this) + " does not exist");
            }
            if (schema.isDocumentsOnly()) continue;
            sc.add(new SchemaInfo(schema, e.stringAttribute("mode"), deployState.rankProfileRegistry(), null));
        }
    }

    private void addCluster(IndexedSearchCluster sc) {
        if (this.searchCluster != null) {
            throw new IllegalArgumentException("Duplicate indexed cluster '" + this.searchCluster.getClusterName() + "'");
        }
        this.searchCluster = sc;
    }

    public Boolean isStreaming() {
        if (this.searchCluster == null) {
            return false;
        }
        boolean hasStreaming = this.searchCluster.hasStreaming();
        if (this.searchCluster.hasIndexed() == hasStreaming) {
            return null;
        }
        return hasStreaming;
    }

    public boolean hasStreaming() {
        return this.searchCluster != null && this.searchCluster.hasStreaming();
    }

    public boolean hasIndexed() {
        return this.searchCluster != null && this.searchCluster.hasIndexed();
    }

    public List<SearchNode> getSearchNodes() {
        return this.searchCluster != null ? this.searchCluster.getSearchNodes() : this.nonIndexed;
    }

    public void addSearchNode(DeployState deployState, ContentNode node, StorageGroup parentGroup, ModelElement element) {
        SearchNode searchNode;
        TreeConfigProducer parent = this.searchCluster != null ? this.searchCluster : this;
        NodeSpec spec = this.getNextSearchNodeSpec(parentGroup);
        if (element == null) {
            searchNode = SearchNode.create(parent, "" + node.getDistributionKey(), node.getDistributionKey(), spec, this.clusterName, node, this.flushOnShutdown, this.tuning, deployState.isHosted(), this.fractionOfMemoryReserved, this.syncTransactionLog);
            searchNode.setHostResource(node.getHostResource());
            searchNode.initService(deployState);
        } else {
            searchNode = (SearchNode)new SearchNode.Builder("" + node.getDistributionKey(), spec, this.clusterName, node, this.flushOnShutdown, this.tuning, this.fractionOfMemoryReserved, this.syncTransactionLog).build(deployState, parent, element.getXml());
        }
        if (this.searchCluster != null) {
            this.searchCluster.addSearcher(searchNode);
        } else {
            this.nonIndexed.add(searchNode);
        }
    }

    private NodeSpec getNextSearchNodeSpec(StorageGroup parentGroup) {
        NodeSpec spec = this.groupToSpecMap.get(parentGroup);
        spec = spec == null ? new NodeSpec(this.groupToSpecMap.size(), 0) : new NodeSpec(spec.groupIndex(), spec.partitionId() + 1);
        this.groupToSpecMap.put(parentGroup, spec);
        return spec;
    }

    public void setTuning(Tuning tuning) {
        this.tuning = tuning;
    }

    public void setResourceLimits(ResourceLimits resourceLimits) {
        this.resourceLimits = resourceLimits;
    }

    public boolean usesHierarchicDistribution() {
        return this.searchCluster != null && this.groupToSpecMap.size() > 1;
    }

    public void handleRedundancy(Redundancy redundancy) {
        this.redundancy = redundancy;
    }

    public List<NewDocumentType> getDocumentTypesWithStreamingCluster() {
        return this.documentTypes(this::hasIndexingModeStreaming);
    }

    public List<NewDocumentType> getDocumentTypesWithIndexedCluster() {
        return this.documentTypes(this::hasIndexingModeIndexed);
    }

    public List<NewDocumentType> getDocumentTypesWithStoreOnly() {
        return this.documentTypes(this::hasIndexingModeStoreOnly);
    }

    private List<NewDocumentType> documentTypes(Predicate<NewDocumentType> filter) {
        return this.documentDefinitions.values().stream().filter(filter).toList();
    }

    private boolean hasIndexingModeStreaming(NewDocumentType type) {
        if (this.searchCluster == null) {
            return false;
        }
        SchemaInfo schemaInfo = this.searchCluster.schemas().get(type.getName());
        return schemaInfo != null && schemaInfo.getIndexMode() == SchemaInfo.IndexMode.STREAMING;
    }

    private boolean hasIndexingModeIndexed(NewDocumentType type) {
        if (this.searchCluster == null) {
            return false;
        }
        SchemaInfo schemaInfo = this.searchCluster.schemas().get(type.getName());
        return schemaInfo != null && schemaInfo.getIndexMode() == SchemaInfo.IndexMode.INDEX;
    }

    private boolean hasIndexingModeStoreOnly(NewDocumentType type) {
        return !this.hasIndexingModeStreaming(type) && !this.hasIndexingModeIndexed(type);
    }

    public void getConfig(ProtonConfig.Builder builder) {
        boolean hasAnyNonIndexedSchema = false;
        for (NewDocumentType type : TopologicalDocumentTypeSorter.sort(this.documentDefinitions.values())) {
            ProtonConfig.Documentdb.Builder ddbB = new ProtonConfig.Documentdb.Builder();
            String docTypeName = type.getFullName().getName();
            boolean globalDocType = this.isGloballyDistributed(type);
            ddbB.inputdoctypename(docTypeName).configid(this.getConfigId()).visibilitydelay(this.visibilityDelay.doubleValue()).global(globalDocType);
            if (this.hasIndexingModeStreaming(type)) {
                hasAnyNonIndexedSchema = true;
                ddbB.configid(this.searchCluster.getDocumentDBConfigId(type.getFullName().getName()));
                ddbB.mode(ProtonConfig.Documentdb.Mode.Enum.STREAMING);
            } else if (this.hasIndexingModeIndexed(type)) {
                ddbB.configid(this.searchCluster.getDocumentDBConfigId(type.getFullName().getName()));
                ddbB.mode(ProtonConfig.Documentdb.Mode.Enum.INDEX);
            } else {
                hasAnyNonIndexedSchema = true;
                ddbB.mode(ProtonConfig.Documentdb.Mode.Enum.STORE_ONLY);
            }
            if (globalDocType) {
                ddbB.visibilitydelay(0.0);
            }
            builder.documentdb(ddbB);
        }
        if (hasAnyNonIndexedSchema) {
            builder.feeding.concurrency(Math.min(1.0, this.defaultFeedConcurrency * 2.0));
        } else {
            builder.feeding.concurrency(this.defaultFeedConcurrency);
        }
        builder.feeding.niceness(this.defaultFeedNiceness);
        builder.flush.memory.diskbloatfactor(0.25);
        builder.flush.memory.each.diskbloatfactor(0.25);
        builder.summary.log.chunk.compression.level(3);
        builder.summary.log.compact.compression.level(3);
        builder.forward_issues(this.forwardIssuesToQrs);
        builder.search.mmap.advise(this.searchMmapAdvise);
        int numDocumentDbs = builder.documentdb.size();
        builder.initialize(new ProtonConfig.Initialize.Builder().threads(numDocumentDbs + 1));
        if (this.resourceLimits != null) {
            this.resourceLimits.getConfig(builder);
        }
        if (this.tuning != null) {
            this.tuning.getConfig(builder);
        }
        if (this.redundancy != null) {
            this.redundancy.getConfig(builder);
        }
        this.setMaxFlushed(builder);
    }

    private void setMaxFlushed(ProtonConfig.Builder builder) {
        double concurrency = builder.feeding.build().concurrency();
        if (concurrency > this.defaultFeedConcurrency) {
            int maxFlushes = (int)Math.ceil(4.0 * concurrency);
            builder.index.maxflushed(maxFlushes);
        }
    }

    private boolean isGloballyDistributed(NewDocumentType docType) {
        return this.globallyDistributedDocuments.contains(docType);
    }

    public void getConfig(DispatchNodesConfig.Builder builder) {
        if (this.searchCluster != null) {
            this.searchCluster.getConfig(builder);
        }
    }

    public void getConfig(DispatchConfig.Builder builder) {
        if (this.searchCluster != null) {
            this.searchCluster.getConfig(builder);
        }
    }

    public IndexedSearchCluster getSearchCluster() {
        return this.searchCluster;
    }

    public boolean hasSearchCluster() {
        return this.searchCluster != null;
    }

    public IndexingDocproc getIndexingDocproc() {
        return this.indexingDocproc;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String toString() {
        return "content cluster '" + this.clusterName + "'";
    }

    @Override
    public Redundancy redundancy() {
        return this.redundancy;
    }

    public static class Builder
    extends VespaDomBuilder.DomConfigProducerBuilderBase<ContentSearchCluster> {
        private final Map<String, NewDocumentType> documentDefinitions;
        private final Set<NewDocumentType> globallyDistributedDocuments;
        private final double fractionOfMemoryReserved;

        public Builder(Map<String, NewDocumentType> documentDefinitions, Set<NewDocumentType> globallyDistributedDocuments, double fractionOfMemoryReserved) {
            this.documentDefinitions = documentDefinitions;
            this.globallyDistributedDocuments = globallyDistributedDocuments;
            this.fractionOfMemoryReserved = fractionOfMemoryReserved;
        }

        @Override
        protected ContentSearchCluster doBuild(DeployState deployState, TreeConfigProducer<AnyConfigProducer> ancestor, Element producerSpec) {
            ModelElement clusterElem = new ModelElement(producerSpec);
            String clusterName = ContentCluster.getClusterId(clusterElem);
            Boolean flushOnShutdownElem = clusterElem.childAsBoolean("engine.proton.flush-on-shutdown");
            Boolean syncTransactionLog = clusterElem.childAsBoolean("engine.proton.sync-transactionlog");
            ContentSearchCluster search = new ContentSearchCluster(ancestor, clusterName, deployState.getProperties().featureFlags(), this.documentDefinitions, this.globallyDistributedDocuments, this.getFlushOnShutdown(flushOnShutdownElem), syncTransactionLog, this.fractionOfMemoryReserved);
            ModelElement tuning = clusterElem.childByPath("engine.proton.tuning");
            if (tuning != null) {
                search.setTuning((Tuning)new DomSearchTuningBuilder().build(deployState, search, tuning.getXml()));
            }
            this.buildSearchCluster(deployState, clusterElem, clusterName, search);
            return search;
        }

        private boolean getFlushOnShutdown(Boolean flushOnShutdownElem) {
            return Objects.requireNonNullElse(flushOnShutdownElem, true);
        }

        private Double getQueryTimeout(ModelElement clusterElem) {
            return clusterElem.childAsDouble("engine.proton.query-timeout");
        }

        private void buildSearchCluster(DeployState deployState, ModelElement clusterElem, String clusterName, ContentSearchCluster search) {
            ModelElement docElem = clusterElem.child("documents");
            if (docElem == null) {
                return;
            }
            Double visibilityDelay = clusterElem.childAsDouble("engine.proton.visibility-delay");
            if (visibilityDelay != null) {
                search.setVisibilityDelay(visibilityDelay);
            }
            IndexedSearchCluster isc = new IndexedSearchCluster(search, clusterName, search, deployState.featureFlags());
            search.addSearchCluster(deployState, isc, this.getQueryTimeout(clusterElem), docElem.subElements("document"));
        }
    }
}

