/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.schema.RankProfileRegistry;
import com.yahoo.schema.Schema;
import com.yahoo.schema.document.ComplexAttributeFieldUtils;
import com.yahoo.schema.document.ImmutableSDField;
import com.yahoo.schema.processing.Processor;
import com.yahoo.vespa.documentmodel.DocumentSummary;
import com.yahoo.vespa.documentmodel.SummaryField;
import com.yahoo.vespa.documentmodel.SummaryTransform;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.logging.Level;

public class SummaryDiskAccessValidator
extends Processor {
    public SummaryDiskAccessValidator(Schema schema, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(schema, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        if (!validate) {
            return;
        }
        if (documentsOnly) {
            return;
        }
        for (DocumentSummary summary : this.schema.getSummaries().values()) {
            for (SummaryField summaryField : summary.getSummaryFields().values()) {
                LinkedHashSet<String> implicitDiskFields = new LinkedHashSet<String>();
                for (SummaryField.Source source : summaryField.getSources()) {
                    ImmutableSDField field = this.schema.getField(source.getName());
                    if (field == null) {
                        field = this.findFieldProducingSummaryField(source.getName(), this.schema).orElse(null);
                    }
                    if (field == null && !source.getName().equals("documentid")) {
                        throw new IllegalArgumentException(String.valueOf(summaryField) + " in " + String.valueOf(summary) + " references " + String.valueOf(source) + ", but this field does not exist");
                    }
                    if (this.isInMemory(field, summaryField) || summary.isFromDisk()) continue;
                    implicitDiskFields.add(summaryField.getName());
                }
                if (implicitDiskFields.isEmpty()) continue;
                this.deployLogger.logApplicationPackage(Level.WARNING, "In " + String.valueOf(this.schema) + ", " + String.valueOf(summary) + ": Fields " + String.valueOf(implicitDiskFields) + " references non-attribute fields: Using this summary will cause disk accesses. Set 'from-disk' on this document-summary to silence this warning.");
            }
        }
    }

    private boolean isInMemory(ImmutableSDField field, SummaryField summaryField) {
        if (field == null) {
            return false;
        }
        if (ComplexAttributeFieldUtils.isComplexFieldWithOnlyStructFieldAttributes(field) && (summaryField.getTransform() == SummaryTransform.ATTRIBUTECOMBINER || summaryField.getTransform() == SummaryTransform.MATCHED_ATTRIBUTE_ELEMENTS_FILTER)) {
            return true;
        }
        return field.doesAttributing();
    }

    private Optional<ImmutableSDField> findFieldProducingSummaryField(String name, Schema schema) {
        return schema.allFields().filter(field -> field.getSummaryFields().get(name) != null).findAny();
    }
}

