/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation;

import com.yahoo.config.model.api.Quota;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.Capacity;
import com.yahoo.config.provision.CapacityPolicies;
import com.yahoo.config.provision.ClusterMembership;
import com.yahoo.config.provision.ClusterResources;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.config.provision.Exclusivity;
import com.yahoo.config.provision.NodeResources;
import com.yahoo.config.provision.QuotaExceededException;
import com.yahoo.config.provision.SystemName;
import com.yahoo.config.provision.Zone;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.application.validation.Validation;
import com.yahoo.vespa.model.application.validation.Validator;
import java.math.BigDecimal;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class QuotaValidator
implements Validator {
    private static final Logger log = Logger.getLogger(QuotaValidator.class.getName());
    private static final Capacity zeroCapacity = Capacity.from((ClusterResources)new ClusterResources(0, 0, NodeResources.zero()));

    @Override
    public void validate(Validation.Context context) {
        Zone zone = context.deployState().zone();
        Exclusivity exclusivity = new Exclusivity(zone, context.deployState().featureFlags().sharedHosts());
        CapacityPolicies.Tuning tuning = new CapacityPolicies.Tuning(context.deployState().featureFlags().adminClusterArchitecture(), context.deployState().featureFlags().logserverNodeMemory());
        CapacityPolicies capacityPolicies = new CapacityPolicies(zone, exclusivity, context.model().applicationPackage().getApplicationId(), tuning);
        Quota quota = context.deployState().getProperties().quota();
        quota.maxClusterSize().ifPresent(maxClusterSize -> this.validateMaxClusterSize((int)maxClusterSize, context.model()));
        quota.budgetAsDecimal().ifPresent(budget -> this.validateBudget((BigDecimal)budget, context, capacityPolicies));
    }

    private void validateBudget(BigDecimal budget, Validation.Context context, CapacityPolicies capacityPolicies) {
        Zone zone = context.deployState().getProperties().zone();
        ApplicationId application = context.model().applicationPackage().getApplicationId();
        double maxSpend = 0.0;
        for (ClusterSpec spec : context.model().allClusters()) {
            if (this.adminClusterIds(context.model()).contains(spec.id())) continue;
            ClusterSpec cluster = (ClusterSpec)context.model().provisioned().clusters().get(spec.id());
            Capacity capacity = context.model().provisioned().capacities().getOrDefault(spec.id(), zeroCapacity);
            maxSpend += capacityPolicies.applyOn(capacity, cluster.isExclusive()).maxResources().cost();
        }
        double actualSpend = context.model().allocatedHosts().getHosts().stream().filter(hostSpec -> ((ClusterMembership)hostSpec.membership().get()).cluster().type() != ClusterSpec.Type.admin).mapToDouble(hostSpec -> hostSpec.advertisedResources().cost()).sum();
        if (Math.abs(actualSpend) < 0.01) {
            log.warning("Deploying application " + application + " with zero budget use.  This is suspicious, but not blocked");
            return;
        }
        QuotaValidator.throwIfBudgetNegative(actualSpend, budget, zone.system());
        QuotaValidator.throwIfBudgetExceeded(actualSpend, budget, zone.system(), true);
        if (!zone.environment().isTest()) {
            QuotaValidator.throwIfBudgetExceeded(maxSpend, budget, zone.system(), false);
        }
    }

    private Set<ClusterSpec.Id> adminClusterIds(VespaModel model) {
        return model.allocatedHosts().getHosts().stream().map(hostSpec -> ((ClusterMembership)hostSpec.membership().orElseThrow()).cluster()).filter(cluster -> cluster.type() == ClusterSpec.Type.admin).map(ClusterSpec::id).collect(Collectors.toCollection(() -> new LinkedHashSet()));
    }

    private void validateMaxClusterSize(int maxClusterSize, VespaModel model) {
        List<String> invalidClusters = model.provisioned().capacities().entrySet().stream().filter(entry -> entry.getValue() != null).filter(entry -> {
            Capacity cluster = (Capacity)entry.getValue();
            int clusterSize = cluster.maxResources().nodes();
            return clusterSize > maxClusterSize;
        }).map(Map.Entry::getKey).map(ClusterSpec.Id::value).toList();
        if (!invalidClusters.isEmpty()) {
            String clusterNames = String.join((CharSequence)", ", invalidClusters);
            throw new QuotaExceededException("Clusters " + clusterNames + " exceeded max cluster size of " + maxClusterSize);
        }
    }

    private static void throwIfBudgetNegative(double spend, BigDecimal budget, SystemName systemName) {
        if (budget.doubleValue() < 0.0) {
            throw new QuotaExceededException(QuotaValidator.quotaMessage("Please free up some capacity.", systemName, spend, budget, true));
        }
    }

    private static void throwIfBudgetExceeded(double spend, BigDecimal budget, SystemName systemName, boolean actual) {
        if (budget.doubleValue() < spend) {
            throw new QuotaExceededException(QuotaValidator.quotaMessage("Contact support to upgrade your plan.", systemName, spend, budget, actual));
        }
    }

    private static String quotaMessage(String message, SystemName system, double spend, BigDecimal budget, boolean actual) {
        String quotaDescription = String.format(Locale.ENGLISH, "The %s cost $%.2f but your remaining quota is $%.2f", actual ? "resources used" : "max resources specified", spend, budget);
        return (String)(system == SystemName.Public ? "" : system.value() + ": ") + quotaDescription + ": " + message;
    }
}

