/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.admin;

import com.yahoo.config.model.producer.TreeConfigProducer;
import com.yahoo.vespa.model.AbstractService;
import com.yahoo.vespa.model.PortAllocBridge;

public class Configserver
extends AbstractService {
    private static final long serialVersionUID = 1L;
    public static final int defaultRpcPort = 19070;
    private final int rpcPort;

    public Configserver(TreeConfigProducer<? super Configserver> parent, String name, int rpcPort) {
        super(parent, name);
        this.rpcPort = rpcPort;
        this.portsMeta.on(0).tag("rpc").tag("config");
        this.portsMeta.on(1).tag("http").tag("config").tag("state");
        this.setProp("clustertype", "admin");
        this.setProp("clustername", "admin");
    }

    @Override
    public void allocatePorts(int start, PortAllocBridge from) {
        if (this.requiresWantedPort()) {
            from.requirePort(start++, "rpc");
            from.requirePort(start++, "http");
        } else if (start == 0) {
            from.allocatePort("rpc");
            from.allocatePort("http");
        } else {
            from.wantPort(start++, "rpc");
            from.wantPort(start++, "http");
        }
    }

    @Override
    public int getWantedPort() {
        return this.rpcPort;
    }

    @Override
    public boolean requiresWantedPort() {
        return this.getId() < 2;
    }

    @Override
    public int getPortCount() {
        return 2;
    }

    private int getConfigServerRpcPort() {
        return this.getRelativePort(0);
    }

    private int getConfigServerHttpPort() {
        return this.getRelativePort(1);
    }

    @Override
    public int getHealthPort() {
        return this.getRelativePort(1);
    }
}

