/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.derived;

import com.yahoo.document.CollectionDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.NumericDataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.PredicateFieldValue;
import com.yahoo.document.datatypes.Raw;
import com.yahoo.document.datatypes.StringFieldValue;

public class Index {
    public static Type convertType(DataType fieldType) {
        FieldValue fval = fieldType.createFieldValue();
        if (fieldType instanceof NumericDataType) {
            return Type.INT64;
        }
        if (fval instanceof StringFieldValue) {
            return Type.TEXT;
        }
        if (fval instanceof Raw) {
            return Type.BOOLEANTREE;
        }
        if (fval instanceof PredicateFieldValue) {
            return Type.BOOLEANTREE;
        }
        if (fieldType instanceof CollectionDataType) {
            return Index.convertType(((CollectionDataType)fieldType).getNestedType());
        }
        throw new IllegalArgumentException("Don't know which index type to convert " + fieldType + " to");
    }

    public static class Type {
        public static final Type TEXT = new Type("text");
        public static final Type INT64 = new Type("long");
        public static final Type BOOLEANTREE = new Type("booleantree");
        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object other) {
            if (!(other instanceof Type)) {
                return false;
            }
            return this.name.equals(((Type)other).name);
        }

        public String toString() {
            return "type: " + this.name;
        }
    }
}

