/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.builder.xml;

import com.yahoo.component.Version;

public class ConfigModelId
implements Comparable<ConfigModelId> {
    private final String name;
    private final Version version;
    private final String stringValue;

    private ConfigModelId(String name, Version version) {
        this.name = name;
        this.version = version;
        this.stringValue = this.toStringValue();
    }

    public static ConfigModelId fromNameAndVersion(String tagName, String tagVersion) {
        return new ConfigModelId(tagName, Version.fromString((String)tagVersion));
    }

    public static ConfigModelId fromName(String tagName) {
        return new ConfigModelId(tagName, new Version(1));
    }

    public boolean equals(Object object) {
        if (!(object instanceof ConfigModelId)) {
            return false;
        }
        ConfigModelId other = (ConfigModelId)object;
        return this.name.equals(other.name) && this.version.equals((Object)other.version);
    }

    @Override
    public int compareTo(ConfigModelId other) {
        if (other == this) {
            return 0;
        }
        int cmp = this.name.compareTo(other.name);
        if (cmp == 0) {
            cmp = this.version.compareTo(other.version);
        }
        return cmp;
    }

    public String toString() {
        return this.stringValue;
    }

    public int hashCode() {
        return this.stringValue.hashCode();
    }

    public String getName() {
        return this.name;
    }

    Version getVersion() {
        return this.version;
    }

    private String toStringValue() {
        return this.name + "." + this.version;
    }
}

