/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.search;

import com.yahoo.config.provision.NodeResources;
import com.yahoo.vespa.config.search.core.ProtonConfig;

public class NodeResourcesTuning
implements ProtonConfig.Producer {
    private static final double SUMMARY_FILE_SIZE_AS_FRACTION_OF_MEMORY = 0.02;
    private static final double SUMMARY_CACHE_SIZE_AS_FRACTION_OF_MEMORY = 0.04;
    private static final double MEMORY_GAIN_AS_FRACTION_OF_MEMORY = 0.08;
    private static final double MIN_MEMORY_PER_FLUSH_THREAD_GB = 11.0;
    private static final double TLS_SIZE_FRACTION = 0.02;
    static final long MiB = 0x100000L;
    public static final long GiB = 0x40000000L;
    public static final long GB = 1000000000L;
    private final NodeResources resources;
    private final int threadsPerSearch;
    private final double fractionOfMemoryReserved;

    public NodeResourcesTuning(NodeResources resources, int threadsPerSearch, double fractionOfMemoryReserved) {
        this.resources = resources;
        this.threadsPerSearch = threadsPerSearch;
        this.fractionOfMemoryReserved = fractionOfMemoryReserved;
    }

    public void getConfig(ProtonConfig.Builder builder) {
        this.setHwInfo(builder);
        this.tuneDiskWriteSpeed(builder);
        this.tuneRequestThreads(builder);
        this.tuneDocumentStoreMaxFileSize(builder.summary.log);
        this.tuneFlushStrategyMemoryLimits(builder.flush.memory);
        this.tuneFlushStrategyTlsSize(builder.flush.memory);
        this.tuneFlushConcurrentThreads(builder.flush);
        this.tuneSummaryReadIo(builder.summary.read);
        this.tuneSummaryCache(builder.summary.cache);
        this.tuneSearchReadIo(builder.search.mmap);
    }

    private void tuneSummaryCache(ProtonConfig.Summary.Cache.Builder builder) {
        long memoryLimitBytes = (long)(this.usableMemoryGb() * 0.04 * 1.073741824E9);
        builder.maxbytes(memoryLimitBytes);
    }

    private void setHwInfo(ProtonConfig.Builder builder) {
        builder.hwinfo.disk.shared(true);
        builder.hwinfo.cpu.cores((int)this.resources.vcpu());
        builder.hwinfo.memory.size((long)(this.usableMemoryGb() * 1.073741824E9));
        builder.hwinfo.disk.size((long)(this.resources.diskGb() * 1.0E9));
    }

    private void tuneDiskWriteSpeed(ProtonConfig.Builder builder) {
        if (this.resources.diskSpeed() != NodeResources.DiskSpeed.fast) {
            builder.hwinfo.disk.writespeed(40.0);
        }
    }

    private void tuneDocumentStoreMaxFileSize(ProtonConfig.Summary.Log.Builder builder) {
        long fileSizeBytes = (long)Math.max(2.68435456E8, this.usableMemoryGb() * 1.073741824E9 * 0.02);
        builder.maxfilesize(fileSizeBytes);
    }

    private void tuneFlushStrategyMemoryLimits(ProtonConfig.Flush.Memory.Builder builder) {
        long memoryLimitBytes = (long)(this.usableMemoryGb() * 0.08 * 1.073741824E9);
        builder.maxmemory(memoryLimitBytes);
        builder.each.maxmemory(memoryLimitBytes);
    }

    private void tuneFlushConcurrentThreads(ProtonConfig.Flush.Builder builder) {
        int max_concurrent = 2;
        if (this.usableMemoryGb() < 11.0) {
            max_concurrent = 1;
        }
        double min_concurrent_mem = this.usableMemoryGb() / 11.0;
        builder.maxconcurrent(Math.min(max_concurrent, (int)Math.ceil(min_concurrent_mem)));
    }

    private void tuneFlushStrategyTlsSize(ProtonConfig.Flush.Memory.Builder builder) {
        long tlsSizeBytes = (long)(this.resources.diskGb() * 0.02 * 1.0E9);
        tlsSizeBytes = Long.max(2000000000L, Long.min(tlsSizeBytes, 100000000000L));
        builder.maxtlssize(tlsSizeBytes);
    }

    private void tuneSummaryReadIo(ProtonConfig.Summary.Read.Builder builder) {
        if (this.resources.diskSpeed() == NodeResources.DiskSpeed.fast) {
            builder.io(ProtonConfig.Summary.Read.Io.DIRECTIO);
        }
    }

    private void tuneSearchReadIo(ProtonConfig.Search.Mmap.Builder builder) {
        if (this.resources.diskSpeed() == NodeResources.DiskSpeed.fast) {
            builder.advise(ProtonConfig.Search.Mmap.Advise.RANDOM);
        }
    }

    private void tuneRequestThreads(ProtonConfig.Builder builder) {
        int numCores = (int)Math.ceil(this.resources.vcpu());
        builder.numsearcherthreads(Math.min((numCores * 4 + this.threadsPerSearch - 1) / this.threadsPerSearch * this.threadsPerSearch, numCores * this.threadsPerSearch));
        builder.numsummarythreads(numCores);
        builder.numthreadspersearch(this.threadsPerSearch);
    }

    private double usableMemoryGb() {
        double usableMemoryGb = this.resources.memoryGiB() - 0.7;
        return usableMemoryGb * (1.0 - this.fractionOfMemoryReserved);
    }
}

