/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.xml;

import com.yahoo.component.ComponentSpecification;
import com.yahoo.component.chain.dependencies.Dependencies;
import com.yahoo.component.chain.model.ChainedComponentModel;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.provision.DataplaneToken;
import com.yahoo.container.bundle.BundleInstantiationSpecification;
import com.yahoo.jdisc.http.filter.security.cloud.config.CloudTokenDataPlaneFilterConfig;
import com.yahoo.vespa.model.container.ApplicationContainerCluster;
import com.yahoo.vespa.model.container.http.Client;
import com.yahoo.vespa.model.container.http.Filter;
import java.time.Instant;
import java.util.Collection;
import java.util.List;

class CloudTokenDataPlaneFilter
extends Filter
implements CloudTokenDataPlaneFilterConfig.Producer {
    private final Collection<Client> clients;
    private final String tokenContext;

    CloudTokenDataPlaneFilter(ApplicationContainerCluster cluster, DeployState state) {
        super(CloudTokenDataPlaneFilter.model());
        this.clients = List.copyOf(cluster.getClients());
        this.tokenContext = "Vespa Cloud tenant data plane:%s".formatted(state.getProperties().applicationId().tenant().value());
    }

    private static ChainedComponentModel model() {
        return new ChainedComponentModel(new BundleInstantiationSpecification(new ComponentSpecification("com.yahoo.jdisc.http.filter.security.cloud.CloudTokenDataPlaneFilter"), null, new ComponentSpecification("jdisc-security-filters")), Dependencies.emptyDependencies());
    }

    public void getConfig(CloudTokenDataPlaneFilterConfig.Builder builder) {
        List<CloudTokenDataPlaneFilterConfig.Clients.Builder> clientsCfg = this.clients.stream().filter(c -> !c.tokens().isEmpty()).map(x -> new CloudTokenDataPlaneFilterConfig.Clients.Builder().id(x.id()).tokens(CloudTokenDataPlaneFilter.tokensConfig(x.tokens())).permissions(x.permissions().stream().map(Client.Permission::asString).sorted().toList())).toList();
        builder.clients(clientsCfg).tokenContext(this.tokenContext);
    }

    private static List<CloudTokenDataPlaneFilterConfig.Clients.Tokens.Builder> tokensConfig(Collection<DataplaneToken> tokens) {
        return tokens.stream().map(token -> new CloudTokenDataPlaneFilterConfig.Clients.Tokens.Builder().id(token.tokenId()).fingerprints(token.versions().stream().map(DataplaneToken.Version::fingerprint).toList()).checkAccessHashes(token.versions().stream().map(DataplaneToken.Version::checkAccessHash).toList()).expirations(token.versions().stream().map(v -> v.expiration().map(Instant::toString).orElse("<none>")).toList())).toList();
    }
}

