/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.graph;

import com.google.inject.Inject;
import com.yahoo.component.ComponentId;
import com.yahoo.config.model.ConfigModel;
import com.yahoo.config.model.ConfigModelContext;
import com.yahoo.config.model.ConfigModelInstanceFactory;
import com.yahoo.config.model.builder.xml.ConfigModelBuilder;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ModelNode<MODEL extends ConfigModel>
implements ConfigModelInstanceFactory<MODEL> {
    final ComponentId id;
    public final ConfigModelBuilder<MODEL> builder;
    final Class<MODEL> clazz;
    final Constructor<MODEL> constructor;
    final List<MODEL> instances = new ArrayList<MODEL>();
    private final Map<ComponentId, ModelNode> dependencies = new HashMap<ComponentId, ModelNode>();

    public ModelNode(ConfigModelBuilder<MODEL> builder) {
        this.id = builder.getId();
        this.builder = builder;
        this.clazz = builder.getModelClass();
        this.constructor = this.findConstructor(this.clazz);
    }

    private Constructor<MODEL> findConstructor(Class<MODEL> clazz) {
        for (Constructor<?> ctor : clazz.getDeclaredConstructors()) {
            if (ctor.getAnnotation(Inject.class) == null && ctor.getAnnotation(com.yahoo.component.annotation.Inject.class) == null) continue;
            return ctor;
        }
        return clazz.getDeclaredConstructors()[0];
    }

    boolean hasDependencies() {
        return !this.dependencies.isEmpty();
    }

    boolean dependsOn(ModelNode node) {
        return this.dependencies.containsKey(node.id);
    }

    int addDependenciesFrom(List<ModelNode> modelNodes) {
        int numDependencies = 0;
        for (Type param : this.constructor.getGenericParameterTypes()) {
            for (ModelNode node : modelNodes) {
                if (!param.equals(node.clazz) && !this.isCollectionOf(param, node.clazz)) continue;
                this.addDependency(node);
                ++numDependencies;
            }
        }
        return numDependencies;
    }

    private boolean isCollectionOf(Type type, Class<?> nodeClazz) {
        if (type instanceof ParameterizedType) {
            ParameterizedType t = (ParameterizedType)type;
            return t.getRawType().equals(Collection.class) && t.getActualTypeArguments().length == 1 && t.getActualTypeArguments()[0].equals(nodeClazz);
        }
        return false;
    }

    private boolean isCollection(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType t = (ParameterizedType)type;
            return t.getRawType().equals(Collection.class) && t.getActualTypeArguments().length == 1;
        }
        return false;
    }

    private void addDependency(ModelNode node) {
        this.dependencies.put(node.id, node);
    }

    Collection<ComponentId> listDependencyIds() {
        return this.dependencies.keySet();
    }

    @Override
    public MODEL createModel(ConfigModelContext context) {
        try {
            Type[] params = this.constructor.getGenericParameterTypes();
            if (params.length < 1 || !params[0].equals(ConfigModelContext.class)) {
                throw new IllegalArgumentException("Constructor for " + this.clazz.getName() + " must have as its first argument a " + ConfigModelContext.class.getName());
            }
            Object[] arguments = new Object[params.length];
            arguments[0] = context;
            for (int i = 1; i < params.length; ++i) {
                arguments[i] = this.findArgument(params[i]);
            }
            ConfigModel instance = (ConfigModel)this.constructor.newInstance(arguments);
            this.instances.add(instance);
            return (MODEL)instance;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException("Error constructing model '" + this.clazz.getName() + "'", e);
        }
    }

    private Object findArgument(Type param) {
        for (ModelNode dependency : this.dependencies.values()) {
            if (param.equals(dependency.clazz)) {
                return dependency.instances.get(0);
            }
            if (!this.isCollectionOf(param, dependency.clazz)) continue;
            return Collections.unmodifiableCollection(dependency.instances);
        }
        if (this.isCollection(param)) {
            return List.of();
        }
        throw new IllegalArgumentException("Unable to find constructor argument " + param + " for " + this.clazz.getName());
    }
}

