/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation.change;

import com.yahoo.config.application.api.ValidationId;
import com.yahoo.vespa.model.application.validation.Validation;
import com.yahoo.vespa.model.application.validation.change.ChangeValidator;
import com.yahoo.vespa.model.content.cluster.ContentCluster;

public class RedundancyIncreaseValidator
implements ChangeValidator {
    @Override
    public void validate(Validation.ChangeContext context) {
        for (ContentCluster currentCluster : context.previousModel().getContentClusters().values()) {
            ContentCluster nextCluster = context.model().getContentClusters().get(currentCluster.getSubId());
            if (nextCluster == null || this.redundancyOf(nextCluster) <= this.redundancyOf(currentCluster)) continue;
            context.invalid(ValidationId.redundancyIncrease, "Increasing redundancy from " + this.redundancyOf(currentCluster) + " to " + this.redundancyOf(nextCluster) + " in '" + currentCluster + ". This is a safe operation but verify that you have room for a " + this.redundancyOf(nextCluster) + "/" + this.redundancyOf(currentCluster) + "x increase in content size");
        }
    }

    private int redundancyOf(ContentCluster cluster) {
        return cluster.getRedundancy().effectiveFinalRedundancy();
    }
}

