/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.parser;

import com.yahoo.schema.RankProfile;
import com.yahoo.schema.RankProfileRegistry;
import com.yahoo.schema.Schema;
import com.yahoo.schema.document.RankType;
import com.yahoo.schema.parser.ParsedRankFunction;
import com.yahoo.schema.parser.ParsedRankProfile;
import java.util.List;

public class ParsedRankingConverter {
    private final RankProfileRegistry rankProfileRegistry;

    ParsedRankingConverter() {
        this(new RankProfileRegistry());
    }

    public ParsedRankingConverter(RankProfileRegistry rankProfileRegistry) {
        this.rankProfileRegistry = rankProfileRegistry;
    }

    void convertRankProfile(Schema schema, ParsedRankProfile parsed) {
        try {
            RankProfile profile = this.createProfile(schema, parsed.name());
            this.populateFrom(parsed, profile);
            this.rankProfileRegistry.add(profile);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("In " + parsed, e);
        }
    }

    private RankProfile createProfile(Schema schema, String name) {
        if (name.equals("default")) {
            return this.rankProfileRegistry.get(schema, "default");
        }
        return new RankProfile(name, schema, this.rankProfileRegistry);
    }

    private void populateFrom(ParsedRankProfile parsed, RankProfile profile) {
        parsed.getInherited().forEach(profile::inherit);
        parsed.isStrict().ifPresent(profile::setStrict);
        parsed.isUseSignificanceModel().ifPresent(profile::setUseSignificanceModel);
        parsed.getConstants().values().forEach(profile::add);
        parsed.getOnnxModels().forEach(profile::add);
        parsed.getInputs().forEach(profile::addInput);
        for (ParsedRankFunction func : parsed.getFunctions()) {
            String name = func.name();
            List<String> parameters = func.getParameters();
            String expression = func.getExpression();
            boolean inline = func.getInline();
            profile.addFunction(name, parameters, expression, inline);
        }
        parsed.getRankScoreDropLimit().ifPresent(profile::setRankScoreDropLimit);
        parsed.getSecondPhaseRankScoreDropLimit().ifPresent(profile::setSecondPhaseRankScoreDropLimit);
        parsed.getTermwiseLimit().ifPresent(profile::setTermwiseLimit);
        parsed.getPostFilterThreshold().ifPresent(profile::setPostFilterThreshold);
        parsed.getApproximateThreshold().ifPresent(profile::setApproximateThreshold);
        parsed.getTargetHitsMaxAdjustmentFactor().ifPresent(profile::setTargetHitsMaxAdjustmentFactor);
        parsed.getKeepRankCount().ifPresent(profile::setKeepRankCount);
        parsed.getMinHitsPerThread().ifPresent(profile::setMinHitsPerThread);
        parsed.getNumSearchPartitions().ifPresent(profile::setNumSearchPartitions);
        parsed.getNumThreadsPerSearch().ifPresent(profile::setNumThreadsPerSearch);
        parsed.getReRankCount().ifPresent(profile::setRerankCount);
        parsed.getMatchPhase().ifPresent(profile::setMatchPhase);
        parsed.getDiversity().ifPresent(profile::setDiversity);
        parsed.getFirstPhaseExpression().ifPresent(profile::setFirstPhaseRanking);
        parsed.getSecondPhaseExpression().ifPresent(profile::setSecondPhaseRanking);
        parsed.getGlobalPhaseExpression().ifPresent(profile::setGlobalPhaseRanking);
        parsed.getGlobalPhaseRerankCount().ifPresent(profile::setGlobalPhaseRerankCount);
        parsed.getMatchFeatures().forEach(profile::addMatchFeatures);
        parsed.getRankFeatures().forEach(profile::addRankFeatures);
        parsed.getSummaryFeatures().forEach(profile::addSummaryFeatures);
        parsed.getInheritedMatchFeatures().ifPresent(profile::setInheritedMatchFeatures);
        parsed.getInheritedSummaryFeatures().ifPresent(profile::setInheritedSummaryFeatures);
        if (parsed.getIgnoreDefaultRankFeatures()) {
            profile.setIgnoreDefaultRankFeatures(true);
        }
        parsed.getMutateOperations().forEach(profile::addMutateOperation);
        parsed.getFieldsWithRankFilter().forEach((fieldName, isFilter) -> profile.addRankSetting((String)fieldName, RankProfile.RankSetting.Type.PREFERBITVECTOR, isFilter));
        parsed.getFieldsWithRankWeight().forEach((fieldName, weight) -> profile.addRankSetting((String)fieldName, RankProfile.RankSetting.Type.WEIGHT, weight));
        parsed.getFieldsWithRankType().forEach((fieldName, rankType) -> profile.addRankSetting((String)fieldName, RankProfile.RankSetting.Type.RANKTYPE, (Object)RankType.fromString(rankType)));
        parsed.getRankProperties().forEach((key, values) -> {
            for (String value : values) {
                profile.addRankProperty((String)key, value);
            }
        });
    }
}

