/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.document.ArrayDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.StructDataType;
import com.yahoo.document.WeightedSetDataType;
import com.yahoo.schema.RankProfileRegistry;
import com.yahoo.schema.Schema;
import com.yahoo.schema.document.SDField;
import com.yahoo.schema.processing.Processor;
import com.yahoo.vespa.documentmodel.SummaryField;
import com.yahoo.vespa.documentmodel.SummaryTransform;
import com.yahoo.vespa.model.container.search.QueryProfiles;

public class SummaryDynamicStructsArrays
extends Processor {
    public SummaryDynamicStructsArrays(Schema schema, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(schema, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        if (!validate) {
            return;
        }
        for (SDField field : this.schema.allConcreteFields()) {
            DataType type = field.getDataType();
            if (!this.isNonStringArray(type) && !(type instanceof WeightedSetDataType) && !(type instanceof StructDataType)) continue;
            for (SummaryField sField : field.getSummaryFields().values()) {
                if (!sField.getTransform().equals((Object)SummaryTransform.DYNAMICTEASER)) continue;
                throw new IllegalArgumentException("For field '" + field.getName() + "': dynamic summary is illegal for fields of type struct, array or weighted set. Use an explicit summary class with explicit summary fields sourcing from the array/struct/weighted set.");
            }
        }
    }

    private boolean isNonStringArray(DataType type) {
        return type instanceof ArrayDataType && !type.equals((Object)DataType.getArray((DataType)DataType.STRING));
    }
}

