/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.search;

import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AnyConfigProducer;
import com.yahoo.config.model.producer.TreeConfigProducer;
import com.yahoo.container.QrSearchersConfig;
import com.yahoo.prelude.fastsearch.DocumentdbInfoConfig;
import com.yahoo.schema.DocumentOnlySchema;
import com.yahoo.schema.derived.AttributeFields;
import com.yahoo.schema.derived.DerivedConfiguration;
import com.yahoo.schema.derived.SchemaInfo;
import com.yahoo.search.config.ClusterConfig;
import com.yahoo.search.config.IndexInfoConfig;
import com.yahoo.search.config.SchemaInfoConfig;
import com.yahoo.vespa.config.search.AttributesConfig;
import com.yahoo.vespa.config.search.RankProfilesConfig;
import com.yahoo.vespa.config.search.SummaryConfig;
import com.yahoo.vespa.config.search.core.OnnxModelsConfig;
import com.yahoo.vespa.config.search.core.ProtonConfig;
import com.yahoo.vespa.config.search.core.RankingConstantsConfig;
import com.yahoo.vespa.config.search.core.RankingExpressionsConfig;
import com.yahoo.vespa.config.search.summary.JuniperrcConfig;
import com.yahoo.vespa.config.search.vsm.VsmfieldsConfig;
import com.yahoo.vespa.config.search.vsm.VsmsummaryConfig;
import com.yahoo.vespa.configdefinition.IlscriptsConfig;
import com.yahoo.vespa.model.search.DocumentDatabase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class SearchCluster
extends TreeConfigProducer<AnyConfigProducer>
implements DocumentdbInfoConfig.Producer,
IndexInfoConfig.Producer,
IlscriptsConfig.Producer,
SchemaInfoConfig.Producer {
    private final String clusterName;
    private int index;
    private Double queryTimeout;
    private Double visibilityDelay = 0.0;
    private final Map<String, SchemaInfo> schemas = new LinkedHashMap<String, SchemaInfo>();
    private final Map<String, DocumentDatabase> documentDbs = new LinkedHashMap<String, DocumentDatabase>();
    private final Map<String, AttributesProducer> documentDBProducerForStreaming = new HashMap<String, AttributesProducer>();
    private final List<LegacyStreamingProxy> legacyproxy = new ArrayList<LegacyStreamingProxy>();

    public SearchCluster(TreeConfigProducer<?> parent, String clusterName, int index) {
        super(parent, "cluster." + clusterName);
        this.clusterName = clusterName;
        this.index = index;
    }

    public String getStorageRouteSpec() {
        return this.getClusterName();
    }

    public void add(SchemaInfo schema) {
        this.schemas.put(schema.name(), schema);
    }

    public boolean hasDocumentDB(String name) {
        return this.documentDbs.containsKey(name);
    }

    public DocumentDatabase getDocumentDB(String name) {
        return this.documentDbs.get(name);
    }

    public String getConfigId(String name) {
        DocumentDatabase db = this.documentDbs.get(name);
        return db != null ? db.getConfigId() : "";
    }

    public Map<String, SchemaInfo> schemas() {
        return Collections.unmodifiableMap(this.schemas);
    }

    public void deriveFromSchemas(DeployState deployState) {
        for (SchemaInfo spec : this.schemas().values()) {
            if (spec.fullSchema() instanceof DocumentOnlySchema) continue;
            String schemaName = spec.fullSchema().getName();
            DerivedConfiguration derived = new DerivedConfiguration(deployState, spec.fullSchema(), spec.getIndexMode());
            this.documentDbs.put(schemaName, new DocumentDatabase(this, schemaName, derived));
            if (spec.getIndexMode() != SchemaInfo.IndexMode.STREAMING) continue;
            TreeConfigProducer parent = (TreeConfigProducer)this.getParent();
            this.documentDBProducerForStreaming.put(schemaName, new AttributesProducer(parent, schemaName, derived));
            this.legacyproxy.add(new LegacyStreamingProxy(parent, this.clusterName, schemaName, derived));
        }
    }

    public List<DocumentDatabase> getDocumentDbs() {
        return this.documentDbs.values().stream().toList();
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public final boolean hasStreaming() {
        return this.schemas().values().stream().anyMatch(schema -> schema.getIndexMode() == SchemaInfo.IndexMode.STREAMING);
    }

    public final boolean hasIndexed() {
        return this.schemas().values().stream().anyMatch(schema -> schema.getIndexMode() == SchemaInfo.IndexMode.INDEX);
    }

    public final void setQueryTimeout(Double to) {
        this.queryTimeout = to;
    }

    public final void setVisibilityDelay(double delay) {
        this.visibilityDelay = delay;
    }

    public final Double getVisibilityDelay() {
        return this.visibilityDelay;
    }

    public final Double getQueryTimeout() {
        return this.queryTimeout;
    }

    public final void setClusterIndex(int index) {
        this.index = index;
    }

    public final int getClusterIndex() {
        return this.index;
    }

    public void fillDocumentDBConfig(String documentType, ProtonConfig.Documentdb.Builder builder) {
        DocumentDatabase db = this.documentDbs.get(documentType);
        if (db != null) {
            builder.inputdoctypename(documentType);
            if (db.getDerivedConfiguration().isStreaming()) {
                builder.configid(this.documentDBProducerForStreaming.get(documentType).getConfigId());
            } else {
                builder.configid(db.getConfigId());
            }
        }
    }

    public QrSearchersConfig.Searchcluster.Builder getQrSearcherConfig() {
        QrSearchersConfig.Searchcluster.Builder builder = new QrSearchersConfig.Searchcluster.Builder().name(this.getClusterName()).rankprofiles_configid(this.getConfigId()).storagecluster(new QrSearchersConfig.Searchcluster.Storagecluster.Builder().routespec(this.getStorageRouteSpec())).indexingmode(this.hasStreaming() ? QrSearchersConfig.Searchcluster.Indexingmode.STREAMING : QrSearchersConfig.Searchcluster.Indexingmode.REALTIME);
        for (SchemaInfo spec : this.schemas().values()) {
            builder.searchdef(spec.fullSchema().getName());
        }
        return builder;
    }

    public void getConfig(DocumentdbInfoConfig.Builder builder) {
        for (DocumentDatabase db : this.documentDbs.values()) {
            DocumentdbInfoConfig.Documentdb.Builder docDb = new DocumentdbInfoConfig.Documentdb.Builder().name(db.getName()).mode(db.getDerivedConfiguration().isStreaming() ? DocumentdbInfoConfig.Documentdb.Mode.Enum.STREAMING : DocumentdbInfoConfig.Documentdb.Mode.Enum.INDEX);
            builder.documentdb(docDb);
        }
    }

    public void getConfig(IndexInfoConfig.Builder builder) {
        new Join(this.documentDbs.values()).getConfig(builder);
    }

    public void getConfig(SchemaInfoConfig.Builder builder) {
        new Join(this.documentDbs.values()).getConfig(builder);
    }

    public void getConfig(IlscriptsConfig.Builder builder) {
        new Join(this.documentDbs.values()).getConfig(builder);
    }

    public void getConfig(AttributesConfig.Builder builder) {
        new Join(this.documentDbs.values()).getConfig(builder);
    }

    public void getConfig(ClusterConfig.Builder builder) {
        builder.clusterId(this.getClusterIndex());
        builder.clusterName(this.getClusterName());
        builder.storageRoute(this.getClusterName());
        builder.configid(this.getConfigId());
        if (this.visibilityDelay != null) {
            builder.cacheTimeout(SearchCluster.convertVisibilityDelay(this.visibilityDelay).doubleValue());
        }
        if (this.hasStreaming()) {
            builder.indexMode(ClusterConfig.IndexMode.Enum.STREAMING);
        } else {
            builder.indexMode(ClusterConfig.IndexMode.Enum.INDEX);
        }
    }

    private static Double convertVisibilityDelay(Double visibilityDelay) {
        return visibilityDelay < 1.0 ? 0.0 : visibilityDelay;
    }

    public String toString() {
        return "search-capable cluster '" + this.clusterName + "'";
    }

    private static class AttributesProducer
    extends AnyConfigProducer
    implements AttributesConfig.Producer {
        private final DerivedConfiguration derived;

        AttributesProducer(TreeConfigProducer<AnyConfigProducer> parent, String docType, DerivedConfiguration derived) {
            super(parent, docType);
            this.derived = derived;
        }

        public void getConfig(AttributesConfig.Builder builder) {
            this.derived.getConfig(builder, AttributeFields.FieldSet.FAST_ACCESS);
        }
    }

    private static class LegacyStreamingProxy
    extends TreeConfigProducer<AnyConfigProducer>
    implements AttributesConfig.Producer,
    RankProfilesConfig.Producer,
    RankingConstantsConfig.Producer,
    RankingExpressionsConfig.Producer,
    OnnxModelsConfig.Producer,
    JuniperrcConfig.Producer,
    SummaryConfig.Producer,
    VsmsummaryConfig.Producer,
    VsmfieldsConfig.Producer {
        private final DocumentDatabase db;

        LegacyStreamingProxy(TreeConfigProducer<AnyConfigProducer> parent, String clusterName, String schemaName, DerivedConfiguration derived) {
            super(parent, "cluster." + clusterName + "." + schemaName);
            this.db = new DocumentDatabase(this, schemaName, derived);
        }

        public void getConfig(SummaryConfig.Builder builder) {
            this.db.getConfig(builder);
        }

        public void getConfig(AttributesConfig.Builder builder) {
            this.db.getConfig(builder);
        }

        public void getConfig(OnnxModelsConfig.Builder builder) {
            this.db.getConfig(builder);
        }

        public void getConfig(RankingConstantsConfig.Builder builder) {
            this.db.getConfig(builder);
        }

        public void getConfig(RankProfilesConfig.Builder builder) {
            this.db.getConfig(builder);
        }

        public void getConfig(RankingExpressionsConfig.Builder builder) {
            this.db.getConfig(builder);
        }

        public void getConfig(JuniperrcConfig.Builder builder) {
            this.db.getConfig(builder);
        }

        public void getConfig(VsmfieldsConfig.Builder builder) {
            this.db.getConfig(builder);
        }

        public void getConfig(VsmsummaryConfig.Builder builder) {
            this.db.getConfig(builder);
        }
    }

    private record Join(Collection<DocumentDatabase> docDbs) {
        public void getConfig(IndexInfoConfig.Builder builder) {
            for (DocumentDatabase docDb : this.docDbs) {
                docDb.getConfig(builder);
            }
        }

        public void getConfig(SchemaInfoConfig.Builder builder) {
            for (DocumentDatabase docDb : this.docDbs) {
                docDb.getConfig(builder);
            }
        }

        public void getConfig(IlscriptsConfig.Builder builder) {
            for (DocumentDatabase docDb : this.docDbs) {
                docDb.getConfig(builder);
            }
        }

        public void getConfig(AttributesConfig.Builder builder) {
            for (DocumentDatabase docDb : this.docDbs) {
                docDb.getConfig(builder);
            }
        }
    }
}

