/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.component;

import com.yahoo.vespa.model.container.component.BindingPattern;
import java.util.Objects;
import java.util.Optional;

public class UserBindingPattern
extends BindingPattern {
    private final Optional<String> originalPort;

    private UserBindingPattern(String scheme, String host, String port, String path) {
        super(scheme, host, port, path);
        this.originalPort = null;
    }

    private UserBindingPattern(String scheme, String host, String port, Optional<String> originalPort, String path) {
        super(scheme, host, port, path);
        this.originalPort = originalPort;
    }

    private UserBindingPattern(String binding) {
        super(binding);
        this.originalPort = null;
    }

    public static UserBindingPattern fromHttpPath(String path) {
        return new UserBindingPattern("http", "*", null, path);
    }

    public static UserBindingPattern fromPattern(String binding) {
        return new UserBindingPattern(binding);
    }

    public UserBindingPattern withOverriddenPort(int port) {
        return new UserBindingPattern(this.scheme(), this.host(), Integer.toString(port), this.port(), this.path());
    }

    @Override
    public Optional<String> originalPort() {
        return Objects.isNull(this.originalPort) ? this.port() : this.originalPort;
    }

    public String toString() {
        return "UserBindingPattern{scheme='" + this.scheme() + "', host='" + this.host() + "', port='" + (String)this.port().orElse(null) + "', path='" + this.path() + "'}";
    }
}

