/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation;

import com.yahoo.config.application.api.DeploymentInstanceSpec;
import com.yahoo.config.application.api.DeploymentSpec;
import com.yahoo.config.provision.InstanceName;
import com.yahoo.vespa.model.application.validation.Validation;
import com.yahoo.vespa.model.application.validation.Validator;
import com.yahoo.vespa.model.container.ContainerModel;
import java.io.Reader;
import java.util.List;
import java.util.Optional;

public class DeploymentSpecValidator
implements Validator {
    @Override
    public void validate(Validation.Context context) {
        Optional deployment = context.deployState().getApplicationPackage().getDeployment();
        if (deployment.isEmpty()) {
            return;
        }
        Reader deploymentReader = (Reader)deployment.get();
        DeploymentSpec deploymentSpec = DeploymentSpec.fromXml((Reader)deploymentReader);
        List<ContainerModel> containers = context.model().getRoot().configModelRepo().getModels(ContainerModel.class);
        for (DeploymentInstanceSpec instance : deploymentSpec.instances()) {
            instance.endpoints().forEach(endpoint -> DeploymentSpecValidator.requireClusterId(context, containers, instance.name(), "Endpoint '" + endpoint.endpointId() + "'", endpoint.containerId()));
        }
    }

    private static void requireClusterId(Validation.Context context, List<ContainerModel> containers, InstanceName instanceName, String endpoint, String id) {
        if (containers.stream().noneMatch(container -> container.getCluster().getName().equals(id))) {
            context.illegal(endpoint + " in instance " + instanceName + ": '" + id + "' specified in deployment.xml does not match any container cluster ID");
        }
    }
}

