/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.search;

import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AnyConfigProducer;
import com.yahoo.config.model.producer.TreeConfigProducer;
import com.yahoo.prelude.fastsearch.DocumentdbInfoConfig;
import com.yahoo.schema.derived.SchemaInfo;
import com.yahoo.search.config.IndexInfoConfig;
import com.yahoo.search.config.SchemaInfoConfig;
import com.yahoo.vespa.config.search.AttributesConfig;
import com.yahoo.vespa.config.search.core.ProtonConfig;
import com.yahoo.vespa.configdefinition.IlscriptsConfig;
import com.yahoo.vespa.model.search.DocumentDatabase;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class SearchCluster
extends TreeConfigProducer<AnyConfigProducer>
implements DocumentdbInfoConfig.Producer,
IndexInfoConfig.Producer,
IlscriptsConfig.Producer,
SchemaInfoConfig.Producer {
    private final String clusterName;
    private int index;
    private Double queryTimeout;
    private Double visibilityDelay = 0.0;
    private final Map<String, SchemaInfo> schemas = new LinkedHashMap<String, SchemaInfo>();
    private final List<DocumentDatabase> documentDbs = new LinkedList<DocumentDatabase>();

    public SearchCluster(TreeConfigProducer<?> parent, String clusterName, int index) {
        super(parent, "cluster." + clusterName);
        this.clusterName = clusterName;
        this.index = index;
    }

    public void add(SchemaInfo schema) {
        this.schemas.put(schema.name(), schema);
    }

    public void add(DocumentDatabase db) {
        this.documentDbs.add(db);
    }

    public boolean hasDocumentDB(String name) {
        for (DocumentDatabase db : this.documentDbs) {
            if (!db.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public String getConfigId(String name) {
        for (DocumentDatabase db : this.documentDbs) {
            if (!db.getName().equals(name)) continue;
            return db.getConfigId();
        }
        return "";
    }

    public Map<String, SchemaInfo> schemas() {
        return Collections.unmodifiableMap(this.schemas);
    }

    public abstract void deriveFromSchemas(DeployState var1);

    public List<DocumentDatabase> getDocumentDbs() {
        return Collections.unmodifiableList(this.documentDbs);
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public final String getIndexingModeName() {
        return this.getIndexingMode().getName();
    }

    public final boolean isStreaming() {
        return this.getIndexingMode() == IndexingMode.STREAMING;
    }

    public final void setQueryTimeout(Double to) {
        this.queryTimeout = to;
    }

    public final void setVisibilityDelay(double delay) {
        this.visibilityDelay = delay;
    }

    protected abstract IndexingMode getIndexingMode();

    public final Double getVisibilityDelay() {
        return this.visibilityDelay;
    }

    public final Double getQueryTimeout() {
        return this.queryTimeout;
    }

    public final void setClusterIndex(int index) {
        this.index = index;
    }

    public final int getClusterIndex() {
        return this.index;
    }

    public void fillDocumentDBConfig(String documentType, ProtonConfig.Documentdb.Builder builder) {
        for (DocumentDatabase sdoc : this.documentDbs) {
            if (!sdoc.getName().equals(documentType)) continue;
            this.fillDocumentDBConfig(sdoc, builder);
            return;
        }
    }

    protected void fillDocumentDBConfig(DocumentDatabase sdoc, ProtonConfig.Documentdb.Builder ddbB) {
        ddbB.inputdoctypename(sdoc.getSchemaName()).configid(sdoc.getConfigId());
    }

    public void getConfig(DocumentdbInfoConfig.Builder builder) {
        for (DocumentDatabase db : this.documentDbs) {
            DocumentdbInfoConfig.Documentdb.Builder docDb = new DocumentdbInfoConfig.Documentdb.Builder().name(db.getName()).mode(db.getDerivedConfiguration().isStreaming() ? DocumentdbInfoConfig.Documentdb.Mode.Enum.STREAMING : DocumentdbInfoConfig.Documentdb.Mode.Enum.INDEX);
            builder.documentdb(docDb);
        }
    }

    public void getConfig(IndexInfoConfig.Builder builder) {
        new Join(this.documentDbs).getConfig(builder);
    }

    public void getConfig(SchemaInfoConfig.Builder builder) {
        new Join(this.documentDbs).getConfig(builder);
    }

    public void getConfig(IlscriptsConfig.Builder builder) {
        new Join(this.documentDbs).getConfig(builder);
    }

    public void getConfig(AttributesConfig.Builder builder) {
        new Join(this.documentDbs).getConfig(builder);
    }

    public String toString() {
        return "search-capable cluster '" + this.clusterName + "'";
    }

    public static final class IndexingMode {
        public static final IndexingMode REALTIME = new IndexingMode("REALTIME");
        public static final IndexingMode STREAMING = new IndexingMode("STREAMING");
        private final String name;

        private IndexingMode(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return "indexingmode: " + this.name;
        }
    }

    private record Join(List<DocumentDatabase> docDbs) {
        public void getConfig(IndexInfoConfig.Builder builder) {
            for (DocumentDatabase docDb : this.docDbs) {
                docDb.getConfig(builder);
            }
        }

        public void getConfig(SchemaInfoConfig.Builder builder) {
            for (DocumentDatabase docDb : this.docDbs) {
                docDb.getConfig(builder);
            }
        }

        public void getConfig(IlscriptsConfig.Builder builder) {
            for (DocumentDatabase docDb : this.docDbs) {
                docDb.getConfig(builder);
            }
        }

        public void getConfig(AttributesConfig.Builder builder) {
            for (DocumentDatabase docDb : this.docDbs) {
                docDb.getConfig(builder);
            }
        }
    }
}

