/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.search;

import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.container.QrSearchersConfig;
import com.yahoo.prelude.semantics.SemanticRulesConfig;
import com.yahoo.schema.RankProfile;
import com.yahoo.schema.Schema;
import com.yahoo.schema.derived.FileDistributedOnnxModels;
import com.yahoo.schema.derived.SchemaInfo;
import com.yahoo.search.config.IndexInfoConfig;
import com.yahoo.search.config.SchemaInfoConfig;
import com.yahoo.search.dispatch.Dispatcher;
import com.yahoo.search.dispatch.ReconfigurableDispatcher;
import com.yahoo.search.handler.observability.SearchStatusExtension;
import com.yahoo.search.pagetemplates.PageTemplatesConfig;
import com.yahoo.search.query.profile.compiled.CompiledQueryProfileRegistry;
import com.yahoo.search.query.profile.config.QueryProfilesConfig;
import com.yahoo.search.ranking.GlobalPhaseRanker;
import com.yahoo.search.ranking.RankProfilesEvaluatorFactory;
import com.yahoo.vespa.configdefinition.IlscriptsConfig;
import com.yahoo.vespa.model.container.ApplicationContainerCluster;
import com.yahoo.vespa.model.container.component.Component;
import com.yahoo.vespa.model.container.component.ContainerSubsystem;
import com.yahoo.vespa.model.container.search.DispatcherComponent;
import com.yahoo.vespa.model.container.search.PageTemplates;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import com.yahoo.vespa.model.container.search.RankProfilesEvaluatorComponent;
import com.yahoo.vespa.model.container.search.SemanticRules;
import com.yahoo.vespa.model.container.search.searchchain.SearchChains;
import com.yahoo.vespa.model.search.DocumentDatabase;
import com.yahoo.vespa.model.search.IndexedSearchCluster;
import com.yahoo.vespa.model.search.SearchCluster;
import com.yahoo.vespa.model.search.StreamingSearchCluster;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ContainerSearch
extends ContainerSubsystem<SearchChains>
implements IndexInfoConfig.Producer,
IlscriptsConfig.Producer,
QrSearchersConfig.Producer,
QueryProfilesConfig.Producer,
SemanticRulesConfig.Producer,
PageTemplatesConfig.Producer,
SchemaInfoConfig.Producer {
    public static final String QUERY_PROFILE_REGISTRY_CLASS = CompiledQueryProfileRegistry.class.getName();
    private final ApplicationContainerCluster owningCluster;
    private final List<SearchCluster> searchClusters = new LinkedList<SearchCluster>();
    private final Collection<String> schemasWithGlobalPhase;
    private final ApplicationPackage app;
    private QueryProfiles queryProfiles;
    private SemanticRules semanticRules;
    private PageTemplates pageTemplates;

    public ContainerSearch(DeployState deployState, ApplicationContainerCluster cluster, SearchChains chains) {
        super(chains);
        this.schemasWithGlobalPhase = ContainerSearch.getSchemasWithGlobalPhase(deployState);
        this.app = deployState.getApplicationPackage();
        this.owningCluster = cluster;
        this.owningCluster.addComponent(Component.fromClassAndBundle(CompiledQueryProfileRegistry.class, "container-search-and-docproc"));
        this.owningCluster.addComponent(Component.fromClassAndBundle(com.yahoo.search.schema.SchemaInfo.class, "container-search-and-docproc"));
        this.owningCluster.addComponent(Component.fromClassAndBundle(SearchStatusExtension.class, "container-search-and-docproc"));
        this.owningCluster.addComponent(Component.fromClassAndBundle(RankProfilesEvaluatorFactory.class, "container-search-and-docproc"));
        this.owningCluster.addComponent(Component.fromClassAndBundle(GlobalPhaseRanker.class, "container-search-and-docproc"));
        cluster.addSearchAndDocprocBundles();
    }

    private static Collection<String> getSchemasWithGlobalPhase(DeployState state) {
        HashSet<String> res = new HashSet<String>();
        for (Schema schema : state.getSchemas()) {
            for (RankProfile rp : state.rankProfileRegistry().rankProfilesOf(schema)) {
                if (rp.getGlobalPhase() == null) continue;
                res.add(schema.getName());
            }
        }
        return res;
    }

    public void connectSearchClusters(Map<String, SearchCluster> searchClusters) {
        this.searchClusters.addAll(searchClusters.values());
        this.initializeDispatchers(searchClusters.values());
        this.initializeSearchChains(searchClusters);
    }

    private void initializeDispatchers(Collection<SearchCluster> searchClusters) {
        for (SearchCluster searchCluster : searchClusters) {
            if (searchCluster instanceof IndexedSearchCluster) {
                IndexedSearchCluster indexed = (IndexedSearchCluster)searchCluster;
                Class dispatcherClass = System.getProperty("vespa.local", "false").equals("true") ? Dispatcher.class : ReconfigurableDispatcher.class;
                DispatcherComponent dispatcher = new DispatcherComponent(indexed, dispatcherClass);
                this.owningCluster.addComponent(dispatcher);
            }
            for (DocumentDatabase documentDb : searchCluster.getDocumentDbs()) {
                if (!this.schemasWithGlobalPhase.contains(documentDb.getSchemaName())) continue;
                RankProfilesEvaluatorComponent factory = new RankProfilesEvaluatorComponent(documentDb);
                if (this.owningCluster.getComponentsMap().containsKey(factory.getComponentId())) continue;
                FileDistributedOnnxModels onnxModels = documentDb.getDerivedConfiguration().getRankProfileList().getOnnxModels();
                onnxModels.asMap().forEach((__, model) -> this.owningCluster.onnxModelCostCalculator().registerModel(this.app.getFile(model.getFilePath()), model.onnxModelOptions()));
                this.owningCluster.addComponent(factory);
            }
        }
    }

    public void initializeSearchChains(Map<String, ? extends SearchCluster> searchClusters) {
        ((SearchChains)this.getChains()).initialize(searchClusters);
    }

    public void setQueryProfiles(QueryProfiles queryProfiles) {
        this.queryProfiles = queryProfiles;
    }

    public void setSemanticRules(SemanticRules semanticRules) {
        this.semanticRules = semanticRules;
    }

    public void setPageTemplates(PageTemplates pageTemplates) {
        this.pageTemplates = pageTemplates;
    }

    public void getConfig(QueryProfilesConfig.Builder builder) {
        if (this.queryProfiles != null) {
            this.queryProfiles.getConfig(builder);
        }
    }

    public void getConfig(SemanticRulesConfig.Builder builder) {
        if (this.semanticRules != null) {
            this.semanticRules.getConfig(builder);
        }
    }

    public void getConfig(PageTemplatesConfig.Builder builder) {
        if (this.pageTemplates != null) {
            this.pageTemplates.getConfig(builder);
        }
    }

    public void getConfig(IndexInfoConfig.Builder builder) {
        for (SearchCluster sc : this.searchClusters) {
            sc.getConfig(builder);
        }
    }

    public void getConfig(IlscriptsConfig.Builder builder) {
        for (SearchCluster sc : this.searchClusters) {
            sc.getConfig(builder);
        }
    }

    public void getConfig(SchemaInfoConfig.Builder builder) {
        for (SearchCluster sc : this.searchClusters) {
            sc.getConfig(builder);
        }
    }

    public void getConfig(QrSearchersConfig.Builder builder) {
        for (int i = 0; i < this.searchClusters.size(); ++i) {
            SearchCluster sys = ContainerSearch.findClusterWithId(this.searchClusters, i);
            QrSearchersConfig.Searchcluster.Builder scB = new QrSearchersConfig.Searchcluster.Builder().name(sys.getClusterName());
            for (SchemaInfo spec : sys.schemas().values()) {
                scB.searchdef(spec.fullSchema().getName());
            }
            scB.rankprofiles_configid(sys.getConfigId());
            scB.indexingmode(QrSearchersConfig.Searchcluster.Indexingmode.Enum.valueOf((String)sys.getIndexingModeName()));
            if (!(sys instanceof IndexedSearchCluster)) {
                scB.storagecluster(new QrSearchersConfig.Searchcluster.Storagecluster.Builder().routespec(((StreamingSearchCluster)sys).getStorageRouteSpec()));
            }
            builder.searchcluster(scB);
        }
    }

    private static SearchCluster findClusterWithId(List<SearchCluster> clusters, int index) {
        for (SearchCluster sys : clusters) {
            if (sys.getClusterIndex() != index) continue;
            return sys;
        }
        throw new IllegalArgumentException("No search cluster with index " + index + " exists");
    }
}

