/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.schema.RankProfileRegistry;
import com.yahoo.schema.Schema;
import com.yahoo.schema.document.MatchType;
import com.yahoo.schema.document.SDField;
import com.yahoo.schema.document.Stemming;
import com.yahoo.schema.processing.Processor;
import com.yahoo.vespa.model.container.search.QueryProfiles;

public class WordMatch
extends Processor {
    public WordMatch(Schema schema, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(schema, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        for (SDField field : this.schema.allConcreteFields()) {
            this.processFieldRecursive(field);
        }
    }

    private void processFieldRecursive(SDField field) {
        this.processField(field);
        for (SDField structField : field.getStructFields()) {
            this.processField(structField);
        }
    }

    private void processField(SDField field) {
        if (!field.getMatching().getType().equals((Object)MatchType.WORD)) {
            return;
        }
        field.setStemming(Stemming.NONE);
        field.getNormalizing().inferLowercase();
        field.addQueryCommand("word");
    }
}

