/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.document.DataType;
import com.yahoo.document.PrimitiveDataType;
import com.yahoo.schema.RankProfileRegistry;
import com.yahoo.schema.Schema;
import com.yahoo.schema.document.ImmutableSDField;
import com.yahoo.schema.processing.Processor;
import com.yahoo.vespa.documentmodel.DocumentSummary;
import com.yahoo.vespa.documentmodel.SummaryField;
import com.yahoo.vespa.documentmodel.SummaryTransform;
import com.yahoo.vespa.model.container.search.QueryProfiles;

public class TokensTransformValidator
extends Processor {
    public TokensTransformValidator(Schema schema, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(schema, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        if (!validate || documentsOnly) {
            return;
        }
        for (DocumentSummary summary : this.schema.getSummaries().values()) {
            for (SummaryField summaryField : summary.getSummaryFields().values()) {
                DataType type;
                PrimitiveDataType innerType;
                ImmutableSDField field;
                String source;
                if (!summaryField.getTransform().isTokens() || (source = summaryField.getSingleSource()) == null || (field = this.schema.getField(source)) == null || (innerType = (type = field.getDataType()).getPrimitiveType()) == DataType.STRING) continue;
                throw new IllegalArgumentException("For schema '" + this.schema.getName() + "', document-summary '" + summary.getName() + "', summary field '" + summaryField.getName() + "', source field '" + field.getName() + "', source field type '" + type.getName() + "': transform '" + SummaryTransform.TOKENS.getName() + "' is only allowed for fields of type string, array<string> or weightedset<string>");
            }
        }
    }
}

