/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.processing;

import com.yahoo.document.DataType;
import com.yahoo.schema.Schema;
import com.yahoo.schema.document.ImmutableSDField;
import com.yahoo.vespa.documentmodel.SummaryField;

public class DynamicSummaryTransformUtils {
    public static boolean hasSupportedType(SummaryField field) {
        return DynamicSummaryTransformUtils.isSupportedType(field.getDataType());
    }

    public static boolean isSupportedType(DataType type) {
        return DynamicSummaryTransformUtils.isOriginalSupportedType(type) || DynamicSummaryTransformUtils.isNewSupportedType(type);
    }

    private static boolean isOriginalSupportedType(DataType type) {
        return type == DataType.STRING || type == DataType.URI;
    }

    private static boolean isNewSupportedType(DataType type) {
        return type.equals((Object)DataType.getArray((DataType)DataType.STRING));
    }

    public static boolean summaryFieldIsPopulatedBySourceField(DataType sourceFieldType) {
        return false;
    }

    public static boolean summaryFieldIsRequiredInDocumentType(SummaryField summaryField) {
        return DynamicSummaryTransformUtils.summaryFieldIsPopulatedBySourceField(summaryField.getDataType());
    }

    public static String getSource(SummaryField summaryField, Schema schema) {
        if (DynamicSummaryTransformUtils.isOriginalSupportedType(summaryField.getDataType())) {
            String sourceFieldName;
            ImmutableSDField source;
            if (summaryField.hasExplicitSingleSource() && (source = schema.getField(sourceFieldName = summaryField.getSingleSource())) != null) {
                return sourceFieldName;
            }
            return summaryField.getName();
        }
        return summaryField.getSingleSource();
    }
}

