/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.derived;

import com.yahoo.config.ConfigInstance;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.document.config.DocumentmanagerConfig;
import com.yahoo.document.config.DocumenttypesConfig;
import com.yahoo.io.IOUtils;
import com.yahoo.protect.Validator;
import com.yahoo.schema.RankProfileRegistry;
import com.yahoo.schema.Schema;
import com.yahoo.schema.derived.AttributeFields;
import com.yahoo.schema.derived.ImportedFields;
import com.yahoo.schema.derived.IndexInfo;
import com.yahoo.schema.derived.IndexSchema;
import com.yahoo.schema.derived.IndexingScript;
import com.yahoo.schema.derived.Juniperrc;
import com.yahoo.schema.derived.RankProfileList;
import com.yahoo.schema.derived.SchemaInfo;
import com.yahoo.schema.derived.Summaries;
import com.yahoo.schema.derived.VsmFields;
import com.yahoo.schema.derived.VsmSummary;
import com.yahoo.schema.derived.validation.Validation;
import com.yahoo.search.query.profile.QueryProfileRegistry;
import com.yahoo.vespa.config.search.AttributesConfig;
import com.yahoo.vespa.config.search.core.RankingConstantsConfig;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;

public class DerivedConfiguration
implements AttributesConfig.Producer {
    private final Schema schema;
    private Summaries summaries;
    private Juniperrc juniperrc;
    private AttributeFields attributeFields;
    private RankProfileList rankProfileList;
    private IndexingScript indexingScript;
    private IndexInfo indexInfo;
    private SchemaInfo schemaInfo;
    private VsmFields streamingFields;
    private VsmSummary streamingSummary;
    private IndexSchema indexSchema;
    private ImportedFields importedFields;
    private final QueryProfileRegistry queryProfiles;
    private final long maxUncommittedMemory;

    public DerivedConfiguration(Schema schema, RankProfileRegistry rankProfileRegistry) {
        this(schema, rankProfileRegistry, new QueryProfileRegistry());
    }

    DerivedConfiguration(Schema schema, RankProfileRegistry rankProfileRegistry, QueryProfileRegistry queryProfiles) {
        this(schema, new DeployState.Builder().rankProfileRegistry(rankProfileRegistry).queryProfiles(queryProfiles).build(), false);
    }

    public DerivedConfiguration(Schema schema, DeployState deployState, boolean isStreaming) {
        try {
            Validator.ensureNotNull((String)"Schema", (Object)schema);
            this.schema = schema;
            this.queryProfiles = deployState.getQueryProfiles().getRegistry();
            this.maxUncommittedMemory = deployState.getProperties().featureFlags().maxUnCommittedMemory();
            if (!schema.isDocumentsOnly()) {
                this.streamingFields = new VsmFields(schema);
                this.streamingSummary = new VsmSummary(schema);
            }
            if (!schema.isDocumentsOnly()) {
                this.attributeFields = new AttributeFields(schema);
                this.summaries = new Summaries(schema, deployState.getDeployLogger(), deployState.getProperties().featureFlags());
                this.juniperrc = new Juniperrc(schema);
                this.rankProfileList = new RankProfileList(schema, schema.rankExpressionFiles(), this.attributeFields, deployState);
                this.indexingScript = new IndexingScript(schema, isStreaming);
                this.indexInfo = new IndexInfo(schema, isStreaming);
                this.schemaInfo = new SchemaInfo(schema, deployState.rankProfileRegistry(), this.summaries);
                this.indexSchema = new IndexSchema(schema);
                this.importedFields = new ImportedFields(schema);
            }
            Validation.validate(this, schema);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            throw new IllegalArgumentException("Invalid " + schema, e);
        }
    }

    public void export(String toDirectory) throws IOException {
        if (!this.schema.isDocumentsOnly()) {
            this.summaries.export(toDirectory);
            this.juniperrc.export(toDirectory);
            this.attributeFields.export(toDirectory);
            this.streamingFields.export(toDirectory);
            this.streamingSummary.export(toDirectory);
            this.indexSchema.export(toDirectory);
            this.rankProfileList.export(toDirectory);
            this.indexingScript.export(toDirectory);
            this.indexInfo.export(toDirectory);
            this.importedFields.export(toDirectory);
            this.schemaInfo.export(toDirectory);
        }
    }

    public static void exportDocuments(DocumentmanagerConfig.Builder documentManagerCfg, String toDirectory) throws IOException {
        DerivedConfiguration.exportCfg((ConfigInstance)new DocumentmanagerConfig(documentManagerCfg), toDirectory + "/documentmanager.cfg");
    }

    public static void exportDocuments(DocumenttypesConfig.Builder documentTypesCfg, String toDirectory) throws IOException {
        DerivedConfiguration.exportCfg((ConfigInstance)new DocumenttypesConfig(documentTypesCfg), toDirectory + "/documenttypes.cfg");
    }

    public static void exportQueryProfiles(QueryProfileRegistry queryProfileRegistry, String toDirectory) throws IOException {
        DerivedConfiguration.exportCfg((ConfigInstance)new QueryProfiles(queryProfileRegistry, (level, message) -> {}).getConfig(), toDirectory + "/query-profiles.cfg");
    }

    public void exportConstants(String toDirectory) throws IOException {
        RankingConstantsConfig.Builder b = new RankingConstantsConfig.Builder();
        this.rankProfileList.getConfig(b);
        DerivedConfiguration.exportCfg((ConfigInstance)b.build(), toDirectory + "/ranking-constants.cfg");
    }

    private static void exportCfg(ConfigInstance instance, String fileName) throws IOException {
        BufferedWriter writer = null;
        try {
            writer = IOUtils.createWriter((String)fileName, (boolean)false);
            writer.write(instance.toString());
            writer.write("\n");
        }
        finally {
            if (writer != null) {
                IOUtils.closeWriter((Writer)writer);
            }
        }
    }

    public Summaries getSummaries() {
        return this.summaries;
    }

    public AttributeFields getAttributeFields() {
        return this.attributeFields;
    }

    public void getConfig(AttributesConfig.Builder builder) {
        this.getConfig(builder, AttributeFields.FieldSet.ALL);
    }

    public void getConfig(AttributesConfig.Builder builder, AttributeFields.FieldSet fs) {
        this.attributeFields.getConfig(builder, fs, this.maxUncommittedMemory);
    }

    public IndexingScript getIndexingScript() {
        return this.indexingScript;
    }

    public IndexInfo getIndexInfo() {
        return this.indexInfo;
    }

    public SchemaInfo getSchemaInfo() {
        return this.schemaInfo;
    }

    public void setIndexingScript(IndexingScript script) {
        this.indexingScript = script;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public RankProfileList getRankProfileList() {
        return this.rankProfileList;
    }

    public VsmSummary getVsmSummary() {
        return this.streamingSummary;
    }

    public VsmFields getVsmFields() {
        return this.streamingFields;
    }

    public IndexSchema getIndexSchema() {
        return this.indexSchema;
    }

    public Juniperrc getJuniperrc() {
        return this.juniperrc;
    }

    public ImportedFields getImportedFields() {
        return this.importedFields;
    }

    public QueryProfileRegistry getQueryProfiles() {
        return this.queryProfiles;
    }
}

