/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.builder.xml.dom.chains;

import com.yahoo.component.chain.model.ChainSpecification;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AnyConfigProducer;
import com.yahoo.config.model.producer.TreeConfigProducer;
import com.yahoo.vespa.model.builder.xml.dom.VespaDomBuilder;
import com.yahoo.vespa.model.builder.xml.dom.chains.ChainSpecificationBuilder;
import com.yahoo.vespa.model.builder.xml.dom.chains.ComponentsBuilder;
import com.yahoo.vespa.model.container.component.chain.Chain;
import com.yahoo.vespa.model.container.component.chain.ChainedComponent;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

public abstract class DomChainBuilderBase<COMPONENT extends ChainedComponent<?>, CHAIN extends Chain<COMPONENT>>
extends VespaDomBuilder.DomConfigProducerBuilderBase<CHAIN> {
    private final Collection<ComponentsBuilder.ComponentType<COMPONENT>> allowedComponentTypes;
    protected final Map<String, ComponentsBuilder.ComponentType<?>> outerComponentTypeByComponentName;

    public DomChainBuilderBase(Collection<ComponentsBuilder.ComponentType<COMPONENT>> allowedComponentTypes, Map<String, ComponentsBuilder.ComponentType<?>> outerComponentTypeByComponentName) {
        this.allowedComponentTypes = allowedComponentTypes;
        this.outerComponentTypeByComponentName = outerComponentTypeByComponentName;
    }

    @Override
    public final CHAIN doBuild(DeployState deployState, TreeConfigProducer<AnyConfigProducer> ancestor, Element producerSpec) {
        ComponentsBuilder componentsBuilder = new ComponentsBuilder(deployState, ancestor, this.allowedComponentTypes, List.of(producerSpec), this.outerComponentTypeByComponentName);
        ChainSpecification specWithoutInnerComponents = new ChainSpecificationBuilder(producerSpec).build(componentsBuilder.getOuterComponentReferences());
        CHAIN chain = this.buildChain(deployState, ancestor, producerSpec, specWithoutInnerComponents);
        this.addInnerComponents(chain, componentsBuilder.getComponentDefinitions());
        return chain;
    }

    private void addInnerComponents(CHAIN chain, Collection<COMPONENT> componentDefinitions) {
        for (ChainedComponent innerComponent : componentDefinitions) {
            ((Chain)chain).addInnerComponent((ChainedComponent)innerComponent);
        }
    }

    protected abstract CHAIN buildChain(DeployState var1, TreeConfigProducer<AnyConfigProducer> var2, Element var3, ChainSpecification var4);
}

