/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.document.DataType;
import com.yahoo.document.Field;
import com.yahoo.schema.RankProfileRegistry;
import com.yahoo.schema.Schema;
import com.yahoo.schema.document.SDField;
import com.yahoo.schema.processing.DynamicSummaryTransformUtils;
import com.yahoo.schema.processing.Processor;
import com.yahoo.vespa.documentmodel.SummaryField;
import com.yahoo.vespa.documentmodel.SummaryTransform;
import com.yahoo.vespa.indexinglanguage.ExpressionConverter;
import com.yahoo.vespa.indexinglanguage.expressions.AttributeExpression;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.IndexExpression;
import com.yahoo.vespa.indexinglanguage.expressions.OutputExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ScriptExpression;
import com.yahoo.vespa.indexinglanguage.expressions.StatementExpression;
import com.yahoo.vespa.indexinglanguage.expressions.SummaryExpression;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class IndexingOutputs
extends Processor {
    public IndexingOutputs(Schema schema, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(schema, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        for (SDField field : this.schema.allConcreteFields()) {
            ScriptExpression script = field.getIndexingScript();
            if (script == null) continue;
            TreeSet<String> summaryFields = new TreeSet<String>();
            this.findSummaryTo(this.schema, field, summaryFields, summaryFields);
            MyConverter converter = new MyConverter(this.schema, field, summaryFields, validate);
            field.setIndexingScript((ScriptExpression)converter.convert((Expression)script));
        }
    }

    public void findSummaryTo(Schema schema, SDField field, Set<String> dynamicSummary, Set<String> staticSummary) {
        List<SummaryField> summaryFields = schema.getSummaryFields(field);
        if (summaryFields.isEmpty()) {
            IndexingOutputs.fillSummaryToFromField(field, dynamicSummary, staticSummary);
        } else {
            this.fillSummaryToFromSearch(schema, field, summaryFields, dynamicSummary, staticSummary);
        }
    }

    private void fillSummaryToFromSearch(Schema schema, SDField field, List<SummaryField> summaryFields, Set<String> dynamicSummary, Set<String> staticSummary) {
        for (SummaryField summaryField : summaryFields) {
            this.fillSummaryToFromSummaryField(schema, field, summaryField, dynamicSummary, staticSummary);
        }
    }

    private void fillSummaryToFromSummaryField(Schema schema, SDField field, SummaryField summaryField, Set<String> dynamicSummary, Set<String> staticSummary) {
        SummaryTransform summaryTransform = summaryField.getTransform();
        String summaryName = summaryField.getName();
        if (summaryTransform.isDynamic() && summaryField.getSourceCount() > 2) {
            return;
        }
        if (summaryTransform.isDynamic()) {
            DataType fieldType = field.getDataType();
            if (!DynamicSummaryTransformUtils.summaryFieldIsPopulatedBySourceField(fieldType)) {
                if (!DynamicSummaryTransformUtils.isSupportedType(fieldType)) {
                    this.warn(schema, field, "Dynamic summaries are only supported for fields of type string and array<string>, ignoring summary field '" + summaryField.getName() + "' for sd field '" + field.getName() + "' of type " + fieldType.getName() + ".");
                }
                return;
            }
            dynamicSummary.add(summaryName);
        } else if (summaryTransform != SummaryTransform.ATTRIBUTE && summaryTransform != SummaryTransform.TOKENS && summaryTransform != SummaryTransform.ATTRIBUTE_TOKENS) {
            staticSummary.add(summaryName);
        }
    }

    private static void fillSummaryToFromField(SDField field, Set<String> dynamicSummary, Set<String> staticSummary) {
        for (SummaryField summaryField : field.getSummaryFields().values()) {
            String summaryName = summaryField.getName();
            if (summaryField.getTransform().isDynamic()) {
                dynamicSummary.add(summaryName);
                continue;
            }
            staticSummary.add(summaryName);
        }
    }

    private class MyConverter
    extends ExpressionConverter {
        final Schema schema;
        final Field field;
        final Set<String> summaryFields;
        final boolean validate;

        MyConverter(Schema schema, Field field, Set<String> summaryFields, boolean validate) {
            this.schema = schema;
            this.field = field;
            this.summaryFields = summaryFields.isEmpty() ? Collections.singleton(field.getName()) : summaryFields;
            this.validate = validate;
        }

        protected boolean shouldConvert(Expression exp) {
            if (!(exp instanceof OutputExpression)) {
                return false;
            }
            String fieldName = ((OutputExpression)exp).getFieldName();
            if (fieldName == null) {
                return true;
            }
            if (this.validate && !fieldName.equals(this.field.getName())) {
                IndexingOutputs.this.fail(this.schema, this.field, "Indexing expression '" + exp + "' attempts to write to a field other than '" + this.field.getName() + "'.");
            }
            return false;
        }

        protected Expression doConvert(Expression exp) {
            LinkedList<Object> ret = new LinkedList<Object>();
            if (exp instanceof AttributeExpression) {
                ret.add(new AttributeExpression(this.field.getName()));
            } else if (exp instanceof IndexExpression) {
                ret.add(new IndexExpression(this.field.getName()));
            } else if (exp instanceof SummaryExpression) {
                for (String fieldName : this.summaryFields) {
                    ret.add(new SummaryExpression(fieldName));
                }
                if (!this.summaryFields.contains(this.field.getName())) {
                    ret.add(new SummaryExpression(this.field.getName()));
                }
            } else {
                throw new UnsupportedOperationException(exp.getClass().getName());
            }
            return new StatementExpression(ret);
        }
    }
}

