/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.derived;

import com.yahoo.schema.Schema;
import com.yahoo.schema.derived.Derived;
import com.yahoo.schema.document.GeoPos;
import com.yahoo.schema.document.ImmutableSDField;
import com.yahoo.vespa.configdefinition.IlscriptsConfig;
import com.yahoo.vespa.indexinglanguage.ExpressionConverter;
import com.yahoo.vespa.indexinglanguage.ExpressionVisitor;
import com.yahoo.vespa.indexinglanguage.expressions.ClearStateExpression;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.GuardExpression;
import com.yahoo.vespa.indexinglanguage.expressions.InputExpression;
import com.yahoo.vespa.indexinglanguage.expressions.OutputExpression;
import com.yahoo.vespa.indexinglanguage.expressions.PassthroughExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ScriptExpression;
import com.yahoo.vespa.indexinglanguage.expressions.SetLanguageExpression;
import com.yahoo.vespa.indexinglanguage.expressions.StatementExpression;
import com.yahoo.vespa.indexinglanguage.expressions.TokenizeExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ZCurveExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class IndexingScript
extends Derived
implements IlscriptsConfig.Producer {
    private final List<String> docFields = new ArrayList<String>();
    private final List<Expression> expressions = new ArrayList<Expression>();
    private List<ImmutableSDField> fieldsSettingLanguage;
    private final boolean isStreaming;

    public IndexingScript(Schema schema, boolean isStreaming) {
        this.isStreaming = isStreaming;
        this.derive(schema);
    }

    @Override
    protected void derive(Schema schema) {
        this.fieldsSettingLanguage = this.fieldsSettingLanguage(schema);
        if (this.fieldsSettingLanguage.size() == 1) {
            this.addExpression(this.fieldsSettingLanguage.get(0).getIndexingScript());
        }
        super.derive(schema);
    }

    @Override
    protected void derive(ImmutableSDField field, Schema schema) {
        if (field.isImportedField()) {
            return;
        }
        if (field.hasFullIndexingDocprocRights()) {
            this.docFields.add(field.getName());
        }
        if (field.usesStructOrMap() && !GeoPos.isAnyPos(field)) {
            return;
        }
        if (this.fieldsSettingLanguage.size() == 1 && this.fieldsSettingLanguage.get(0).equals(field)) {
            return;
        }
        this.addExpression(field.getIndexingScript());
    }

    private void addExpression(ScriptExpression expression) {
        if (expression.isEmpty()) {
            return;
        }
        this.expressions.add((Expression)new StatementExpression(new Expression[]{new ClearStateExpression(), new GuardExpression((Expression)expression)}));
    }

    private List<ImmutableSDField> fieldsSettingLanguage(Schema schema) {
        return schema.allFieldsList().stream().filter(field -> !field.isImportedField()).filter(field -> field.containsExpression(SetLanguageExpression.class)).toList();
    }

    public Iterable<Expression> expressions() {
        return Collections.unmodifiableCollection(this.expressions);
    }

    @Override
    public String getDerivedName() {
        return "ilscripts";
    }

    public void getConfig(IlscriptsConfig.Builder configBuilder) {
        IlscriptsConfig.Ilscript.Builder ilscriptBuilder = new IlscriptsConfig.Ilscript.Builder();
        ilscriptBuilder.doctype(this.getName());
        ilscriptBuilder.docfield(this.docFields);
        this.addContentInOrder(ilscriptBuilder);
        configBuilder.ilscript(ilscriptBuilder);
    }

    private void addContentInOrder(IlscriptsConfig.Ilscript.Builder ilscriptBuilder) {
        ArrayList<Expression> later = new ArrayList<Expression>();
        HashSet<String> touchedFields = new HashSet<String>();
        for (Expression expression : this.expressions) {
            if (this.isStreaming) {
                expression = expression.convertChildren((ExpressionConverter)new DropTokenize());
            }
            if (this.modifiesSelf(expression) && !this.setsLanguage(expression)) {
                later.add(expression);
            } else {
                ilscriptBuilder.content(expression.toString());
            }
            FieldScanVisitor fieldFetcher = new FieldScanVisitor();
            fieldFetcher.visit(expression);
            touchedFields.addAll(fieldFetcher.touchedFields());
        }
        for (Expression exp : later) {
            ilscriptBuilder.content(exp.toString());
        }
        this.generateSyntheticStatementsForUntouchedFields(ilscriptBuilder, touchedFields);
    }

    private void generateSyntheticStatementsForUntouchedFields(IlscriptsConfig.Ilscript.Builder ilscriptBuilder, Set<String> touchedFields) {
        HashSet<String> fieldsWithSyntheticStatements = new HashSet<String>(this.docFields);
        fieldsWithSyntheticStatements.removeAll(touchedFields);
        ArrayList<String> orderedFields = new ArrayList<String>(fieldsWithSyntheticStatements);
        Collections.sort(orderedFields);
        for (String fieldName : orderedFields) {
            StatementExpression copyField = new StatementExpression(new Expression[]{new InputExpression(fieldName), new PassthroughExpression(fieldName)});
            ilscriptBuilder.content(copyField.toString());
        }
    }

    private boolean setsLanguage(Expression expression) {
        SetsLanguageVisitor visitor = new SetsLanguageVisitor();
        visitor.visit(expression);
        return visitor.setsLanguage;
    }

    private boolean modifiesSelf(Expression expression) {
        ModifiesSelfVisitor visitor = new ModifiesSelfVisitor();
        visitor.visit(expression);
        return visitor.modifiesSelf();
    }

    private static class DropTokenize
    extends ExpressionConverter {
        private DropTokenize() {
        }

        protected boolean shouldConvert(Expression exp) {
            return exp instanceof TokenizeExpression;
        }

        protected Expression doConvert(Expression exp) {
            return null;
        }
    }

    private static class FieldScanVisitor
    extends ExpressionVisitor {
        List<String> touchedFields = new ArrayList<String>();
        List<String> candidates = new ArrayList<String>();

        private FieldScanVisitor() {
        }

        protected void doVisit(Expression exp) {
            if (exp instanceof OutputExpression) {
                this.touchedFields.add(((OutputExpression)exp).getFieldName());
            }
            if (exp instanceof InputExpression) {
                this.candidates.add(((InputExpression)exp).getFieldName());
            }
            if (exp instanceof ZCurveExpression) {
                this.touchedFields.addAll(this.candidates);
            }
        }

        Collection<String> touchedFields() {
            List<String> output = this.touchedFields;
            this.touchedFields = null;
            return output;
        }
    }

    private static class SetsLanguageVisitor
    extends ExpressionVisitor {
        boolean setsLanguage = false;

        private SetsLanguageVisitor() {
        }

        protected void doVisit(Expression expression) {
            if (expression instanceof SetLanguageExpression) {
                this.setsLanguage = true;
            }
        }
    }

    private static class ModifiesSelfVisitor
    extends ExpressionVisitor {
        private String inputField = null;
        private String outputField = null;

        private ModifiesSelfVisitor() {
        }

        public boolean modifiesSelf() {
            return this.outputField != null && this.outputField.equals(this.inputField);
        }

        protected void doVisit(Expression expression) {
            if (this.modifiesSelf()) {
                return;
            }
            if (expression instanceof InputExpression) {
                this.inputField = ((InputExpression)expression).getFieldName();
            }
            if (expression instanceof OutputExpression) {
                this.outputField = ((OutputExpression)expression).getFieldName();
            }
        }
    }
}

