/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation;

import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.text.Text;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.application.validation.Validator;
import com.yahoo.vespa.model.container.ContainerCluster;
import java.util.logging.Level;

public class JvmHeapSizeValidator
extends Validator {
    public static final int percentLimit = 15;
    public static final double gbLimit = 0.6;

    @Override
    public void validate(VespaModel model, DeployState ds) {
        if (!ds.featureFlags().dynamicHeapSize()) {
            return;
        }
        if (!ds.isHostedTenantApplication(model.getAdmin().getApplicationType())) {
            return;
        }
        model.getContainerClusters().forEach((clusterId, appCluster) -> {
            ContainerCluster.JvmMemoryPercentage mp = appCluster.getMemoryPercentage().orElse(null);
            if (mp == null) {
                return;
            }
            if (mp.availableMemoryGb().isEmpty()) {
                ds.getDeployLogger().log(Level.FINE, "Host resources unknown or percentage overridden with 'allocated-memory'");
                return;
            }
            long jvmModelCost = appCluster.onnxModelCostCalculator().aggregatedModelCostInBytes();
            if (jvmModelCost > 0L) {
                double availableMemoryGb = mp.availableMemoryGb().getAsDouble();
                double modelCostGb = (double)jvmModelCost / 1.073741824E9;
                ds.getDeployLogger().log(Level.FINE, () -> Text.format((String)"JVM: %d%% (limit: %d%%), %.2fGB (limit: %.2fGB), ONNX: %.2fGB", (Object[])new Object[]{mp.percentage(), 15, availableMemoryGb, 0.6, modelCostGb}));
                if (mp.percentage() < 15) {
                    throw new IllegalArgumentException(Text.format((String)"Allocated percentage of memory of JVM in cluster '%s' is too low (%d%% < %d%%). Estimated cost of ONNX models is %.2fGB. Either use a node flavor with more memory or use less expensive models. You may override this validation by specifying 'allocated-memory' (https://docs.vespa.ai/en/performance/container-tuning.html#jvm-heap-size).", (Object[])new Object[]{clusterId, mp.percentage(), 15, modelCostGb}));
                }
                if (availableMemoryGb < 0.6) {
                    throw new IllegalArgumentException(Text.format((String)"Allocated memory to JVM in cluster '%s' is too low (%.2fGB < %.2fGB). Estimated cost of ONNX models is %.2fGB. Either use a node flavor with more memory or use less expensive models. You may override this validation by specifying 'allocated-memory' (https://docs.vespa.ai/en/performance/container-tuning.html#jvm-heap-size).", (Object[])new Object[]{clusterId, availableMemoryGb, 0.6, modelCostGb}));
                }
            }
        });
    }
}

