/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation;

import com.yahoo.config.application.api.ApplicationFile;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.path.Path;
import com.yahoo.schema.DistributableResource;
import com.yahoo.schema.RankProfile;
import com.yahoo.schema.Schema;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.application.validation.ConstantTensorJsonValidator;
import com.yahoo.vespa.model.application.validation.Validator;
import java.io.FileNotFoundException;

public class ConstantValidator
extends Validator {
    @Override
    public void validate(VespaModel model, DeployState deployState) {
        ExceptionMessageCollector exceptionMessageCollector = new ExceptionMessageCollector("Invalid constant tensor file(s):");
        for (Schema schema : deployState.getSchemas()) {
            for (RankProfile.Constant constant : schema.declaredConstants().values()) {
                this.validate(constant, deployState.getApplicationPackage(), exceptionMessageCollector);
            }
            for (RankProfile profile : deployState.rankProfileRegistry().rankProfilesOf(schema)) {
                for (RankProfile.Constant constant : profile.declaredConstants().values()) {
                    this.validate(constant, deployState.getApplicationPackage(), exceptionMessageCollector);
                }
            }
        }
        if (exceptionMessageCollector.exceptionsOccurred) {
            throw new IllegalArgumentException(exceptionMessageCollector.combinedMessage);
        }
    }

    private void validate(RankProfile.Constant constant, ApplicationPackage applicationPackage, ExceptionMessageCollector exceptionMessageCollector) {
        try {
            this.validate(constant, applicationPackage);
        }
        catch (ConstantTensorJsonValidator.InvalidConstantTensorException | FileNotFoundException exception) {
            exceptionMessageCollector.add(constant, exception);
        }
    }

    private void validate(RankProfile.Constant rankingConstant, ApplicationPackage application) throws FileNotFoundException {
        if (rankingConstant.valuePath().isEmpty()) {
            return;
        }
        if (rankingConstant.pathType().get() != DistributableResource.PathType.FILE) {
            return;
        }
        String constantFile = rankingConstant.valuePath().get();
        if (application.getFileReference(Path.fromString((String)"")).getAbsolutePath().endsWith(".preprocessed") && constantFile.startsWith(".preprocessed")) {
            constantFile = constantFile.substring(".preprocessed".length());
        }
        ApplicationFile tensorApplicationFile = application.getFile(Path.fromString((String)constantFile));
        new ConstantTensorJsonValidator(rankingConstant.type()).validate(constantFile, tensorApplicationFile.createReader());
    }

    private static class ExceptionMessageCollector {
        String combinedMessage;
        boolean exceptionsOccurred = false;

        ExceptionMessageCollector(String messagePrelude) {
            this.combinedMessage = messagePrelude;
        }

        public void add(RankProfile.Constant constant, Exception exception) {
            this.exceptionsOccurred = true;
            this.combinedMessage = this.combinedMessage + "\n" + constant.name() + " " + constant.type() + ": file:" + constant.valuePath().get() + ": " + exception.getMessage();
        }
    }
}

