/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.builder.xml.dom;

import com.yahoo.component.ComponentId;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AnyConfigProducer;
import com.yahoo.config.model.producer.TreeConfigProducer;
import com.yahoo.container.bundle.BundleInstantiationSpecification;
import com.yahoo.osgi.provider.model.ComponentModel;
import com.yahoo.text.XML;
import com.yahoo.vespa.model.builder.xml.dom.VespaDomBuilder;
import com.yahoo.vespa.model.container.ApplicationContainerCluster;
import com.yahoo.vespa.model.container.component.BertEmbedder;
import com.yahoo.vespa.model.container.component.ColBertEmbedder;
import com.yahoo.vespa.model.container.component.Component;
import com.yahoo.vespa.model.container.component.HuggingFaceEmbedder;
import com.yahoo.vespa.model.container.component.HuggingFaceTokenizer;
import com.yahoo.vespa.model.container.xml.BundleInstantiationSpecificationBuilder;
import org.w3c.dom.Element;

public class DomComponentBuilder
extends VespaDomBuilder.DomConfigProducerBuilder<Component<?, ?>, AnyConfigProducer> {
    public static final String elementName = "component";
    private final ComponentId namespace;

    public DomComponentBuilder() {
        this(null);
    }

    public DomComponentBuilder(ComponentId namespace) {
        this.namespace = namespace;
    }

    @Override
    protected Component<? super Component<?, ?>, ?> doBuild(DeployState deployState, TreeConfigProducer<AnyConfigProducer> ancestor, Element spec) {
        Component<? super Component<?, ?>, ?> component = this.buildComponent(spec, deployState, ancestor);
        DomComponentBuilder.addChildren(deployState, ancestor, spec, component);
        return component;
    }

    private Component<? super Component<?, ?>, ?> buildComponent(Element spec, DeployState state, TreeConfigProducer<AnyConfigProducer> ancestor) {
        if (spec.hasAttribute("type")) {
            String type;
            return switch (type = spec.getAttribute("type")) {
                case "hugging-face-embedder" -> new HuggingFaceEmbedder((ApplicationContainerCluster)ancestor, spec, state);
                case "hugging-face-tokenizer" -> new HuggingFaceTokenizer(spec, state);
                case "colbert-embedder" -> new ColBertEmbedder((ApplicationContainerCluster)ancestor, spec, state);
                case "bert-embedder" -> new BertEmbedder((ApplicationContainerCluster)ancestor, spec, state);
                default -> throw new IllegalArgumentException("Unknown component type '%s'".formatted(type));
            };
        }
        BundleInstantiationSpecification bundleSpec = BundleInstantiationSpecificationBuilder.build(spec).nestInNamespace(this.namespace);
        return new Component(new ComponentModel(bundleSpec));
    }

    public static void addChildren(DeployState deployState, TreeConfigProducer<AnyConfigProducer> ancestor, Element componentNode, Component<? super Component<?, ?>, ?> component) {
        for (Element childNode : XML.getChildren((Element)componentNode, (String)elementName)) {
            DomComponentBuilder.addAndInjectChild(deployState, ancestor, component, childNode);
        }
    }

    private static void addAndInjectChild(DeployState deployState, TreeConfigProducer<AnyConfigProducer> ancestor, Component<? super Component<?, ?>, ?> component, Element childNode) {
        Component child = (Component)new DomComponentBuilder(component.getComponentId()).build(deployState, ancestor, childNode);
        component.addComponent(child);
        component.inject(child);
    }
}

