/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.xml;

import com.yahoo.component.ComponentId;
import com.yahoo.component.ComponentSpecification;
import com.yahoo.component.Version;
import com.yahoo.component.chain.dependencies.Dependencies;
import com.yahoo.component.chain.model.ChainedComponentModel;
import com.yahoo.config.application.Xml;
import com.yahoo.config.application.api.ApplicationFile;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.application.api.DeploymentSpec;
import com.yahoo.config.model.ConfigModelContext;
import com.yahoo.config.model.api.ApplicationClusterEndpoint;
import com.yahoo.config.model.api.ConfigServerSpec;
import com.yahoo.config.model.api.ContainerEndpoint;
import com.yahoo.config.model.api.EndpointCertificateSecrets;
import com.yahoo.config.model.api.TenantSecretStore;
import com.yahoo.config.model.builder.xml.ConfigModelBuilder;
import com.yahoo.config.model.builder.xml.ConfigModelId;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AnyConfigProducer;
import com.yahoo.config.model.producer.TreeConfigProducer;
import com.yahoo.config.provision.AthenzDomain;
import com.yahoo.config.provision.AthenzService;
import com.yahoo.config.provision.Capacity;
import com.yahoo.config.provision.ClusterMembership;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.config.provision.DataplaneToken;
import com.yahoo.config.provision.Environment;
import com.yahoo.config.provision.HostName;
import com.yahoo.config.provision.InstanceName;
import com.yahoo.config.provision.NodeType;
import com.yahoo.config.provision.RegionName;
import com.yahoo.config.provision.Zone;
import com.yahoo.config.provision.ZoneEndpoint;
import com.yahoo.config.provision.zone.ZoneId;
import com.yahoo.container.bundle.BundleInstantiationSpecification;
import com.yahoo.container.jdisc.DataplaneProxyService;
import com.yahoo.container.logging.AccessLog;
import com.yahoo.container.logging.FileConnectionLog;
import com.yahoo.io.IOUtils;
import com.yahoo.jdisc.http.server.jetty.DataplaneProxyCredentials;
import com.yahoo.jdisc.http.server.jetty.VoidRequestLog;
import com.yahoo.osgi.provider.model.ComponentModel;
import com.yahoo.path.Path;
import com.yahoo.schema.OnnxModel;
import com.yahoo.schema.derived.FileDistributedOnnxModels;
import com.yahoo.schema.derived.RankProfileList;
import com.yahoo.search.rendering.RendererRegistry;
import com.yahoo.security.X509CertificateUtils;
import com.yahoo.text.Identifier;
import com.yahoo.text.XML;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.model.AbstractService;
import com.yahoo.vespa.model.HostResource;
import com.yahoo.vespa.model.HostSystem;
import com.yahoo.vespa.model.builder.xml.dom.DomComponentBuilder;
import com.yahoo.vespa.model.builder.xml.dom.DomHandlerBuilder;
import com.yahoo.vespa.model.builder.xml.dom.ModelElement;
import com.yahoo.vespa.model.builder.xml.dom.NodesSpecification;
import com.yahoo.vespa.model.builder.xml.dom.VespaDomBuilder;
import com.yahoo.vespa.model.builder.xml.dom.chains.docproc.DomDocprocChainsBuilder;
import com.yahoo.vespa.model.builder.xml.dom.chains.processing.DomProcessingBuilder;
import com.yahoo.vespa.model.builder.xml.dom.chains.search.DomSearchChainsBuilder;
import com.yahoo.vespa.model.clients.ContainerDocumentApi;
import com.yahoo.vespa.model.container.ApplicationContainer;
import com.yahoo.vespa.model.container.ApplicationContainerCluster;
import com.yahoo.vespa.model.container.Container;
import com.yahoo.vespa.model.container.ContainerCluster;
import com.yahoo.vespa.model.container.ContainerModel;
import com.yahoo.vespa.model.container.ContainerModelEvaluation;
import com.yahoo.vespa.model.container.ContainerThreadpool;
import com.yahoo.vespa.model.container.DataplaneProxy;
import com.yahoo.vespa.model.container.IdentityProvider;
import com.yahoo.vespa.model.container.PlatformBundles;
import com.yahoo.vespa.model.container.SecretStore;
import com.yahoo.vespa.model.container.component.AccessLogComponent;
import com.yahoo.vespa.model.container.component.BindingPattern;
import com.yahoo.vespa.model.container.component.Component;
import com.yahoo.vespa.model.container.component.ConnectionLogComponent;
import com.yahoo.vespa.model.container.component.FileStatusHandlerComponent;
import com.yahoo.vespa.model.container.component.Handler;
import com.yahoo.vespa.model.container.component.SimpleComponent;
import com.yahoo.vespa.model.container.component.SystemBindingPattern;
import com.yahoo.vespa.model.container.component.UserBindingPattern;
import com.yahoo.vespa.model.container.docproc.ContainerDocproc;
import com.yahoo.vespa.model.container.docproc.DocprocChains;
import com.yahoo.vespa.model.container.http.AccessControl;
import com.yahoo.vespa.model.container.http.Client;
import com.yahoo.vespa.model.container.http.ConnectorFactory;
import com.yahoo.vespa.model.container.http.Filter;
import com.yahoo.vespa.model.container.http.FilterBinding;
import com.yahoo.vespa.model.container.http.FilterChains;
import com.yahoo.vespa.model.container.http.Http;
import com.yahoo.vespa.model.container.http.HttpFilterChain;
import com.yahoo.vespa.model.container.http.JettyHttpServer;
import com.yahoo.vespa.model.container.http.ssl.HostedSslConnectorFactory;
import com.yahoo.vespa.model.container.http.xml.HttpBuilder;
import com.yahoo.vespa.model.container.processing.ProcessingChains;
import com.yahoo.vespa.model.container.search.ContainerSearch;
import com.yahoo.vespa.model.container.search.PageTemplates;
import com.yahoo.vespa.model.container.search.searchchain.SearchChains;
import com.yahoo.vespa.model.container.xml.AccessLogBuilder;
import com.yahoo.vespa.model.container.xml.CloudDataPlaneFilter;
import com.yahoo.vespa.model.container.xml.CloudSecretStore;
import com.yahoo.vespa.model.container.xml.CloudTokenDataPlaneFilter;
import com.yahoo.vespa.model.container.xml.ContainerServiceBuilder;
import com.yahoo.vespa.model.container.xml.DocprocOptionsBuilder;
import com.yahoo.vespa.model.container.xml.DocumentApiOptionsBuilder;
import com.yahoo.vespa.model.container.xml.ModelIdResolver;
import com.yahoo.vespa.model.container.xml.SearchHandler;
import com.yahoo.vespa.model.container.xml.document.DocumentFactoryBuilder;
import com.yahoo.vespa.model.content.StorageGroup;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ContainerModelBuilder
extends ConfigModelBuilder<ContainerModel> {
    static final String HOSTED_VESPA_STATUS_FILE = Defaults.getDefaults().underVespaHome("var/vespa/load-balancer/status.html");
    private static final String HOSTED_VESPA_STATUS_FILE_SETTING = "VESPA_LB_STATUS_FILE";
    private static final String CONTAINER_TAG = "container";
    private static final String ENVIRONMENT_VARIABLES_ELEMENT = "environment-variables";
    private static final int MIN_ZOOKEEPER_NODE_COUNT = 1;
    private static final int MAX_ZOOKEEPER_NODE_COUNT = 7;
    private ApplicationPackage app;
    private final boolean standaloneBuilder;
    private final Networking networking;
    private final boolean rpcServerEnabled;
    private final boolean httpServerEnabled;
    protected DeployLogger log;
    public static final List<ConfigModelId> configModelIds = List.of(ConfigModelId.fromName("container"));
    private static final String xmlRendererId = RendererRegistry.xmlRendererId.getName();
    private static final String jsonRendererId = RendererRegistry.jsonRendererId.getName();

    public ContainerModelBuilder(boolean standaloneBuilder, Networking networking) {
        super(ContainerModel.class);
        this.standaloneBuilder = standaloneBuilder;
        this.networking = networking;
        this.rpcServerEnabled = !standaloneBuilder;
        this.httpServerEnabled = networking == Networking.enable;
    }

    @Override
    public List<ConfigModelId> handlesElements() {
        return configModelIds;
    }

    @Override
    public void doBuild(ContainerModel model, Element spec, ConfigModelContext modelContext) {
        this.log = modelContext.getDeployLogger();
        this.app = modelContext.getApplicationPackage();
        this.checkVersion(spec);
        ApplicationContainerCluster cluster = this.createContainerCluster(spec, modelContext);
        this.addClusterContent(cluster, spec, modelContext);
        cluster.setMessageBusEnabled(this.rpcServerEnabled);
        cluster.setRpcServerEnabled(this.rpcServerEnabled);
        cluster.setHttpServerEnabled(this.httpServerEnabled);
        model.setCluster(cluster);
    }

    private ApplicationContainerCluster createContainerCluster(Element spec, final ConfigModelContext modelContext) {
        return (ApplicationContainerCluster)new VespaDomBuilder.DomConfigProducerBuilderBase<ApplicationContainerCluster>(){

            @Override
            protected ApplicationContainerCluster doBuild(DeployState deployState, TreeConfigProducer<AnyConfigProducer> ancestor, Element producerSpec) {
                return new ApplicationContainerCluster(ancestor, modelContext.getProducerId(), modelContext.getProducerId(), deployState);
            }
        }.build(modelContext.getDeployState(), modelContext.getParentProducer(), spec);
    }

    private void addClusterContent(ApplicationContainerCluster cluster, Element spec, ConfigModelContext context) {
        DeployState deployState = context.getDeployState();
        DocumentFactoryBuilder.buildDocumentFactories(cluster, spec);
        this.addConfiguredComponents(deployState, cluster, spec);
        this.addSecretStore(cluster, spec, deployState);
        this.addProcessing(deployState, spec, cluster, context);
        this.addSearch(deployState, spec, cluster, context);
        this.addDocproc(deployState, spec, cluster);
        this.addDocumentApi(deployState, spec, cluster, context);
        cluster.addDefaultHandlersExceptStatus();
        this.addStatusHandlers(cluster, context.getDeployState().isHosted());
        this.addUserHandlers(deployState, cluster, spec, context);
        this.addClients(deployState, spec, cluster);
        this.addHttp(deployState, spec, cluster, context);
        this.addAccessLogs(deployState, cluster, spec);
        this.addNodes(cluster, spec, context);
        this.addModelEvaluationRuntime(cluster);
        this.addModelEvaluation(spec, cluster, context);
        this.addServerProviders(deployState, spec, cluster);
        if (!this.standaloneBuilder) {
            cluster.addAllPlatformBundles();
        }
        this.addDeploymentSpecConfig(cluster, context, deployState.getDeployLogger());
        this.addZooKeeper(cluster, spec);
        this.addParameterStoreValidationHandler(cluster, deployState);
    }

    private void addParameterStoreValidationHandler(ApplicationContainerCluster cluster, DeployState deployState) {
        if (deployState.isHosted()) {
            cluster.addPlatformBundle(PlatformBundles.absoluteBundlePath("jdisc-cloud-aws"));
        }
        if (deployState.zone().system().isPublic()) {
            SystemBindingPattern bindingPattern = SystemBindingPattern.fromHttpPath("/validate-secret-store");
            Handler handler = new Handler(new ComponentModel("com.yahoo.jdisc.cloud.aws.AwsParameterStoreValidationHandler", null, "jdisc-cloud-aws", null));
            handler.addServerBindings(bindingPattern);
            cluster.addComponent(handler);
        }
    }

    private void addZooKeeper(ApplicationContainerCluster cluster, Element spec) {
        boolean isCombined;
        Element zooKeeper = ContainerModelBuilder.getZooKeeper(spec);
        if (zooKeeper == null) {
            return;
        }
        Element nodesElement = XML.getChild((Element)spec, (String)"nodes");
        boolean bl = isCombined = nodesElement != null && nodesElement.hasAttribute("of");
        if (isCombined) {
            throw new IllegalArgumentException("A combined cluster cannot run ZooKeeper");
        }
        long nonRetiredNodes = cluster.getContainers().stream().filter(c -> !c.isRetired()).count();
        if (nonRetiredNodes < 1L || nonRetiredNodes > 7L || nonRetiredNodes % 2L == 0L) {
            throw new IllegalArgumentException("Cluster with ZooKeeper needs an odd number of nodes, between 1 and 7, have " + nonRetiredNodes + " non-retired");
        }
        cluster.addSimpleComponent("com.yahoo.vespa.curator.Curator", null, "zkfacade");
        cluster.addSimpleComponent("com.yahoo.vespa.curator.CuratorWrapper", null, "zkfacade");
        String sessionTimeoutSeconds = zooKeeper.getAttribute("session-timeout-seconds");
        if (!sessionTimeoutSeconds.isBlank()) {
            try {
                int timeoutSeconds = Integer.parseInt(sessionTimeoutSeconds);
                if (timeoutSeconds <= 0) {
                    throw new IllegalArgumentException("must be a positive value");
                }
                cluster.setZookeeperSessionTimeoutSeconds(timeoutSeconds);
            }
            catch (RuntimeException e) {
                throw new IllegalArgumentException("invalid zookeeper session-timeout-seconds '" + sessionTimeoutSeconds + "'", e);
            }
        }
        cluster.getContainers().forEach(ContainerModelBuilder::addReconfigurableZooKeeperServerComponents);
    }

    public static void addReconfigurableZooKeeperServerComponents(Container container) {
        container.addComponent(ContainerModelBuilder.zookeeperComponent("com.yahoo.vespa.zookeeper.ReconfigurableVespaZooKeeperServer", container));
        container.addComponent(ContainerModelBuilder.zookeeperComponent("com.yahoo.vespa.zookeeper.Reconfigurer", container));
        container.addComponent(ContainerModelBuilder.zookeeperComponent("com.yahoo.vespa.zookeeper.VespaZooKeeperAdminImpl", container));
    }

    private static SimpleComponent zookeeperComponent(String idSpec, Container container) {
        String configId = container.getConfigId();
        return new SimpleComponent(new ComponentModel(idSpec, null, "zookeeper-server", configId));
    }

    private void addSecretStore(ApplicationContainerCluster cluster, Element spec, DeployState deployState) {
        Element secretStoreElement = XML.getChild((Element)spec, (String)"secret-store");
        if (secretStoreElement != null) {
            String type = secretStoreElement.getAttribute("type");
            if ("cloud".equals(type)) {
                this.addCloudSecretStore(cluster, secretStoreElement, deployState);
            } else {
                SecretStore secretStore = new SecretStore();
                for (Element group : XML.getChildren((Element)secretStoreElement, (String)"group")) {
                    secretStore.addGroup(group.getAttribute("name"), group.getAttribute("environment"));
                }
                cluster.setSecretStore(secretStore);
            }
        }
    }

    private void addCloudSecretStore(ApplicationContainerCluster cluster, Element secretStoreElement, DeployState deployState) {
        if (!deployState.isHosted()) {
            return;
        }
        if (!cluster.getZone().system().isPublic()) {
            throw new IllegalArgumentException("Cloud secret store is not supported in non-public system, see the documentation");
        }
        CloudSecretStore cloudSecretStore = new CloudSecretStore();
        Map<String, TenantSecretStore> secretStoresByName = deployState.getProperties().tenantSecretStores().stream().collect(Collectors.toMap(TenantSecretStore::getName, store -> store));
        Element store2 = XML.getChild((Element)secretStoreElement, (String)"store");
        for (Element group : XML.getChildren((Element)store2, (String)"aws-parameter-store")) {
            String account = group.getAttribute("account");
            String region = group.getAttribute("aws-region");
            TenantSecretStore secretStore = secretStoresByName.get(account);
            if (secretStore == null) {
                throw new IllegalArgumentException("No configured secret store named " + account);
            }
            if (secretStore.getExternalId().isEmpty()) {
                throw new IllegalArgumentException("No external ID has been set");
            }
            cloudSecretStore.addConfig(account, region, secretStore.getAwsId(), secretStore.getRole(), (String)secretStore.getExternalId().get());
        }
        cluster.addComponent(cloudSecretStore);
    }

    private void addDeploymentSpecConfig(ApplicationContainerCluster cluster, ConfigModelContext context, DeployLogger deployLogger) {
        if (!context.getDeployState().isHosted()) {
            return;
        }
        DeploymentSpec deploymentSpec = this.app.getDeploymentSpec();
        if (deploymentSpec.isEmpty()) {
            return;
        }
        for (DeploymentSpec.DeprecatedElement deprecatedElement : deploymentSpec.deprecatedElements()) {
            deployLogger.logApplicationPackage(Level.WARNING, deprecatedElement.humanReadableString());
        }
        this.addIdentityProvider(cluster, context.getDeployState().getProperties().configServerSpecs(), context.getDeployState().getProperties().loadBalancerName(), context.getDeployState().getProperties().ztsUrl(), context.getDeployState().getProperties().athenzDnsSuffix(), context.getDeployState().zone(), deploymentSpec);
        this.addRotationProperties(cluster, context.getDeployState().getEndpoints());
    }

    private void addRotationProperties(ApplicationContainerCluster cluster, Set<ContainerEndpoint> endpoints) {
        cluster.getContainers().forEach(container -> {
            this.setRotations((Container)container, endpoints, cluster.getName());
            container.setProp("activeRotation", "true");
        });
    }

    private void setRotations(Container container, Set<ContainerEndpoint> endpoints, String containerClusterName) {
        LinkedHashSet rotationsProperty = endpoints.stream().filter(endpoint -> endpoint.clusterId().equals(containerClusterName)).filter(endpoint -> endpoint.scope() == ApplicationClusterEndpoint.Scope.global).flatMap(endpoint -> endpoint.names().stream()).collect(Collectors.toCollection(LinkedHashSet::new));
        container.setProp("rotations", String.join((CharSequence)",", rotationsProperty));
    }

    private void addConfiguredComponents(DeployState deployState, ApplicationContainerCluster cluster, Element parent) {
        for (Element components : XML.getChildren((Element)parent, (String)"components")) {
            this.addIncludes(components);
            ContainerModelBuilder.addConfiguredComponents(deployState, cluster, components, "component");
        }
        ContainerModelBuilder.addConfiguredComponents(deployState, cluster, parent, "component");
    }

    protected void addStatusHandlers(ApplicationContainerCluster cluster, boolean isHostedVespa) {
        if (isHostedVespa) {
            String name = "status.html";
            Optional<String> statusFile = Optional.ofNullable(System.getenv(HOSTED_VESPA_STATUS_FILE_SETTING));
            cluster.addComponent(new FileStatusHandlerComponent(name + "-status-handler", statusFile.orElse(HOSTED_VESPA_STATUS_FILE), SystemBindingPattern.fromHttpPath("/" + name)));
        } else {
            cluster.addVipHandler();
        }
    }

    private void addServerProviders(DeployState deployState, Element spec, ApplicationContainerCluster cluster) {
        ContainerModelBuilder.addConfiguredComponents(deployState, cluster, spec, "server");
    }

    protected void addAccessLogs(DeployState deployState, ApplicationContainerCluster cluster, Element spec) {
        List<Element> accessLogElements = this.getAccessLogElements(spec);
        if (accessLogElements.isEmpty() && deployState.getAccessLoggingEnabledByDefault()) {
            cluster.addAccessLog();
        } else if (cluster.isHostedVespa()) {
            this.log.logApplicationPackage(Level.WARNING, "Applications are not allowed to override the 'accesslog' element");
        } else {
            ArrayList components = new ArrayList();
            for (Element accessLog : accessLogElements) {
                AccessLogBuilder.buildIfNotDisabled(deployState, cluster, accessLog).ifPresent(accessLogComponent -> {
                    components.add(accessLogComponent);
                    cluster.addComponent((Component<?, ?>)accessLogComponent);
                });
            }
            if (components.size() > 0) {
                cluster.removeSimpleComponent(VoidRequestLog.class);
                cluster.addSimpleComponent(AccessLog.class);
            }
        }
        if (cluster.getAllComponents().stream().anyMatch(component -> component instanceof AccessLogComponent)) {
            cluster.addComponent(new ConnectionLogComponent(cluster, FileConnectionLog.class, "access"));
        }
    }

    private List<Element> getAccessLogElements(Element spec) {
        return XML.getChildren((Element)spec, (String)"accesslog");
    }

    protected void addHttp(DeployState deployState, Element spec, ApplicationContainerCluster cluster, ConfigModelContext context) {
        Element httpElement = XML.getChild((Element)spec, (String)"http");
        if (httpElement != null) {
            cluster.setHttp(this.buildHttp(deployState, cluster, httpElement, context));
        }
        if (ContainerModelBuilder.isHostedTenantApplication(context)) {
            ContainerModelBuilder.addHostedImplicitHttpIfNotPresent(deployState, cluster);
            this.addHostedImplicitAccessControlIfNotPresent(deployState, cluster);
            this.addDefaultConnectorHostedFilterBinding(cluster);
            this.addCloudMtlsConnector(deployState, cluster);
            ContainerModelBuilder.addCloudDataPlaneFilter(deployState, cluster);
            this.addCloudTokenSupport(deployState, cluster);
        }
    }

    private static void addCloudDataPlaneFilter(DeployState deployState, ApplicationContainerCluster cluster) {
        if (!deployState.isHosted() || !deployState.zone().system().isPublic()) {
            return;
        }
        int dataplanePort = ContainerModelBuilder.getMtlsDataplanePort(deployState, cluster);
        HttpFilterChain secureChain = new HttpFilterChain("cloud-data-plane-secure", HttpFilterChain.Type.SYSTEM);
        secureChain.addInnerComponent(new CloudDataPlaneFilter(cluster, deployState));
        cluster.getHttp().getFilterChains().add(secureChain);
        cluster.getHttp().getHttpServer().orElseThrow().getConnectorFactories().stream().filter(c -> c.getListenPort() == dataplanePort).findAny().orElseThrow().setDefaultRequestFilterChain(secureChain.getComponentId());
        HttpFilterChain insecureChain = new HttpFilterChain("cloud-data-plane-insecure", HttpFilterChain.Type.SYSTEM);
        insecureChain.addInnerComponent(new Filter(new ChainedComponentModel(new BundleInstantiationSpecification(new ComponentSpecification("com.yahoo.jdisc.http.filter.security.misc.NoopFilter"), null, new ComponentSpecification("jdisc-security-filters")), Dependencies.emptyDependencies())));
        cluster.getHttp().getFilterChains().add(insecureChain);
        ComponentSpecification insecureChainComponentSpec = new ComponentSpecification(insecureChain.getComponentId().toString());
        FilterBinding insecureBinding = FilterBinding.create(FilterBinding.Type.REQUEST, insecureChainComponentSpec, ContainerCluster.VIP_HANDLER_BINDING);
        cluster.getHttp().getBindings().add(insecureBinding);
        cluster.getHttp().getHttpServer().orElseThrow().getConnectorFactories().stream().filter(c -> c.getListenPort() == Defaults.getDefaults().vespaWebServicePort()).findAny().orElseThrow().setDefaultRequestFilterChain(insecureChain.getComponentId());
    }

    protected void addClients(DeployState deployState, Element spec, ApplicationContainerCluster cluster) {
        List<Object> clients;
        if (!deployState.isHosted() || !deployState.zone().system().isPublic()) {
            return;
        }
        Element clientsElement = XML.getChild((Element)spec, (String)"clients");
        boolean legacyMode = false;
        if (clientsElement == null) {
            clients = List.of(new Client("default", List.of(), this.getCertificates(this.app.getFile(Path.fromString((String)"security/clients.pem"))), List.of()));
            legacyMode = true;
        } else {
            clients = XML.getChildren((Element)clientsElement, (String)"client").stream().flatMap(elem -> this.getClient((Element)elem, deployState).stream()).toList();
            boolean atLeastOneClientWithCertificate = clients.stream().anyMatch(client -> !client.certificates().isEmpty());
            if (!atLeastOneClientWithCertificate) {
                throw new IllegalArgumentException("At least one client must require a certificate");
            }
        }
        List operatorAndTesterCertificates = deployState.getProperties().operatorCertificates();
        if (!operatorAndTesterCertificates.isEmpty()) {
            clients = Stream.concat(clients.stream(), Stream.of(Client.internalClient(operatorAndTesterCertificates))).toList();
        }
        cluster.setClients(legacyMode, clients);
    }

    private Optional<Client> getClient(Element clientElement, DeployState state) {
        String clientId = (String)XML.attribute((String)"id", (Element)clientElement).orElseThrow();
        if (clientId.startsWith("_")) {
            throw new IllegalArgumentException("Invalid client id '%s', id cannot start with '_'".formatted(clientId));
        }
        List<String> permissions = XML.attribute((String)"permissions", (Element)clientElement).map(p -> p.split(",")).stream().flatMap(Arrays::stream).toList();
        List<X509Certificate> certificates = XML.getChildren((Element)clientElement, (String)"certificate").stream().flatMap(certElem -> {
            ApplicationFile file = this.app.getFile(Path.fromString((String)certElem.getAttribute("file")));
            if (!file.exists()) {
                throw new IllegalArgumentException("Certificate file '%s' for client '%s' does not exist".formatted(file.getPath().getRelative(), clientId));
            }
            return this.getCertificates(file).stream();
        }).toList();
        if (!certificates.isEmpty()) {
            return Optional.of(new Client(clientId, permissions, certificates, List.of()));
        }
        Map knownTokens = state.getProperties().dataplaneTokens().stream().collect(Collectors.toMap(DataplaneToken::tokenId, Function.identity()));
        List<DataplaneToken> referencedTokens = XML.getChildren((Element)clientElement, (String)"token").stream().map(elem -> {
            String tokenId = elem.getAttribute("id");
            DataplaneToken token = (DataplaneToken)knownTokens.get(tokenId);
            if (token == null) {
                this.log.logApplicationPackage(Level.WARNING, "Token '%s' for client '%s' does not exist".formatted(tokenId, clientId));
            }
            return token;
        }).filter(token -> {
            if (token == null) {
                return false;
            }
            boolean empty = token.versions().isEmpty();
            if (empty) {
                this.log.logApplicationPackage(Level.WARNING, "Token '%s' for client '%s' has no active versions".formatted(token.tokenId(), clientId));
            }
            return !empty;
        }).toList();
        if (referencedTokens.isEmpty()) {
            this.log.log(Level.INFO, "Skipping client '%s' as it does not refer to any activate tokens".formatted(clientId));
            return Optional.empty();
        }
        return Optional.of(new Client(clientId, permissions, List.of(), referencedTokens));
    }

    private List<X509Certificate> getCertificates(ApplicationFile file) {
        if (!file.exists()) {
            return List.of();
        }
        try {
            Reader reader = file.createReader();
            String certPem = IOUtils.readAll((Reader)reader);
            reader.close();
            List x509Certificates = X509CertificateUtils.certificateListFromPem((String)certPem);
            if (x509Certificates.isEmpty()) {
                throw new IllegalArgumentException("File %s does not contain any certificates.".formatted(file.getPath().getRelative()));
            }
            return x509Certificates;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void addDefaultConnectorHostedFilterBinding(ApplicationContainerCluster cluster) {
        cluster.getHttp().getAccessControl().ifPresent(accessControl -> accessControl.configureDefaultHostedConnector(cluster.getHttp()));
    }

    private void addCloudMtlsConnector(DeployState state, ApplicationContainerCluster cluster) {
        JettyHttpServer server = cluster.getHttp().getHttpServer().get();
        String serverName = server.getComponentId().getName();
        HostedSslConnectorFactory.Builder builder = HostedSslConnectorFactory.builder(serverName, ContainerModelBuilder.getMtlsDataplanePort(state, cluster)).proxyProtocol(true, state.getProperties().featureFlags().enableProxyProtocolMixedMode()).tlsCiphersOverride(state.getProperties().tlsCiphersOverride()).endpointConnectionTtl(state.getProperties().endpointConnectionTtl());
        EndpointCertificateSecrets endpointCert = state.endpointCertificateSecrets().orElse(null);
        if (endpointCert != null) {
            builder.endpointCertificate(endpointCert);
            boolean isPublic = state.zone().system().isPublic();
            List<X509Certificate> clientCertificates = this.getClientCertificates(cluster);
            if (isPublic) {
                if (clientCertificates.isEmpty()) {
                    throw new IllegalArgumentException("Client certificate authority security/clients.pem is missing - see: https://cloud.vespa.ai/en/security/guide#data-plane");
                }
                builder.tlsCaCertificatesPem(X509CertificateUtils.toPem(clientCertificates)).clientAuth(HostedSslConnectorFactory.SslClientAuth.WANT_WITH_ENFORCER);
            } else {
                builder.tlsCaCertificatesPath("/opt/yahoo/share/ssl/certs/athenz_certificate_bundle.pem");
                Boolean needAuth = cluster.getHttp().getAccessControl().map(accessControl -> accessControl.clientAuthentication).map(clientAuth -> clientAuth == AccessControl.ClientAuthentication.need).orElse(false);
                builder.clientAuth(needAuth != false ? HostedSslConnectorFactory.SslClientAuth.NEED : HostedSslConnectorFactory.SslClientAuth.WANT);
            }
        } else {
            builder.clientAuth(HostedSslConnectorFactory.SslClientAuth.WANT_WITH_ENFORCER);
        }
        HostedSslConnectorFactory connectorFactory = builder.build();
        cluster.getHttp().getAccessControl().ifPresent(accessControl -> accessControl.configureHostedConnector(connectorFactory));
        server.addConnector(connectorFactory);
    }

    private void addCloudTokenSupport(DeployState state, ApplicationContainerCluster cluster) {
        JettyHttpServer server = cluster.getHttp().getHttpServer().get();
        if (!ContainerModelBuilder.enableTokenSupport(state, cluster)) {
            return;
        }
        Set<String> tokenEndpoints = ContainerModelBuilder.tokenEndpoints(state).stream().map(ContainerEndpoint::names).flatMap(Collection::stream).collect(Collectors.toSet());
        EndpointCertificateSecrets endpointCert = state.endpointCertificateSecrets().orElseThrow();
        int tokenPort = ContainerModelBuilder.getTokenDataplanePort(state, cluster).orElseThrow();
        cluster.addSimpleComponent(DataplaneProxyCredentials.class);
        cluster.addSimpleComponent(DataplaneProxyService.class);
        DataplaneProxy dataplaneProxy = new DataplaneProxy(ContainerModelBuilder.getMtlsDataplanePort(state, cluster), tokenPort, endpointCert.certificate(), endpointCert.key(), tokenEndpoints);
        cluster.addComponent(dataplaneProxy);
        HostedSslConnectorFactory connector = HostedSslConnectorFactory.builder(server.getComponentId().getName() + "-token", tokenPort).tokenEndpoint(true).proxyProtocol(false, false).endpointCertificate(endpointCert).remoteAddressHeader("X-Forwarded-For").remotePortHeader("X-Forwarded-Port").clientAuth(HostedSslConnectorFactory.SslClientAuth.NEED).build();
        server.addConnector(connector);
        HttpFilterChain tokenChain = new HttpFilterChain("cloud-token-data-plane-secure", HttpFilterChain.Type.SYSTEM);
        tokenChain.addInnerComponent(new CloudTokenDataPlaneFilter(cluster, state));
        cluster.getHttp().getFilterChains().add(tokenChain);
        cluster.getHttp().getHttpServer().orElseThrow().getConnectorFactories().stream().filter(c -> c.getListenPort() == tokenPort).findAny().orElseThrow().setDefaultRequestFilterChain(tokenChain.getComponentId());
    }

    private List<X509Certificate> getClientCertificates(ApplicationContainerCluster cluster) {
        return cluster.getClients().stream().map(Client::certificates).flatMap(Collection::stream).toList();
    }

    private static boolean isHostedTenantApplication(ConfigModelContext context) {
        return context.getDeployState().isHostedTenantApplication(context.getApplicationType());
    }

    private static void addHostedImplicitHttpIfNotPresent(DeployState deployState, ApplicationContainerCluster cluster) {
        JettyHttpServer httpServer;
        if (cluster.getHttp() == null) {
            cluster.setHttp(new Http(new FilterChains(cluster)));
        }
        if ((httpServer = (JettyHttpServer)cluster.getHttp().getHttpServer().orElse(null)) == null) {
            httpServer = new JettyHttpServer("DefaultHttpServer", cluster, deployState);
            cluster.getHttp().setHttpServer(httpServer);
        }
        int defaultPort = Defaults.getDefaults().vespaWebServicePort();
        boolean defaultConnectorPresent = httpServer.getConnectorFactories().stream().anyMatch(connector -> connector.getListenPort() == defaultPort);
        if (!defaultConnectorPresent) {
            httpServer.addConnector(new ConnectorFactory.Builder("SearchServer", defaultPort).build());
        }
    }

    private void addHostedImplicitAccessControlIfNotPresent(DeployState deployState, ApplicationContainerCluster cluster) {
        Http http = cluster.getHttp();
        if (http.getAccessControl().isPresent()) {
            return;
        }
        AthenzDomain tenantDomain = deployState.getProperties().athenzDomain().orElse(null);
        if (tenantDomain == null) {
            return;
        }
        new AccessControl.Builder(tenantDomain.value()).setHandlers(cluster).clientAuthentication(AccessControl.ClientAuthentication.need).build().configureHttpFilterChains(http);
    }

    private Http buildHttp(DeployState deployState, ApplicationContainerCluster cluster, Element httpElement, ConfigModelContext context) {
        Http http = (Http)new HttpBuilder(this.portBindingOverride(deployState, context, cluster)).build(deployState, cluster, httpElement);
        if (this.networking == Networking.disable) {
            http.removeAllServers();
        }
        return http;
    }

    private void addDocumentApi(DeployState deployState, Element spec, ApplicationContainerCluster cluster, ConfigModelContext context) {
        ContainerDocumentApi containerDocumentApi = this.buildDocumentApi(deployState, cluster, spec, context);
        if (containerDocumentApi == null) {
            return;
        }
        cluster.setDocumentApi(containerDocumentApi);
    }

    private void addDocproc(DeployState deployState, Element spec, ApplicationContainerCluster cluster) {
        ContainerDocproc containerDocproc = this.buildDocproc(deployState, cluster, spec);
        if (containerDocproc == null) {
            return;
        }
        cluster.setDocproc(containerDocproc);
        ContainerDocproc.Options docprocOptions = containerDocproc.options;
        cluster.setMbusParams(new ApplicationContainerCluster.MbusParams(docprocOptions.maxConcurrentFactor, docprocOptions.documentExpansionFactor, docprocOptions.containerCoreMemory));
    }

    private void addSearch(DeployState deployState, Element spec, ApplicationContainerCluster cluster, ConfigModelContext context) {
        Element searchElement = XML.getChild((Element)spec, (String)"search");
        if (searchElement == null) {
            return;
        }
        this.addIncludes(searchElement);
        cluster.setSearch(this.buildSearch(deployState, cluster, searchElement));
        this.addSearchHandler(deployState, cluster, searchElement, context);
        ContainerModelBuilder.validateAndAddConfiguredComponents(deployState, cluster, searchElement, "renderer", ContainerModelBuilder::validateRendererElement);
    }

    private void addModelEvaluation(Element spec, ApplicationContainerCluster cluster, ConfigModelContext context) {
        Element modelEvaluationElement = XML.getChild((Element)spec, (String)"model-evaluation");
        if (modelEvaluationElement == null) {
            return;
        }
        RankProfileList profiles = context.vespaModel() != null ? context.vespaModel().rankProfileList() : RankProfileList.empty;
        FileDistributedOnnxModels models = profiles.getOnnxModels().clone();
        Element onnxElement = XML.getChild((Element)modelEvaluationElement, (String)"onnx");
        Element modelsElement = XML.getChild((Element)onnxElement, (String)"models");
        for (Element modelElement : XML.getChildren((Element)modelsElement, (String)"model")) {
            OnnxModel onnxModel = models.asMap().get(modelElement.getAttribute("name"));
            if (onnxModel == null) {
                String availableModels = String.join((CharSequence)", ", profiles.getOnnxModels().asMap().keySet());
                context.getDeployState().getDeployLogger().logApplicationPackage(Level.WARNING, "Model '" + modelElement.getAttribute("name") + "' not found. Available ONNX models are: " + availableModels + ". Skipping this configuration.");
                continue;
            }
            onnxModel.setStatelessExecutionMode(this.getStringValue(modelElement, "execution-mode", null));
            onnxModel.setStatelessInterOpThreads(this.getIntValue(modelElement, "interop-threads", -1));
            onnxModel.setStatelessIntraOpThreads(this.getIntValue(modelElement, "intraop-threads", -1));
            Element gpuDeviceElement = XML.getChild((Element)modelElement, (String)"gpu-device");
            if (gpuDeviceElement != null) {
                int gpuDevice = Integer.parseInt(gpuDeviceElement.getTextContent());
                boolean hasGpu = cluster.getContainers().stream().anyMatch(container -> container.getHostResource() != null && !container.getHostResource().realResources().gpuResources().isZero());
                onnxModel.setGpuDevice(gpuDevice, hasGpu);
            }
            cluster.onnxModelCost().registerModel(context.getApplicationPackage().getFile(onnxModel.getFilePath()));
        }
        cluster.setModelEvaluation(new ContainerModelEvaluation(cluster, profiles, models));
    }

    private String getStringValue(Element element, String name, String defaultValue) {
        Element child = XML.getChild((Element)element, (String)name);
        return child != null ? child.getTextContent() : defaultValue;
    }

    private int getIntValue(Element element, String name, int defaultValue) {
        Element child = XML.getChild((Element)element, (String)name);
        return child != null ? Integer.parseInt(child.getTextContent()) : defaultValue;
    }

    protected void addModelEvaluationRuntime(ApplicationContainerCluster cluster) {
        cluster.addPlatformBundle(ContainerModelEvaluation.MODEL_EVALUATION_BUNDLE_FILE);
        cluster.addPlatformBundle(ContainerModelEvaluation.MODEL_INTEGRATION_BUNDLE_FILE);
        cluster.addPlatformBundle(ContainerModelEvaluation.ONNXRUNTIME_BUNDLE_FILE);
        cluster.addSimpleComponent("ai.vespa.modelintegration.evaluator.OnnxRuntime", null, "model-integration");
        cluster.addSimpleComponent("ai.vespa.embedding.EmbedderRuntime", null, "model-integration");
    }

    private void addProcessing(DeployState deployState, Element spec, ApplicationContainerCluster cluster, ConfigModelContext context) {
        Element processingElement = XML.getChild((Element)spec, (String)"processing");
        if (processingElement == null) {
            return;
        }
        cluster.addSearchAndDocprocBundles();
        this.addIncludes(processingElement);
        cluster.setProcessingChains((ProcessingChains)new DomProcessingBuilder(null).build(deployState, cluster, processingElement), (BindingPattern[])this.serverBindings(deployState, context, processingElement, ProcessingChains.defaultBindings, cluster).toArray(BindingPattern[]::new));
        ContainerModelBuilder.validateAndAddConfiguredComponents(deployState, cluster, processingElement, "renderer", ContainerModelBuilder::validateRendererElement);
    }

    private ContainerSearch buildSearch(DeployState deployState, ApplicationContainerCluster containerCluster, Element producerSpec) {
        SearchChains searchChains = (SearchChains)new DomSearchChainsBuilder().build(deployState, containerCluster, producerSpec);
        ContainerSearch containerSearch = new ContainerSearch(deployState, containerCluster, searchChains);
        this.applyApplicationPackageDirectoryConfigs(deployState.getApplicationPackage(), containerSearch);
        containerSearch.setQueryProfiles(deployState.getQueryProfiles());
        containerSearch.setSemanticRules(deployState.getSemanticRules());
        return containerSearch;
    }

    private void applyApplicationPackageDirectoryConfigs(ApplicationPackage applicationPackage, ContainerSearch containerSearch) {
        PageTemplates.validate(applicationPackage);
        containerSearch.setPageTemplates(PageTemplates.create(applicationPackage));
    }

    private void addUserHandlers(DeployState deployState, ApplicationContainerCluster cluster, Element spec, ConfigModelContext context) {
        for (Element component : XML.getChildren((Element)spec, (String)"handler")) {
            cluster.addComponent((Component)new DomHandlerBuilder(cluster, this.portBindingOverride(deployState, context, cluster)).build(deployState, cluster, component));
        }
    }

    private void checkVersion(Element spec) {
        String version = spec.getAttribute("version");
        if (!Version.fromString((String)version).equals((Object)new Version(1))) {
            throw new IllegalArgumentException("Expected container version to be 1.0, but got " + version);
        }
    }

    private void addNodes(ApplicationContainerCluster cluster, Element spec, ConfigModelContext context) {
        if (this.standaloneBuilder) {
            this.addStandaloneNode(cluster, context.getDeployState());
        } else {
            this.addNodesFromXml(cluster, spec, context);
        }
    }

    private void addStandaloneNode(ApplicationContainerCluster cluster, DeployState deployState) {
        ApplicationContainer container = new ApplicationContainer(cluster, "standalone", cluster.getContainers().size(), deployState);
        cluster.addContainers(Collections.singleton(container));
    }

    private static String buildJvmGCOptions(ConfigModelContext context, String jvmGCOptions) {
        return new JvmGcOptions(context.getDeployState(), jvmGCOptions).build();
    }

    private static String getJvmOptions(Element nodesElement, DeployState deployState, boolean legacyOptions) {
        return new JvmOptions(nodesElement, deployState, legacyOptions).build();
    }

    private static String extractAttribute(Element element, String attrName) {
        return element.hasAttribute(attrName) ? element.getAttribute(attrName) : null;
    }

    private void extractJvmOptions(List<ApplicationContainer> nodes, ApplicationContainerCluster cluster, Element nodesElement, ConfigModelContext context) {
        Element jvmElement = XML.getChild((Element)nodesElement, (String)"jvm");
        if (jvmElement == null) {
            this.extractJvmFromLegacyNodesTag(nodes, cluster, nodesElement, context);
        } else {
            this.extractJvmTag(nodes, cluster, nodesElement, jvmElement, context);
        }
    }

    private void extractJvmFromLegacyNodesTag(List<ApplicationContainer> nodes, ApplicationContainerCluster cluster, Element nodesElement, ConfigModelContext context) {
        ContainerModelBuilder.applyNodesTagJvmArgs(nodes, ContainerModelBuilder.getJvmOptions(nodesElement, context.getDeployState(), true));
        if (cluster.getJvmGCOptions().isEmpty()) {
            String jvmGCOptions = ContainerModelBuilder.extractAttribute(nodesElement, "jvm-gc-options");
            if (jvmGCOptions != null && !jvmGCOptions.isEmpty()) {
                DeployLogger logger = context.getDeployState().getDeployLogger();
                logger.logApplicationPackage(Level.WARNING, "'jvm-gc-options' is deprecated and will be removed in Vespa 9. Please merge into 'gc-options' in 'jvm' element. See https://docs.vespa.ai/en/reference/services-container.html#jvm");
            }
            cluster.setJvmGCOptions(ContainerModelBuilder.buildJvmGCOptions(context, jvmGCOptions));
        }
        if (ContainerModelBuilder.applyMemoryPercentage(cluster, nodesElement.getAttribute("allocated-memory"))) {
            context.getDeployState().getDeployLogger().logApplicationPackage(Level.WARNING, "'allocated-memory' is deprecated and will be removed in Vespa 9. Please merge into 'allocated-memory' in 'jvm' element. See https://docs.vespa.ai/en/reference/services-container.html#jvm");
        }
    }

    private void extractJvmTag(List<ApplicationContainer> nodes, ApplicationContainerCluster cluster, Element nodesElement, Element jvmElement, ConfigModelContext context) {
        ContainerModelBuilder.applyNodesTagJvmArgs(nodes, ContainerModelBuilder.getJvmOptions(nodesElement, context.getDeployState(), false));
        ContainerModelBuilder.applyMemoryPercentage(cluster, jvmElement.getAttribute("allocated-memory"));
        String jvmGCOptions = ContainerModelBuilder.extractAttribute(jvmElement, "gc-options");
        cluster.setJvmGCOptions(ContainerModelBuilder.buildJvmGCOptions(context, jvmGCOptions));
    }

    private void addNodesFromXml(ApplicationContainerCluster cluster, Element containerElement, ConfigModelContext context) {
        Element nodesElement = XML.getChild((Element)containerElement, (String)"nodes");
        if (nodesElement == null) {
            cluster.addContainers(this.allocateWithoutNodesTag(cluster, context));
        } else {
            List<ApplicationContainer> nodes = this.createNodes(cluster, containerElement, nodesElement, context);
            this.extractJvmOptions(nodes, cluster, nodesElement, context);
            ContainerModelBuilder.applyDefaultPreload(nodes, nodesElement);
            Set<Map.Entry<String, String>> envVars = ContainerModelBuilder.getEnvironmentVariables(XML.getChild((Element)nodesElement, (String)ENVIRONMENT_VARIABLES_ELEMENT)).entrySet();
            for (ApplicationContainer container : nodes) {
                for (Map.Entry<String, String> entry : envVars) {
                    container.addEnvironmentVariable(entry.getKey(), entry.getValue());
                }
            }
            if (ContainerModelBuilder.useCpuSocketAffinity(nodesElement)) {
                AbstractService.distributeCpuSocketAffinity(nodes);
            }
            cluster.addContainers(nodes);
        }
    }

    private ZoneEndpoint zoneEndpoint(ConfigModelContext context, ClusterSpec.Id cluster) {
        InstanceName instance = context.properties().applicationId().instance();
        ZoneId zone = ZoneId.from((Environment)context.properties().zone().environment(), (RegionName)context.properties().zone().region());
        return context.getApplicationPackage().getDeploymentSpec().zoneEndpoint(instance, zone, cluster);
    }

    private static Map<String, String> getEnvironmentVariables(Element environmentVariables) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (environmentVariables != null) {
            for (Element var : XML.getChildren((Element)environmentVariables)) {
                Identifier name = new Identifier(var.getNodeName());
                map.put(name.toString(), var.getTextContent());
            }
        }
        return map;
    }

    private List<ApplicationContainer> createNodes(ApplicationContainerCluster cluster, Element containerElement, Element nodesElement, ConfigModelContext context) {
        if (nodesElement.hasAttribute("type")) {
            return this.createNodesFromNodeType(cluster, nodesElement, context);
        }
        if (nodesElement.hasAttribute("of")) {
            List<ApplicationContainer> containers = this.createNodesFromContentServiceReference(cluster, nodesElement, context);
            this.log.logApplicationPackage(Level.WARNING, "Declaring combined cluster with <nodes of=\"...\"> is deprecated without replacement, and the feature will be removed in Vespa 9. Use separate container and content clusters instead");
            return containers;
        }
        if (nodesElement.hasAttribute("count")) {
            return this.createNodesFromNodeCount(cluster, containerElement, nodesElement, context);
        }
        if (cluster.isHostedVespa() && cluster.getZone().environment().isManuallyDeployed()) {
            return this.createNodesFromNodeCount(cluster, containerElement, nodesElement, context);
        }
        return this.createNodesFromNodeList(context.getDeployState(), cluster, nodesElement);
    }

    private static boolean applyMemoryPercentage(ApplicationContainerCluster cluster, String memoryPercentage) {
        try {
            if (memoryPercentage == null || memoryPercentage.isEmpty()) {
                return false;
            }
            if (!(memoryPercentage = memoryPercentage.trim()).endsWith("%")) {
                throw new IllegalArgumentException("Missing % sign");
            }
            memoryPercentage = memoryPercentage.substring(0, memoryPercentage.length() - 1).trim();
            cluster.setMemoryPercentage(Integer.parseInt(memoryPercentage));
            return true;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("The memory percentage given for nodes in " + cluster + " must be an integer percentage ending by the '%' sign", e);
        }
    }

    private List<ApplicationContainer> allocateWithoutNodesTag(ApplicationContainerCluster cluster, ConfigModelContext context) {
        DeployState deployState = context.getDeployState();
        HostSystem hostSystem = cluster.hostSystem();
        if (deployState.isHosted()) {
            int nodeCount = deployState.zone().environment().isProduction() ? 2 : 1;
            deployState.getDeployLogger().logApplicationPackage(Level.INFO, "Using " + nodeCount + " nodes in " + cluster);
            NodesSpecification nodesSpec = NodesSpecification.dedicated(nodeCount, context);
            ClusterSpec.Id clusterId = ClusterSpec.Id.from((String)cluster.getName());
            Map<HostResource, ClusterMembership> hosts = nodesSpec.provision(hostSystem, ClusterSpec.Type.container, clusterId, this.zoneEndpoint(context, clusterId), deployState.getDeployLogger(), false, context.clusterInfo().build());
            return this.createNodesFromHosts(hosts, cluster, context.getDeployState());
        }
        return this.singleHostContainerCluster(cluster, hostSystem.getHost("default_singlenode_container"), context);
    }

    private List<ApplicationContainer> singleHostContainerCluster(ApplicationContainerCluster cluster, HostResource host, ConfigModelContext context) {
        ApplicationContainer node = new ApplicationContainer(cluster, "container.0", 0, context.getDeployState());
        node.setHostResource(host);
        node.initService(context.getDeployState());
        return List.of(node);
    }

    private List<ApplicationContainer> createNodesFromNodeCount(ApplicationContainerCluster cluster, Element containerElement, Element nodesElement, ConfigModelContext context) {
        try {
            NodesSpecification nodesSpecification = NodesSpecification.from(new ModelElement(nodesElement), context);
            ClusterSpec.Id clusterId = ClusterSpec.Id.from((String)cluster.name());
            Map<HostResource, ClusterMembership> hosts = nodesSpecification.provision(cluster.getRoot().hostSystem(), ClusterSpec.Type.container, clusterId, this.zoneEndpoint(context, clusterId), this.log, ContainerModelBuilder.getZooKeeper(containerElement) != null, context.clusterInfo().build());
            return this.createNodesFromHosts(hosts, cluster, context.getDeployState());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("In " + cluster, e);
        }
    }

    private List<ApplicationContainer> createNodesFromNodeType(ApplicationContainerCluster cluster, Element nodesElement, ConfigModelContext context) {
        NodeType type = NodeType.valueOf((String)nodesElement.getAttribute("type"));
        ClusterSpec clusterSpec = ClusterSpec.request((ClusterSpec.Type)ClusterSpec.Type.container, (ClusterSpec.Id)ClusterSpec.Id.from((String)cluster.getName())).vespaVersion(context.getDeployState().getWantedNodeVespaVersion()).dockerImageRepository(context.getDeployState().getWantedDockerImageRepo()).build();
        Map<HostResource, ClusterMembership> hosts = cluster.getRoot().hostSystem().allocateHosts(clusterSpec, Capacity.fromRequiredNodeType((NodeType)type), this.log);
        return this.createNodesFromHosts(hosts, cluster, context.getDeployState());
    }

    private List<ApplicationContainer> createNodesFromContentServiceReference(ApplicationContainerCluster cluster, Element nodesElement, ConfigModelContext context) {
        NodesSpecification nodeSpecification;
        try {
            nodeSpecification = NodesSpecification.from(new ModelElement(nodesElement), context);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(cluster + " contains an invalid reference", e);
        }
        String referenceId = nodesElement.getAttribute("of");
        cluster.setHostClusterId(referenceId);
        Map<HostResource, ClusterMembership> hosts = StorageGroup.provisionHosts(nodeSpecification, referenceId, cluster.getRoot().hostSystem(), context);
        return this.createNodesFromHosts(hosts, cluster, context.getDeployState());
    }

    private List<ApplicationContainer> createNodesFromHosts(Map<HostResource, ClusterMembership> hosts, ApplicationContainerCluster cluster, DeployState deployState) {
        ArrayList<ApplicationContainer> nodes = new ArrayList<ApplicationContainer>();
        for (Map.Entry<HostResource, ClusterMembership> entry : hosts.entrySet()) {
            String id = "container." + entry.getValue().index();
            ApplicationContainer container = new ApplicationContainer(cluster, id, entry.getValue().retired(), entry.getValue().index(), deployState);
            container.setHostResource(entry.getKey());
            container.initService(deployState);
            nodes.add(container);
        }
        return nodes;
    }

    private List<ApplicationContainer> createNodesFromNodeList(DeployState deployState, ApplicationContainerCluster cluster, Element nodesElement) {
        ArrayList<ApplicationContainer> nodes = new ArrayList<ApplicationContainer>();
        int nodeIndex = 0;
        for (Element nodeElem : XML.getChildren((Element)nodesElement, (String)"node")) {
            nodes.add((ApplicationContainer)new ContainerServiceBuilder("container." + nodeIndex, nodeIndex).build(deployState, cluster, nodeElem));
            ++nodeIndex;
        }
        return nodes;
    }

    private static boolean useCpuSocketAffinity(Element nodesElement) {
        if (nodesElement.hasAttribute("cpu-socket-affinity")) {
            return Boolean.parseBoolean(nodesElement.getAttribute("cpu-socket-affinity"));
        }
        return false;
    }

    private static void applyNodesTagJvmArgs(List<ApplicationContainer> containers, String jvmArgs) {
        for (Container container : containers) {
            if (!container.getAssignedJvmOptions().isEmpty()) continue;
            container.prependJvmOptions(jvmArgs);
        }
    }

    private static void applyDefaultPreload(List<ApplicationContainer> containers, Element nodesElement) {
        if (!nodesElement.hasAttribute("preload")) {
            return;
        }
        for (Container container : containers) {
            container.setPreLoad(nodesElement.getAttribute("preload"));
        }
    }

    private void addSearchHandler(DeployState deployState, ApplicationContainerCluster cluster, Element searchElement, ConfigModelContext context) {
        List<BindingPattern> bindingPatterns = List.of(SearchHandler.DEFAULT_BINDING);
        if (ContainerModelBuilder.isHostedTenantApplication(context)) {
            bindingPatterns = SearchHandler.bindingPattern(ContainerModelBuilder.getDataplanePorts(deployState, cluster));
        }
        SearchHandler searchHandler = new SearchHandler(cluster, this.serverBindings(deployState, context, searchElement, bindingPatterns, cluster), ContainerThreadpool.UserOptions.fromXml(searchElement).orElse(null));
        cluster.addComponent(searchHandler);
        searchHandler.addComponent(Component.fromClassAndBundle(SearchHandler.EXECUTION_FACTORY, "container-search-and-docproc"));
    }

    private List<BindingPattern> serverBindings(DeployState deployState, ConfigModelContext context, Element searchElement, Collection<BindingPattern> defaultBindings, ApplicationContainerCluster cluster) {
        List bindings = XML.getChildren((Element)searchElement, (String)"binding");
        if (bindings.isEmpty()) {
            return List.copyOf(defaultBindings);
        }
        return this.toBindingList(deployState, context, bindings, cluster);
    }

    private List<BindingPattern> toBindingList(DeployState deployState, ConfigModelContext context, List<Element> bindingElements, ApplicationContainerCluster cluster) {
        ArrayList<BindingPattern> result = new ArrayList<BindingPattern>();
        Set<Integer> portOverride = ContainerModelBuilder.isHostedTenantApplication(context) ? ContainerModelBuilder.getDataplanePorts(deployState, cluster) : Set.of();
        for (Element element : bindingElements) {
            String text = element.getTextContent().trim();
            if (text.isEmpty()) continue;
            result.addAll(ContainerModelBuilder.userBindingPattern(text, portOverride));
        }
        return result;
    }

    private static Collection<UserBindingPattern> userBindingPattern(String path, Set<Integer> portBindingOverride) {
        UserBindingPattern bindingPattern = UserBindingPattern.fromPattern(path);
        if (portBindingOverride.isEmpty()) {
            return Set.of(bindingPattern);
        }
        return portBindingOverride.stream().map(bindingPattern::withOverriddenPort).toList();
    }

    private ContainerDocumentApi buildDocumentApi(DeployState deployState, ApplicationContainerCluster cluster, Element spec, ConfigModelContext context) {
        Element documentApiElement = XML.getChild((Element)spec, (String)"document-api");
        if (documentApiElement == null) {
            return null;
        }
        ContainerDocumentApi.HandlerOptions documentApiOptions = DocumentApiOptionsBuilder.build(documentApiElement);
        Element ignoreUndefinedFields = XML.getChild((Element)documentApiElement, (String)"ignore-undefined-fields");
        return new ContainerDocumentApi(cluster, documentApiOptions, "true".equals(XML.getValue((Element)ignoreUndefinedFields)), this.portBindingOverride(deployState, context, cluster));
    }

    private Set<Integer> portBindingOverride(DeployState deployState, ConfigModelContext context, ApplicationContainerCluster cluster) {
        return ContainerModelBuilder.isHostedTenantApplication(context) ? ContainerModelBuilder.getDataplanePorts(deployState, cluster) : Set.of();
    }

    private ContainerDocproc buildDocproc(DeployState deployState, ApplicationContainerCluster cluster, Element spec) {
        Element docprocElement = XML.getChild((Element)spec, (String)"document-processing");
        if (docprocElement == null) {
            return null;
        }
        this.addIncludes(docprocElement);
        DocprocChains chains = (DocprocChains)new DomDocprocChainsBuilder(null, false).build(deployState, cluster, docprocElement);
        ContainerDocproc.Options docprocOptions = DocprocOptionsBuilder.build(docprocElement, deployState.getDeployLogger());
        return new ContainerDocproc(cluster, chains, docprocOptions, !this.standaloneBuilder);
    }

    private void addIncludes(Element parentElement) {
        List includes = XML.getChildren((Element)parentElement, (String)"include");
        if (includes.isEmpty()) {
            return;
        }
        if (this.app == null) {
            throw new IllegalArgumentException("Element <include> given in XML config, but no application package given.");
        }
        for (Element include : includes) {
            this.addInclude(parentElement, include);
        }
    }

    private void addInclude(Element parentElement, Element include) {
        String dirName = include.getAttribute("dir");
        this.app.validateIncludeDir(dirName);
        List includedFiles = Xml.allElemsFromPath((ApplicationPackage)this.app, (String)dirName);
        for (Element includedFile : includedFiles) {
            List includedSubElements = XML.getChildren((Element)includedFile);
            for (Element includedSubElement : includedSubElements) {
                Node copiedNode = parentElement.getOwnerDocument().importNode(includedSubElement, true);
                parentElement.appendChild(copiedNode);
            }
        }
    }

    private static void addConfiguredComponents(DeployState deployState, ContainerCluster<? extends Container> cluster, Element parent, String componentName) {
        for (Element component : XML.getChildren((Element)parent, (String)componentName)) {
            ModelIdResolver.resolveModelIds(component, deployState.isHosted());
            cluster.addComponent((Component)new DomComponentBuilder().build(deployState, cluster, component));
        }
    }

    private static void validateAndAddConfiguredComponents(DeployState deployState, ContainerCluster<? extends Container> cluster, Element spec, String componentName, Consumer<Element> elementValidator) {
        for (Element node : XML.getChildren((Element)spec, (String)componentName)) {
            elementValidator.accept(node);
            cluster.addComponent((Component)new DomComponentBuilder().build(deployState, cluster, node));
        }
    }

    private void addIdentityProvider(ApplicationContainerCluster cluster, List<ConfigServerSpec> configServerSpecs, HostName loadBalancerName, URI ztsUrl, String athenzDnsSuffix, Zone zone, DeploymentSpec spec) {
        spec.athenzDomain().ifPresent(domain -> {
            AthenzService service = (AthenzService)spec.athenzService(this.app.getApplicationId().instance(), zone.environment(), zone.region()).orElseThrow(() -> new IllegalArgumentException("Missing Athenz service configuration in instance '" + this.app.getApplicationId().instance() + "'"));
            String zoneDnsSuffix = zone.environment().value() + "-" + zone.region().value() + "." + athenzDnsSuffix;
            IdentityProvider identityProvider = new IdentityProvider((AthenzDomain)domain, service, this.getLoadBalancerName(loadBalancerName, configServerSpecs), ztsUrl, zoneDnsSuffix, zone);
            cluster.removeComponent(ComponentId.fromString((String)"com.yahoo.container.jdisc.AthenzIdentityProviderProvider"));
            cluster.addComponent(identityProvider);
            String serviceIdentityProviderProvider = "com.yahoo.vespa.athenz.identityprovider.client.ServiceIdentityProviderProvider";
            cluster.addComponent(new SimpleComponent(new ComponentModel(serviceIdentityProviderProvider, serviceIdentityProviderProvider, "vespa-athenz")));
            cluster.getContainers().forEach(container -> {
                container.setProp("identity.domain", domain.value());
                container.setProp("identity.service", service.value());
            });
        });
    }

    private HostName getLoadBalancerName(HostName loadbalancerName, List<ConfigServerSpec> configServerSpecs) {
        return Optional.ofNullable(loadbalancerName).orElseGet(() -> HostName.of((String)configServerSpecs.stream().findFirst().map(ConfigServerSpec::getHostName).orElse("unknown")));
    }

    private static Element getZooKeeper(Element spec) {
        return XML.getChild((Element)spec, (String)"zookeeper");
    }

    private static void validateRendererElement(Element element) {
        String idAttr = element.getAttribute("id");
        if (idAttr.equals(xmlRendererId) || idAttr.equals(jsonRendererId)) {
            throw new IllegalArgumentException(String.format("Renderer id %s is reserved for internal use", idAttr));
        }
    }

    public static boolean isContainerTag(Element element) {
        return CONTAINER_TAG.equals(element.getTagName());
    }

    private static Set<Integer> getDataplanePorts(DeployState ds, ApplicationContainerCluster cluster) {
        OptionalInt tokenPort = ContainerModelBuilder.getTokenDataplanePort(ds, cluster);
        int mtlsPort = ContainerModelBuilder.getMtlsDataplanePort(ds, cluster);
        return tokenPort.isPresent() ? Set.of(Integer.valueOf(mtlsPort), Integer.valueOf(tokenPort.getAsInt())) : Set.of(Integer.valueOf(mtlsPort));
    }

    private static int getMtlsDataplanePort(DeployState ds, ApplicationContainerCluster cluster) {
        return ContainerModelBuilder.enableTokenSupport(ds, cluster) ? 8443 : 4443;
    }

    private static OptionalInt getTokenDataplanePort(DeployState ds, ApplicationContainerCluster cluster) {
        return ContainerModelBuilder.enableTokenSupport(ds, cluster) ? OptionalInt.of(8444) : OptionalInt.empty();
    }

    private static Set<ContainerEndpoint> tokenEndpoints(DeployState deployState) {
        return deployState.getEndpoints().stream().filter(endpoint -> endpoint.authMethod() == ApplicationClusterEndpoint.AuthMethod.token).collect(Collectors.toSet());
    }

    private static boolean enableTokenSupport(DeployState state, ApplicationContainerCluster cluster) {
        Set<ContainerEndpoint> tokenEndpoints = ContainerModelBuilder.tokenEndpoints(state);
        return state.isHosted() && state.zone().system().isPublic() && !tokenEndpoints.isEmpty();
    }

    public static enum Networking {
        disable,
        enable;

    }

    private static class JvmGcOptions {
        private static final Pattern validPattern = Pattern.compile("-XX:[+-]*[a-zA-z0-9=]+");
        private static final Pattern invalidCMSPattern = Pattern.compile("-XX:[+-]\\w*CMS[a-zA-z0-9=]+");
        private final DeployState deployState;
        private final String jvmGcOptions;
        private final DeployLogger logger;
        private final boolean isHosted;

        public JvmGcOptions(DeployState deployState, String jvmGcOptions) {
            this.deployState = deployState;
            this.jvmGcOptions = jvmGcOptions;
            this.logger = deployState.getDeployLogger();
            this.isHosted = deployState.isHosted();
        }

        private String build() {
            String options = this.deployState.getProperties().jvmGCOptions();
            if (this.jvmGcOptions != null) {
                options = this.jvmGcOptions;
                String[] optionList = options.split(" ");
                List<String> invalidOptions = Arrays.stream(optionList).filter(option -> !option.isEmpty()).filter(option -> !Pattern.matches(validPattern.pattern(), option) || Pattern.matches(invalidCMSPattern.pattern(), option) || option.equals("-XX:+UseConcMarkSweepGC")).sorted().toList();
                this.logOrFailInvalidOptions(invalidOptions);
            }
            if (options == null || options.isEmpty()) {
                options = this.deployState.isHosted() ? "-XX:+UseParallelGC -XX:MaxTenuringThreshold=15 -XX:NewRatio=1" : "-XX:+UseG1GC -XX:MaxTenuringThreshold=15";
            }
            return options;
        }

        private void logOrFailInvalidOptions(List<String> options) {
            if (options.isEmpty()) {
                return;
            }
            String message = "Invalid or misplaced JVM GC options in services.xml: " + String.join((CharSequence)",", options) + ". See https://docs.vespa.ai/en/reference/services-container.html#jvm";
            if (this.isHosted) {
                throw new IllegalArgumentException(message);
            }
            this.logger.logApplicationPackage(Level.WARNING, message);
        }
    }

    private static class JvmOptions {
        private static final Pattern validPattern = Pattern.compile("-[a-zA-z0-9=:./,+*-]+");
        private static final Pattern invalidInHostedPattern = Pattern.compile("-Xrunjdwp:transport=.*");
        private final Element nodesElement;
        private final DeployLogger logger;
        private final boolean legacyOptions;
        private final boolean isHosted;

        public JvmOptions(Element nodesElement, DeployState deployState, boolean legacyOptions) {
            this.nodesElement = nodesElement;
            this.logger = deployState.getDeployLogger();
            this.legacyOptions = legacyOptions;
            this.isHosted = deployState.isHosted();
        }

        String build() {
            if (this.legacyOptions) {
                return this.buildLegacyOptions();
            }
            Element jvmElement = XML.getChild((Element)this.nodesElement, (String)"jvm");
            if (jvmElement == null) {
                return "";
            }
            String jvmOptions = jvmElement.getAttribute("options");
            if (jvmOptions.isEmpty()) {
                return "";
            }
            this.validateJvmOptions(jvmOptions);
            return jvmOptions;
        }

        String buildLegacyOptions() {
            String jvmOptions = null;
            if (this.nodesElement.hasAttribute("jvm-options") && !(jvmOptions = this.nodesElement.getAttribute("jvm-options")).isEmpty()) {
                this.logger.logApplicationPackage(Level.WARNING, "'jvm-options' is deprecated and will be removed in Vespa 9. Please merge 'jvm-options' into 'options' or 'gc-options' in 'jvm' element. See https://docs.vespa.ai/en/reference/services-container.html#jvm");
            }
            this.validateJvmOptions(jvmOptions);
            return jvmOptions;
        }

        private void validateJvmOptions(String jvmOptions) {
            if (jvmOptions == null || jvmOptions.isEmpty()) {
                return;
            }
            String[] optionList = jvmOptions.split(" ");
            List invalidOptions = Arrays.stream(optionList).filter(option -> !option.isEmpty()).filter(option -> !Pattern.matches(validPattern.pattern(), option)).sorted().collect(Collectors.toCollection(ArrayList::new));
            if (this.isHosted) {
                invalidOptions.addAll(Arrays.stream(optionList).filter(option -> !option.isEmpty()).filter(option -> Pattern.matches(invalidInHostedPattern.pattern(), option)).sorted().toList());
            }
            if (invalidOptions.isEmpty()) {
                return;
            }
            String message = "Invalid or misplaced JVM options in services.xml: " + String.join((CharSequence)",", invalidOptions) + ". See https://docs.vespa.ai/en/reference/services-container.html#jvm";
            if (this.isHosted) {
                throw new IllegalArgumentException(message);
            }
            this.logger.logApplicationPackage(Level.WARNING, message);
        }
    }
}

