/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation;

import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.application.validation.Validator;
import com.yahoo.vespa.model.container.ApplicationContainerCluster;
import com.yahoo.vespa.model.container.http.HttpFilterChain;
import java.util.Comparator;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.stream.Collectors;

public class CloudUserFilterValidator
extends Validator {
    @Override
    public void validate(VespaModel model, DeployState state) {
        if (!state.isHostedTenantApplication(model.getAdmin().getApplicationType())) {
            return;
        }
        if (state.getProperties().allowUserFilters()) {
            return;
        }
        TreeSet<Violation> violations = new TreeSet<Violation>();
        for (ApplicationContainerCluster cluster : model.getContainerClusters().values()) {
            if (cluster.getHttp() == null) continue;
            for (HttpFilterChain chain : cluster.getHttp().getFilterChains().allChains().allComponents()) {
                if (chain.type() != HttpFilterChain.Type.USER) continue;
                String msg = "Found filter chain violation - chain '%s' in cluster '%s'".formatted(cluster.name(), chain.id());
                state.getDeployLogger().log(Level.WARNING, msg);
                violations.add(new Violation(cluster.name(), chain.id()));
            }
        }
        if (violations.isEmpty()) {
            return;
        }
        String violationsStr = violations.stream().map(v -> "chain '%s' in cluster '%s'".formatted(v.chain(), v.cluster())).collect(Collectors.joining(", ", "[", "]"));
        String msg = "HTTP filter chains are currently not supported in Vespa Cloud (%s)".formatted(violationsStr);
        throw new IllegalArgumentException(msg);
    }

    private record Violation(String cluster, String chain) implements Comparable<Violation>
    {
        @Override
        public int compareTo(Violation other) {
            return Comparator.comparing(Violation::chain).thenComparing(Violation::cluster).compare(this, other);
        }
    }
}

