/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.http.ssl;

import com.yahoo.config.model.api.EndpointCertificateSecrets;
import com.yahoo.jdisc.http.ConnectorConfig;
import com.yahoo.security.tls.TlsContext;
import com.yahoo.vespa.model.container.http.ConnectorFactory;
import com.yahoo.vespa.model.container.http.ssl.CloudSslProvider;
import com.yahoo.vespa.model.container.http.ssl.DefaultSslProvider;
import com.yahoo.vespa.model.container.http.ssl.SslProvider;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class HostedSslConnectorFactory
extends ConnectorFactory {
    private final SslClientAuth clientAuth;
    private final List<String> tlsCiphersOverride;
    private final boolean proxyProtocolEnabled;
    private final boolean proxyProtocolMixedMode;
    private final Duration endpointConnectionTtl;
    private final List<String> remoteAddressHeaders;
    private final List<String> remotePortHeaders;

    public static Builder builder(String name, int listenPort) {
        return new Builder(name, listenPort);
    }

    private HostedSslConnectorFactory(Builder builder) {
        super(new ConnectorFactory.Builder("tls" + builder.port, builder.port).sslProvider(HostedSslConnectorFactory.createSslProvider(builder)));
        this.clientAuth = builder.clientAuth;
        this.tlsCiphersOverride = List.copyOf(builder.tlsCiphersOverride);
        this.proxyProtocolEnabled = builder.proxyProtocolEnabled;
        this.proxyProtocolMixedMode = builder.proxyProtocolMixedMode;
        this.endpointConnectionTtl = builder.endpointConnectionTtl;
        this.remoteAddressHeaders = List.copyOf(builder.remoteAddressHeaders);
        this.remotePortHeaders = List.copyOf(builder.remotePortHeaders);
    }

    private static SslProvider createSslProvider(Builder builder) {
        if (builder.endpointCertificate == null) {
            return new DefaultSslProvider(builder.name);
        }
        ConnectorConfig.Ssl.ClientAuth.Enum sslClientAuth = builder.clientAuth == SslClientAuth.NEED ? ConnectorConfig.Ssl.ClientAuth.Enum.NEED_AUTH : ConnectorConfig.Ssl.ClientAuth.Enum.WANT_AUTH;
        return new CloudSslProvider(builder.name, builder.endpointCertificate.key(), builder.endpointCertificate.certificate(), builder.tlsCaCertificatesPath, builder.tlsCaCertificatesPem, sslClientAuth, builder.tokenEndpoint);
    }

    @Override
    public void getConfig(ConnectorConfig.Builder connectorBuilder) {
        super.getConfig(connectorBuilder);
        if (this.clientAuth == SslClientAuth.WANT_WITH_ENFORCER) {
            connectorBuilder.tlsClientAuthEnforcer(new ConnectorConfig.TlsClientAuthEnforcer.Builder().pathWhitelist(List.of("/status.html")).enable(true));
        }
        connectorBuilder.ssl.enabledProtocols(List.of("TLSv1.2"));
        if (!this.tlsCiphersOverride.isEmpty()) {
            connectorBuilder.ssl.enabledCipherSuites(this.tlsCiphersOverride.stream().sorted().toList());
        } else {
            connectorBuilder.ssl.enabledCipherSuites(TlsContext.ALLOWED_CIPHER_SUITES.stream().sorted().toList());
        }
        connectorBuilder.proxyProtocol(new ConnectorConfig.ProxyProtocol.Builder().enabled(this.proxyProtocolEnabled).mixedMode(this.proxyProtocolMixedMode)).idleTimeout((double)Duration.ofSeconds(30L).toSeconds()).maxConnectionLife(this.endpointConnectionTtl != null ? (double)this.endpointConnectionTtl.toSeconds() : 0.0).accessLog(new ConnectorConfig.AccessLog.Builder().remoteAddressHeaders(this.remoteAddressHeaders).remotePortHeaders(this.remotePortHeaders));
    }

    public static class Builder {
        final String name;
        final int port;
        final List<String> remoteAddressHeaders = new ArrayList<String>();
        final List<String> remotePortHeaders = new ArrayList<String>();
        SslClientAuth clientAuth;
        List<String> tlsCiphersOverride = List.of();
        boolean proxyProtocolEnabled;
        boolean proxyProtocolMixedMode;
        Duration endpointConnectionTtl;
        EndpointCertificateSecrets endpointCertificate;
        String tlsCaCertificatesPem;
        String tlsCaCertificatesPath;
        boolean tokenEndpoint;

        private Builder(String name, int port) {
            this.name = name;
            this.port = port;
        }

        public Builder clientAuth(SslClientAuth auth) {
            this.clientAuth = auth;
            return this;
        }

        public Builder endpointConnectionTtl(Duration ttl) {
            this.endpointConnectionTtl = ttl;
            return this;
        }

        public Builder tlsCiphersOverride(Collection<String> ciphers) {
            this.tlsCiphersOverride = List.copyOf(ciphers);
            return this;
        }

        public Builder proxyProtocol(boolean enabled, boolean mixedMode) {
            this.proxyProtocolEnabled = enabled;
            this.proxyProtocolMixedMode = mixedMode;
            return this;
        }

        public Builder endpointCertificate(EndpointCertificateSecrets cert) {
            this.endpointCertificate = cert;
            return this;
        }

        public Builder tlsCaCertificatesPath(String path) {
            this.tlsCaCertificatesPath = path;
            return this;
        }

        public Builder tlsCaCertificatesPem(String pem) {
            this.tlsCaCertificatesPem = pem;
            return this;
        }

        public Builder tokenEndpoint(boolean enable) {
            this.tokenEndpoint = enable;
            return this;
        }

        public Builder remoteAddressHeader(String header) {
            this.remoteAddressHeaders.add(header);
            return this;
        }

        public Builder remotePortHeader(String header) {
            this.remotePortHeaders.add(header);
            return this;
        }

        public HostedSslConnectorFactory build() {
            return new HostedSslConnectorFactory(this);
        }
    }

    public static enum SslClientAuth {
        WANT,
        NEED,
        WANT_WITH_ENFORCER;

    }
}

