/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.component;

import com.yahoo.config.ModelReference;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.embedding.BertBaseEmbedderConfig;
import com.yahoo.text.XML;
import com.yahoo.vespa.model.container.component.TypedComponent;
import com.yahoo.vespa.model.container.xml.ModelIdResolver;
import org.w3c.dom.Element;

public class BertEmbedder
extends TypedComponent
implements BertBaseEmbedderConfig.Producer {
    private final ModelReference model;
    private final ModelReference vocab;
    private final Integer maxTokens;
    private final String transformerInputIds;
    private final String transformerAttentionMask;
    private final String transformerTokenTypeIds;
    private final String transformerOutput;
    private final Integer tranformerStartSequenceToken;
    private final Integer transformerEndSequenceToken;
    private final String poolingStrategy;
    private final String onnxExecutionMode;
    private final Integer onnxInteropThreads;
    private final Integer onnxIntraopThreads;
    private final Integer onnxGpuDevice;

    public BertEmbedder(Element xml, DeployState state) {
        super("ai.vespa.embedding.BertBaseEmbedder", "model-integration", xml);
        this.model = ModelIdResolver.resolveToModelReference(XML.getChild((Element)xml, (String)"transformer-model"), state);
        this.vocab = ModelIdResolver.resolveToModelReference(XML.getChild((Element)xml, (String)"tokenizer-vocab"), state);
        this.maxTokens = XML.getChildValue((Element)xml, (String)"max-tokens").map(Integer::parseInt).orElse(null);
        this.transformerInputIds = XML.getChildValue((Element)xml, (String)"transformer-input-ids").orElse(null);
        this.transformerAttentionMask = XML.getChildValue((Element)xml, (String)"transformer-attention-mask").orElse(null);
        this.transformerTokenTypeIds = XML.getChildValue((Element)xml, (String)"transformer-token-type-ids").orElse(null);
        this.transformerOutput = XML.getChildValue((Element)xml, (String)"transformer-output").orElse(null);
        this.tranformerStartSequenceToken = XML.getChildValue((Element)xml, (String)"transformer-start-sequence-token").map(Integer::parseInt).orElse(null);
        this.transformerEndSequenceToken = XML.getChildValue((Element)xml, (String)"transformer-end-sequence-token").map(Integer::parseInt).orElse(null);
        this.poolingStrategy = XML.getChildValue((Element)xml, (String)"pooling-strategy").orElse(null);
        this.onnxExecutionMode = XML.getChildValue((Element)xml, (String)"onnx-execution-mode").orElse(null);
        this.onnxInteropThreads = XML.getChildValue((Element)xml, (String)"onnx-interop-threads").map(Integer::parseInt).orElse(null);
        this.onnxIntraopThreads = XML.getChildValue((Element)xml, (String)"onnx-intraop-threads").map(Integer::parseInt).orElse(null);
        this.onnxGpuDevice = XML.getChildValue((Element)xml, (String)"onnx-gpu-device").map(Integer::parseInt).orElse(null);
    }

    public void getConfig(BertBaseEmbedderConfig.Builder b) {
        b.transformerModel(this.model).tokenizerVocab(this.vocab);
        if (this.maxTokens != null) {
            b.transformerMaxTokens(this.maxTokens.intValue());
        }
        if (this.transformerInputIds != null) {
            b.transformerInputIds(this.transformerInputIds);
        }
        if (this.transformerAttentionMask != null) {
            b.transformerAttentionMask(this.transformerAttentionMask);
        }
        if (this.transformerTokenTypeIds != null) {
            b.transformerTokenTypeIds(this.transformerTokenTypeIds);
        }
        if (this.transformerOutput != null) {
            b.transformerOutput(this.transformerOutput);
        }
        if (this.tranformerStartSequenceToken != null) {
            b.transformerStartSequenceToken(this.tranformerStartSequenceToken.intValue());
        }
        if (this.transformerEndSequenceToken != null) {
            b.transformerEndSequenceToken(this.transformerEndSequenceToken.intValue());
        }
        if (this.poolingStrategy != null) {
            b.poolingStrategy(BertBaseEmbedderConfig.PoolingStrategy.Enum.valueOf((String)this.poolingStrategy));
        }
        if (this.onnxExecutionMode != null) {
            b.onnxExecutionMode(BertBaseEmbedderConfig.OnnxExecutionMode.Enum.valueOf((String)this.onnxExecutionMode));
        }
        if (this.onnxInteropThreads != null) {
            b.onnxInterOpThreads(this.onnxInteropThreads.intValue());
        }
        if (this.onnxIntraopThreads != null) {
            b.onnxIntraOpThreads(this.onnxIntraopThreads.intValue());
        }
        if (this.onnxGpuDevice != null) {
            b.onnxGpuDevice(this.onnxGpuDevice.intValue());
        }
    }
}

