/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.document.Field;
import com.yahoo.schema.RankProfileRegistry;
import com.yahoo.schema.Schema;
import com.yahoo.schema.document.SDField;
import com.yahoo.schema.processing.Processor;
import com.yahoo.vespa.indexinglanguage.ExpressionConverter;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.InputExpression;
import com.yahoo.vespa.indexinglanguage.expressions.OutputExpression;
import com.yahoo.vespa.model.container.search.QueryProfiles;

public class IndexingValues
extends Processor {
    public IndexingValues(Schema schema, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(schema, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        if (!validate) {
            return;
        }
        for (Field field : this.schema.getDocument().fieldSet()) {
            SDField sdField = (SDField)field;
            if (sdField.isExtraField()) continue;
            new RequireThatDocumentFieldsAreImmutable(field).convert((Expression)sdField.getIndexingScript());
        }
    }

    private class RequireThatDocumentFieldsAreImmutable
    extends ExpressionConverter {
        final Field field;
        Expression mutatedBy;

        RequireThatDocumentFieldsAreImmutable(Field field) {
            this.field = field;
        }

        public ExpressionConverter branch() {
            return this.clone();
        }

        protected boolean shouldConvert(Expression exp) {
            if (exp instanceof OutputExpression && this.mutatedBy != null) {
                throw IndexingValues.this.newProcessException(IndexingValues.this.schema, this.field, "Indexing expression '" + this.mutatedBy + "' attempts to modify the value of the document field '" + this.field.getName() + "'. Use a field outside the document block instead.");
            }
            if (exp instanceof InputExpression && ((InputExpression)exp).getFieldName().equals(this.field.getName())) {
                this.mutatedBy = null;
            } else if (exp.createdOutputType() != null) {
                this.mutatedBy = exp;
            }
            return false;
        }

        protected Expression doConvert(Expression exp) {
            throw new UnsupportedOperationException();
        }
    }
}

