/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.content.cluster;

import com.yahoo.vespa.model.builder.xml.dom.ModelElement;
import com.yahoo.vespa.model.content.IndexedHierarchicDistributionValidator;
import com.yahoo.vespa.model.content.Redundancy;

public class RedundancyBuilder {
    Integer initialRedundancy = 2;
    Integer finalRedundancy = 3;
    Integer readyCopies = 2;

    RedundancyBuilder(ModelElement clusterXml) {
        ModelElement redundancyElement = clusterXml.child("redundancy");
        if (redundancyElement != null) {
            this.initialRedundancy = redundancyElement.integerAttribute("reply-after");
            this.finalRedundancy = (int)redundancyElement.asLong();
            if (this.initialRedundancy == null) {
                this.initialRedundancy = this.finalRedundancy;
            } else if (this.finalRedundancy < this.initialRedundancy) {
                throw new IllegalArgumentException("Final redundancy must be higher than or equal to initial redundancy");
            }
            this.readyCopies = clusterXml.childAsInteger("engine.proton.searchable-copies");
            if (this.readyCopies == null) {
                this.readyCopies = Math.min(this.finalRedundancy, 2);
            }
            if (this.readyCopies > this.finalRedundancy) {
                throw new IllegalArgumentException("Number of searchable copies can not be higher than final redundancy");
            }
        }
    }

    public Redundancy build(String clusterName, boolean isHosted, int subGroups, int leafGroups, int totalNodes) {
        if (isHosted) {
            return new Redundancy(this.initialRedundancy, this.finalRedundancy, this.readyCopies, leafGroups, totalNodes);
        }
        subGroups = Math.max(1, subGroups);
        IndexedHierarchicDistributionValidator.validateThatLeafGroupsCountIsAFactorOfRedundancy(clusterName, this.finalRedundancy, subGroups);
        IndexedHierarchicDistributionValidator.validateThatReadyCopiesIsCompatibleWithRedundancy(clusterName, this.finalRedundancy, this.readyCopies, subGroups);
        return new Redundancy(this.initialRedundancy / subGroups, this.finalRedundancy / subGroups, this.readyCopies / subGroups, subGroups, totalNodes);
    }
}

