/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.component;

import com.yahoo.component.ComponentId;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class ConfigProducerGroup<CHILD extends AbstractConfigProducer<?>>
extends AbstractConfigProducer<CHILD> {
    private final Map<ComponentId, CHILD> producerById = new LinkedHashMap<ComponentId, CHILD>();

    public ConfigProducerGroup(AbstractConfigProducer parent, String subId) {
        super(parent, subId);
    }

    public void addComponent(ComponentId id, CHILD producer) {
        AbstractConfigProducer existing = (AbstractConfigProducer)this.producerById.put(id, producer);
        if (existing != null) {
            throw new IllegalArgumentException("Both " + producer + " and " + existing + " are configured with the id '" + id + "'. All components must have a unique id.");
        }
        this.addChild(producer);
    }

    public CHILD removeComponent(ComponentId componentId) {
        AbstractConfigProducer component = (AbstractConfigProducer)this.producerById.remove(componentId);
        if (component == null) {
            return null;
        }
        this.removeChild(component);
        return (CHILD)component;
    }

    public Collection<CHILD> getComponents() {
        return Collections.unmodifiableCollection(this.getChildren().values());
    }

    public <T extends CHILD> Collection<T> getComponents(Class<T> componentClass) {
        ArrayList<AbstractConfigProducer> result = new ArrayList<AbstractConfigProducer>();
        for (AbstractConfigProducer child : this.getChildren().values()) {
            if (!componentClass.isInstance(child)) continue;
            result.add((AbstractConfigProducer)componentClass.cast(child));
        }
        return Collections.unmodifiableCollection(result);
    }

    public Map<ComponentId, CHILD> getComponentMap() {
        return Collections.unmodifiableMap(this.producerById);
    }
}

