/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation;

import com.yahoo.config.application.api.DeploymentSpec;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.application.validation.Validator;
import com.yahoo.vespa.model.container.ContainerModel;
import java.io.Reader;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class DeploymentFileValidator
extends Validator {
    @Override
    public void validate(VespaModel model, DeployState deployState) {
        Set containerClusters;
        Reader deploymentReader;
        DeploymentSpec deploymentSpec;
        Optional globalServiceId;
        Optional deployment = deployState.getApplicationPackage().getDeployment();
        if (deployment.isPresent() && (globalServiceId = (deploymentSpec = DeploymentSpec.fromXml((Reader)(deploymentReader = (Reader)deployment.get()))).globalServiceId()).isPresent() && (containerClusters = model.getRoot().configModelRepo().getModels(ContainerModel.class).stream().map(ContainerModel::getCluster).filter(cc -> cc.getName().equals(globalServiceId.get())).collect(Collectors.toSet())).size() != 1) {
            throw new IllegalArgumentException("global-service-id '" + (String)globalServiceId.get() + "' specified in deployment.xml does not match any container cluster id");
        }
    }
}

