/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model;

import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.ConfigurationRuntimeException;
import com.yahoo.config.codegen.CNode;
import com.yahoo.config.codegen.InnerCNode;
import com.yahoo.config.codegen.LeafCNode;
import com.yahoo.vespa.config.ConfigDefinitionKey;
import com.yahoo.yolean.Exceptions;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

class InstanceResolver {
    private static final Logger log = Logger.getLogger(InstanceResolver.class.getName());

    InstanceResolver() {
    }

    static ConfigInstance resolveToInstance(ConfigInstance.Builder builder, InnerCNode targetDef) {
        try {
            if (targetDef != null) {
                InstanceResolver.applyDef((ConfigBuilder)builder, targetDef);
            }
            Class<? extends ConfigInstance> clazz = InstanceResolver.getConfigClass(builder.getClass());
            return clazz.getConstructor(builder.getClass()).newInstance(builder);
        }
        catch (Exception e) {
            throw new ConfigurationRuntimeException((Throwable)e);
        }
    }

    static void applyDef(ConfigBuilder builder, InnerCNode targetDef) throws Exception {
        for (Map.Entry e : targetDef.children().entrySet()) {
            CNode node = (CNode)e.getValue();
            if (node instanceof LeafCNode) {
                InstanceResolver.setLeafValueIfUnset(targetDef, builder, (LeafCNode)node);
                continue;
            }
            if (!(node instanceof InnerCNode) || !InstanceResolver.hasField(builder.getClass(), node.getName())) continue;
            Field innerField = builder.getClass().getDeclaredField(node.getName());
            innerField.setAccessible(true);
            Object innerFieldVal = innerField.get(builder);
            if (innerFieldVal instanceof List) {
                List innerList = (List)innerFieldVal;
                for (Object b : innerList) {
                    if (!(b instanceof ConfigBuilder)) continue;
                    InstanceResolver.applyDef((ConfigBuilder)b, (InnerCNode)node);
                }
                continue;
            }
            if (!(innerFieldVal instanceof ConfigBuilder)) continue;
            InstanceResolver.applyDef((ConfigBuilder)innerFieldVal, (InnerCNode)node);
        }
    }

    private static boolean hasField(Class<?> aClass, String name) {
        for (Field field : aClass.getDeclaredFields()) {
            if (!name.equals(field.getName())) continue;
            return true;
        }
        return false;
    }

    private static void setLeafValueIfUnset(InnerCNode targetDef, Object builder, LeafCNode node) throws Exception {
        if (InstanceResolver.hasField(builder.getClass(), node.getName())) {
            Field field = builder.getClass().getDeclaredField(node.getName());
            field.setAccessible(true);
            Object val = field.get(builder);
            if (val == null) {
                try {
                    if (node.getDefaultValue() != null) {
                        Method setter = builder.getClass().getDeclaredMethod(node.getName(), String.class);
                        setter.setAccessible(true);
                        setter.invoke(builder, node.getDefaultValue().getValue());
                    }
                }
                catch (Exception e) {
                    log.severe("For config '" + targetDef.getFullName() + "': Unable to apply the default value for field '" + node.getName() + "' to config Builder (where it wasn't set): " + Exceptions.toMessageString((Throwable)e));
                }
            }
        }
    }

    private static Class<? extends ConfigInstance> getConfigClass(Class<? extends ConfigInstance.Builder> builderClass) {
        Class<?> configClass = builderClass.getEnclosingClass();
        if (configClass == null || !ConfigInstance.class.isAssignableFrom(configClass)) {
            throw new ConfigurationRuntimeException("Builder class " + builderClass + " has enclosing class " + configClass + ", which is not a ConfigInstance");
        }
        return configClass;
    }

    static String packageName(ConfigDefinitionKey cKey, PackagePrefix packagePrefix) {
        String prefix = packagePrefix.value;
        return prefix + (cKey.getNamespace().isEmpty() ? "config" : cKey.getNamespace());
    }

    static enum PackagePrefix {
        COM_YAHOO("com.yahoo."),
        NONE("");

        final String value;

        private PackagePrefix(String value) {
            this.value = value;
        }
    }
}

