/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.filedistribution;

import com.yahoo.cloud.config.filedistribution.FiledistributorrpcConfig;
import com.yahoo.cloud.config.filedistribution.FilereferencesConfig;
import com.yahoo.config.FileReference;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.vespa.model.Host;
import com.yahoo.vespa.model.filedistribution.FileDistributor;
import java.util.Collection;

public class FileDistributionConfigProvider
extends AbstractConfigProducer
implements FiledistributorrpcConfig.Producer,
FilereferencesConfig.Producer {
    private final FileDistributor fileDistributor;
    private final boolean sendAllFiles;
    private final Host host;

    public FileDistributionConfigProvider(AbstractConfigProducer parent, FileDistributor fileDistributor, boolean sendAllFiles, Host host) {
        super(parent, host.getHostname());
        this.fileDistributor = fileDistributor;
        this.sendAllFiles = sendAllFiles;
        this.host = host;
    }

    public void getConfig(FiledistributorrpcConfig.Builder builder) {
        builder.connectionspec("tcp/" + this.host.getHostname() + ":19090");
    }

    public void getConfig(FilereferencesConfig.Builder builder) {
        for (FileReference reference : this.getFileReferences()) {
            builder.filereferences(reference.value());
        }
    }

    private Collection<FileReference> getFileReferences() {
        if (this.sendAllFiles) {
            return this.fileDistributor.allFilesToSend();
        }
        return this.fileDistributor.filesToSendToHost(this.host);
    }
}

