/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.search.searchchain;

import com.yahoo.collections.CollectionUtil;
import com.yahoo.component.ComponentId;
import com.yahoo.component.ComponentSpecification;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.search.federation.FederationConfig;
import com.yahoo.search.searchchain.model.federation.FederationOptions;
import com.yahoo.search.searchchain.model.federation.FederationSearcherModel;
import com.yahoo.vespa.model.container.component.Component;
import com.yahoo.vespa.model.container.search.searchchain.GenericTarget;
import com.yahoo.vespa.model.container.search.searchchain.Provider;
import com.yahoo.vespa.model.container.search.searchchain.SearchChain;
import com.yahoo.vespa.model.container.search.searchchain.Searcher;
import com.yahoo.vespa.model.container.search.searchchain.Source;
import com.yahoo.vespa.model.container.search.searchchain.SourceGroup;
import com.yahoo.vespa.model.container.search.searchchain.SourceGroupRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class FederationSearcher
extends Searcher<FederationSearcherModel>
implements FederationConfig.Producer {
    private final Optional<Component> targetSelector;
    private final Map<ComponentId, Target> resolvedTargets = new LinkedHashMap<ComponentId, Target>();

    public FederationSearcher(FederationSearcherModel searcherModel, Optional<Component> targetSelector) {
        super(searcherModel);
        this.targetSelector = targetSelector;
        if (targetSelector.isPresent()) {
            this.addChild((AbstractConfigProducer)targetSelector.get());
        }
    }

    public void getConfig(FederationConfig.Builder builder) {
        for (Target target : this.resolvedTargets.values()) {
            builder.target(target.getTargetConfig());
        }
        if (this.targetSelector.isPresent()) {
            builder.targetSelector(this.targetSelector.get().getGlobalComponentId().stringValue());
        }
    }

    @Override
    public void initialize() {
        this.initialize(this.getSearchChains().allChains(), this.getSearchChains().allSourceGroups());
    }

    void initialize(ComponentRegistry<SearchChain> searchChainRegistry, SourceGroupRegistry sourceGroupRegistry) {
        TargetResolver targetResolver = new TargetResolver(searchChainRegistry, sourceGroupRegistry);
        this.addSourceTargets(targetResolver, ((FederationSearcherModel)this.model).targets);
        if (((FederationSearcherModel)this.model).inheritDefaultSources) {
            this.addDefaultTargets(targetResolver, searchChainRegistry);
        }
    }

    private void addSourceTargets(TargetResolver targetResolver, List<FederationSearcherModel.TargetSpec> targets) {
        for (FederationSearcherModel.TargetSpec targetSpec : targets) {
            Target target = targetResolver.resolve(targetSpec);
            if (target == null) {
                throw new RuntimeException("Can't find source " + targetSpec.sourceSpec + " used as a source for federation '" + this.getComponentId() + "'");
            }
            Target duplicate = this.resolvedTargets.put(target.id, target);
            if (duplicate == null || duplicate.targetOptions.equals(target.targetOptions)) continue;
            throw new RuntimeException("Search chain " + target.id + " added twice with different federation options to the federation searcher " + this.getComponentId());
        }
    }

    private void addDefaultTargets(TargetResolver targetResolver, ComponentRegistry<SearchChain> searchChainRegistry) {
        for (GenericTarget genericTarget : FederationSearcher.defaultTargets(searchChainRegistry.allComponents())) {
            ComponentSpecification specification = genericTarget.getComponentId().toSpecification();
            Target federationTarget = targetResolver.resolve(new FederationSearcherModel.TargetSpec(specification, new FederationOptions()));
            if (this.resolvedTargets.containsKey(federationTarget.id)) continue;
            this.resolvedTargets.put(federationTarget.id, federationTarget);
        }
    }

    private static List<GenericTarget> defaultTargets(Collection<SearchChain> allSearchChains) {
        Collection providers = CollectionUtil.filter(allSearchChains, Provider.class);
        ArrayList<GenericTarget> defaultTargets = new ArrayList<GenericTarget>();
        for (Provider provider : providers) {
            defaultTargets.addAll(provider.defaultFederationTargets());
        }
        return defaultTargets;
    }

    private static class TargetResolver {
        final ComponentRegistry<SearchChain> searchChainRegistry;
        final SourceGroupRegistry sourceGroupRegistry;

        private boolean newerVersion(SearchChain searchChain, SourceGroup sourceGroup) {
            if (searchChain == null || sourceGroup == null) {
                return false;
            }
            return this.newerVersion(searchChain.getComponentId(), sourceGroup.getComponentId());
        }

        private boolean newerVersion(ComponentId a, ComponentId b) {
            return a.compareTo(b) > 0;
        }

        TargetResolver(ComponentRegistry<SearchChain> searchChainRegistry, SourceGroupRegistry sourceGroupRegistry) {
            this.searchChainRegistry = searchChainRegistry;
            this.sourceGroupRegistry = sourceGroupRegistry;
        }

        Target resolve(FederationSearcherModel.TargetSpec specification) {
            SearchChain searchChain = (SearchChain)this.searchChainRegistry.getComponent(specification.sourceSpec);
            SourceGroup sourceGroup = this.sourceGroupRegistry.getComponent(specification.sourceSpec);
            if (searchChain == null && sourceGroup == null) {
                return null;
            }
            if (sourceGroup == null || this.newerVersion(searchChain, sourceGroup)) {
                return new SearchChainTarget(searchChain, specification.federationOptions);
            }
            return new SourceGroupTarget(sourceGroup, specification.federationOptions);
        }
    }

    private static class SourceGroupTarget
    extends Target {
        private final SearchChainConfig leaderConfig;
        private final List<SearchChainConfig> participantsConfig = new ArrayList<SearchChainConfig>();

        public SourceGroupTarget(SourceGroup group, FederationOptions targetOptions) {
            super(group.getComponentId(), SourceGroupTarget.applyDefaultSourceGroupOptions(targetOptions));
            this.leaderConfig = this.createConfig(group.leader(), targetOptions);
            for (Source participant : group.participants()) {
                this.participantsConfig.add(this.createConfig(participant, targetOptions));
            }
        }

        private static FederationOptions applyDefaultSourceGroupOptions(FederationOptions targetOptions) {
            FederationOptions defaultSourceGroupOption = new FederationOptions().setUseByDefault(Boolean.valueOf(true));
            return targetOptions.inherit(defaultSourceGroupOption);
        }

        private SearchChainConfig createConfig(Source source, FederationOptions targetOptions) {
            return new SearchChainConfig(source, source.getParentProvider().getComponentId(), targetOptions, source.getDocumentTypes());
        }

        @Override
        protected void getSearchChainsConfig(FederationConfig.Target.Builder tB) {
            tB.searchChain(this.leaderConfig.getSearchChainConfig());
            for (SearchChainConfig participant : this.participantsConfig) {
                tB.searchChain(participant.getSearchChainConfig());
            }
        }
    }

    private static class SearchChainTarget
    extends Target {
        private final SearchChainConfig searchChainConfig;

        public SearchChainTarget(SearchChain searchChain, FederationOptions targetOptions) {
            super(searchChain.getComponentId(), targetOptions);
            this.searchChainConfig = new SearchChainConfig(searchChain, null, targetOptions, searchChain.getDocumentTypes());
        }

        @Override
        protected void getSearchChainsConfig(FederationConfig.Target.Builder tB) {
            tB.searchChain(this.searchChainConfig.getSearchChainConfig());
        }
    }

    private static abstract class Target {
        final ComponentId id;
        final FederationOptions targetOptions;

        public Target(ComponentId id, FederationOptions targetOptions) {
            this.id = id;
            this.targetOptions = targetOptions;
        }

        public FederationConfig.Target.Builder getTargetConfig() {
            FederationConfig.Target.Builder tb = new FederationConfig.Target.Builder();
            tb.id(this.id.stringValue()).useByDefault(this.targetOptions.getUseByDefault());
            this.getSearchChainsConfig(tb);
            return tb;
        }

        protected abstract void getSearchChainsConfig(FederationConfig.Target.Builder var1);
    }

    private static final class SearchChainConfig {
        private final SearchChain searchChain;
        final ComponentId providerId;
        final FederationOptions targetOptions;
        final List<String> documentTypes;

        SearchChainConfig(SearchChain searchChain, ComponentId providerId, FederationOptions targetOptions, List<String> documentTypes) {
            this.searchChain = searchChain;
            this.providerId = providerId;
            this.targetOptions = targetOptions;
            this.documentTypes = documentTypes;
        }

        public FederationConfig.Target.SearchChain.Builder getSearchChainConfig() {
            FederationConfig.Target.SearchChain.Builder sB = new FederationConfig.Target.SearchChain.Builder();
            FederationOptions resolvedOptions = this.targetOptions.inherit(this.searchChain.federationOptions());
            sB.searchChainId(this.searchChain.getGlobalComponentId().stringValue()).timeoutMillis(resolvedOptions.getTimeoutInMilliseconds()).requestTimeoutMillis(resolvedOptions.getRequestTimeoutInMilliseconds()).optional(resolvedOptions.getOptional()).useByDefault(resolvedOptions.getUseByDefault()).documentTypes(this.documentTypes);
            if (this.providerId != null) {
                sB.providerId(this.providerId.stringValue());
            }
            return sB;
        }
    }
}

