/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.fieldoperation;

import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.searchdefinition.fieldoperation.FieldOperation;
import com.yahoo.searchdefinition.fieldoperation.FieldOperationContainer;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class StructFieldOperation
implements FieldOperation,
FieldOperationContainer {
    private String structFieldName;
    private List<FieldOperation> pendingOperations = new LinkedList<FieldOperation>();

    public StructFieldOperation(String structFieldName) {
        this.structFieldName = structFieldName;
    }

    @Override
    public void apply(SDField field) {
        SDField structField = field.getStructField(this.structFieldName);
        if (structField == null) {
            throw new IllegalArgumentException("Struct field '" + this.structFieldName + "' has not been defined in struct for field '" + field.getName() + "'.");
        }
        this.applyOperations(structField);
    }

    @Override
    public void addOperation(FieldOperation op) {
        this.pendingOperations.add(op);
    }

    @Override
    public void applyOperations(SDField field) {
        if (this.pendingOperations.isEmpty()) {
            return;
        }
        Collections.sort(this.pendingOperations);
        ListIterator<FieldOperation> ops = this.pendingOperations.listIterator();
        while (ops.hasNext()) {
            FieldOperation op = ops.next();
            ops.remove();
            op.apply(field);
        }
    }

    @Override
    public String getName() {
        return this.structFieldName;
    }
}

