/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.search.searchchain;

import com.yahoo.component.ComponentId;
import com.yahoo.component.ComponentSpecification;
import com.yahoo.component.chain.model.ChainSpecification;
import com.yahoo.component.chain.model.ChainedComponentModel;
import com.yahoo.prelude.cluster.QrMonitorConfig;
import com.yahoo.prelude.fastsearch.DocumentdbInfoConfig;
import com.yahoo.search.config.ClusterConfig;
import com.yahoo.search.searchchain.model.federation.FederationOptions;
import com.yahoo.search.searchchain.model.federation.LocalProviderSpec;
import com.yahoo.searchdefinition.derived.SchemaInfo;
import com.yahoo.vespa.config.search.AttributesConfig;
import com.yahoo.vespa.config.search.RankProfilesConfig;
import com.yahoo.vespa.model.container.search.searchchain.Provider;
import com.yahoo.vespa.model.container.search.searchchain.Searcher;
import com.yahoo.vespa.model.search.SearchCluster;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class LocalProvider
extends Provider
implements DocumentdbInfoConfig.Producer,
ClusterConfig.Producer,
AttributesConfig.Producer,
QrMonitorConfig.Producer,
RankProfilesConfig.Producer {
    private final LocalProviderSpec providerSpec;
    private volatile SearchCluster searchCluster;

    public void getConfig(ClusterConfig.Builder builder) {
        assert (this.searchCluster != null) : "Null search cluster!";
        builder.clusterId(this.searchCluster.getClusterIndex());
        builder.clusterName(this.searchCluster.getClusterName());
        if (this.searchCluster.getVisibilityDelay() != null) {
            builder.cacheTimeout(LocalProvider.convertVisibilityDelay(this.searchCluster.getVisibilityDelay()).doubleValue());
        }
    }

    public void getConfig(RankProfilesConfig.Builder builder) {
        this.searchCluster.getConfig(builder);
    }

    public void getConfig(AttributesConfig.Builder builder) {
        this.searchCluster.getConfig(builder);
    }

    public void getConfig(QrMonitorConfig.Builder builder) {
        int requestTimeout = this.federationOptions().getTimeoutInMilliseconds();
        if (requestTimeout != -1) {
            builder.requesttimeout(requestTimeout);
        }
    }

    private void addProviderSearchers() {
        for (ChainedComponentModel searcherModel : LocalProviderSpec.searcherModels) {
            this.addInnerComponent(new Searcher<ChainedComponentModel>(searcherModel));
        }
    }

    @Override
    public ChainSpecification getChainSpecification() {
        ChainSpecification spec = super.getChainSpecification();
        return new ChainSpecification(spec.componentId, spec.inheritance, spec.phases(), this.disableStemmingIfStreaming(spec.componentReferences));
    }

    private Set<ComponentSpecification> disableStemmingIfStreaming(Set<ComponentSpecification> searcherReferences) {
        if (!this.searchCluster.isStreaming()) {
            return searcherReferences;
        }
        LinkedHashSet<ComponentSpecification> filteredSearcherReferences = new LinkedHashSet<ComponentSpecification>(searcherReferences);
        filteredSearcherReferences.remove(this.toGlobalComponentId(new ComponentId("com.yahoo.prelude.querytransform.StemmingSearcher")).toSpecification());
        return filteredSearcherReferences;
    }

    private ComponentId toGlobalComponentId(ComponentId searcherId) {
        return searcherId.nestInNamespace(this.getComponentId());
    }

    public String getClusterName() {
        return this.providerSpec.clusterName;
    }

    void setSearchCluster(SearchCluster searchCluster) {
        this.searchCluster = searchCluster;
    }

    public LocalProvider(ChainSpecification specWithoutInnerSearchers, FederationOptions federationOptions, LocalProviderSpec providerSpec) {
        super(specWithoutInnerSearchers, federationOptions);
        this.addProviderSearchers();
        this.providerSpec = providerSpec;
    }

    @Override
    public List<String> getDocumentTypes() {
        ArrayList<String> documentTypes = new ArrayList<String>();
        for (SchemaInfo spec : this.searchCluster.schemas().values()) {
            documentTypes.add(spec.fullSchema().getDocument().getName());
        }
        return documentTypes;
    }

    @Override
    public FederationOptions federationOptions() {
        Double queryTimeoutInSeconds = this.searchCluster.getQueryTimeout();
        return queryTimeoutInSeconds == null ? super.federationOptions() : super.federationOptions().inherit(new FederationOptions().setTimeoutInMilliseconds(Integer.valueOf((int)(queryTimeoutInSeconds * 1000.0))));
    }

    public void getConfig(DocumentdbInfoConfig.Builder builder) {
        this.searchCluster.getConfig(builder);
    }

    private static Double convertVisibilityDelay(Double visibilityDelay) {
        return visibilityDelay < 1.0 ? 0.0 : visibilityDelay;
    }
}

