/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container;

import com.yahoo.container.bundle.BundleInstantiationSpecification;
import com.yahoo.container.handler.ThreadPoolProvider;
import com.yahoo.container.handler.ThreadpoolConfig;
import com.yahoo.osgi.provider.model.ComponentModel;
import com.yahoo.vespa.model.container.ApplicationContainerCluster;
import com.yahoo.vespa.model.container.ContainerCluster;
import com.yahoo.vespa.model.container.component.SimpleComponent;

class DefaultThreadpoolProvider
extends SimpleComponent
implements ThreadpoolConfig.Producer {
    private final ContainerCluster<?> cluster;
    private final int defaultWorkerThreads;

    DefaultThreadpoolProvider(ContainerCluster<?> cluster, int defaultWorkerThreads) {
        super(new ComponentModel(BundleInstantiationSpecification.getFromStrings((String)"default-threadpool", (String)ThreadPoolProvider.class.getName(), null)));
        this.cluster = cluster;
        this.defaultWorkerThreads = defaultWorkerThreads;
    }

    public void getConfig(ThreadpoolConfig.Builder builder) {
        if (this.cluster instanceof ApplicationContainerCluster) {
            builder.corePoolSize(-2).maxthreads(-100).queueSize(0);
        } else {
            builder.corePoolSize(this.defaultWorkerThreads).maxthreads(this.defaultWorkerThreads).queueSize(50);
        }
    }
}

