/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.builder.xml.dom.chains;

import com.yahoo.config.application.Xml;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.vespa.model.builder.xml.dom.VespaDomBuilder;
import com.yahoo.vespa.model.builder.xml.dom.chains.ChainsBuilder;
import com.yahoo.vespa.model.builder.xml.dom.chains.ComponentsBuilder;
import com.yahoo.vespa.model.container.component.chain.Chain;
import com.yahoo.vespa.model.container.component.chain.ChainedComponent;
import com.yahoo.vespa.model.container.component.chain.Chains;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

public abstract class DomChainsBuilder<COMPONENT extends ChainedComponent<?>, CHAIN extends Chain<COMPONENT>, CHAINS extends Chains<CHAIN>>
extends VespaDomBuilder.DomConfigProducerBuilder<CHAINS> {
    private final Collection<ComponentsBuilder.ComponentType<COMPONENT>> allowedComponentTypes;
    private final String appPkgChainsDir;
    private final Element outerChainsElem;

    protected DomChainsBuilder(Element outerChainsElem, Collection<ComponentsBuilder.ComponentType<COMPONENT>> allowedComponentTypes, String appPkgChainsDir) {
        this.outerChainsElem = outerChainsElem;
        this.allowedComponentTypes = new ArrayList<ComponentsBuilder.ComponentType<COMPONENT>>(allowedComponentTypes);
        this.appPkgChainsDir = appPkgChainsDir;
    }

    protected abstract CHAINS newChainsInstance(AbstractConfigProducer<?> var1);

    @Override
    protected final CHAINS doBuild(DeployState deployState, AbstractConfigProducer<?> parent, Element chainsElement) {
        CHAINS chains = this.newChainsInstance(parent);
        List<Element> allChainElements = this.allChainElements(deployState, chainsElement);
        if (!allChainElements.isEmpty()) {
            ComponentsBuilder<COMPONENT> outerComponentsBuilder = this.readOuterComponents(deployState, (AbstractConfigProducer<?>)chains, allChainElements);
            ChainsBuilder<COMPONENT, CHAIN> chainsBuilder = this.readChains(deployState, (AbstractConfigProducer<?>)chains, allChainElements, outerComponentsBuilder.getComponentTypeByComponentName());
            this.addOuterComponents(chains, outerComponentsBuilder);
            this.addChains(chains, chainsBuilder);
        }
        return chains;
    }

    private List<Element> allChainElements(DeployState deployState, Element chainsElement) {
        ArrayList<Element> chainsElements = new ArrayList<Element>();
        if (this.outerChainsElem != null) {
            chainsElements.add(this.outerChainsElem);
        }
        chainsElements.add(chainsElement);
        if (this.appPkgChainsDir != null) {
            chainsElements.addAll(Xml.allElemsFromPath((ApplicationPackage)deployState.getApplicationPackage(), (String)this.appPkgChainsDir));
        }
        return chainsElements;
    }

    private ComponentsBuilder<COMPONENT> readOuterComponents(DeployState deployState, AbstractConfigProducer<?> ancestor, List<Element> chainsElems) {
        return new ComponentsBuilder(deployState, ancestor, this.allowedComponentTypes, chainsElems, null);
    }

    protected abstract ChainsBuilder<COMPONENT, CHAIN> readChains(DeployState var1, AbstractConfigProducer<?> var2, List<Element> var3, Map<String, ComponentsBuilder.ComponentType<?>> var4);

    private void addOuterComponents(CHAINS chains, ComponentsBuilder<COMPONENT> outerComponentsBuilder) {
        assert (outerComponentsBuilder.getOuterComponentReferences().isEmpty());
        for (ChainedComponent outerComponent : outerComponentsBuilder.getComponentDefinitions()) {
            ((Chains)chains).add(outerComponent);
        }
    }

    private void addChains(CHAINS chains, ChainsBuilder<COMPONENT, CHAIN> chainsBuilder) {
        for (Chain chain : chainsBuilder.getChains()) {
            ((Chains)chains).add((Chain)chain);
        }
    }
}

