/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.builder.xml.dom.chains;

import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.text.XML;
import com.yahoo.vespa.model.builder.xml.dom.chains.ComponentsBuilder;
import com.yahoo.vespa.model.builder.xml.dom.chains.DomBuilderCreator;
import com.yahoo.vespa.model.builder.xml.dom.chains.DomChainBuilderBase;
import com.yahoo.vespa.model.container.component.chain.Chain;
import com.yahoo.vespa.model.container.component.chain.ChainedComponent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

public class ChainsBuilder<COMPONENT extends ChainedComponent<?>, CHAIN extends Chain<COMPONENT>> {
    protected final List<CHAIN> chains = new ArrayList<CHAIN>();
    private final Map<String, Class<? extends DomChainBuilderBase<? extends COMPONENT, ? extends CHAIN>>> chainType2BuilderClass;

    public ChainsBuilder(DeployState deployState, AbstractConfigProducer<?> ancestor, List<Element> chainsElems, Map<String, ComponentsBuilder.ComponentType<?>> outerComponentTypeByComponentName, Map<String, Class<? extends DomChainBuilderBase<? extends COMPONENT, ? extends CHAIN>>> chainType2BuilderClass) {
        this.chainType2BuilderClass = chainType2BuilderClass;
        this.readChains(deployState, ancestor, chainsElems, outerComponentTypeByComponentName);
    }

    public Collection<CHAIN> getChains() {
        return Collections.unmodifiableCollection(this.chains);
    }

    private void readChains(DeployState deployState, AbstractConfigProducer<?> ancestor, List<Element> chainsElems, Map<String, ComponentsBuilder.ComponentType<?>> outerSearcherTypeByComponentName) {
        for (Map.Entry<String, Class<DomChainBuilderBase<COMPONENT, CHAIN>>> chainType : this.chainType2BuilderClass.entrySet()) {
            for (Element elemContainingChainElems : chainsElems) {
                for (Element chainElem : XML.getChildren((Element)elemContainingChainElems, (String)chainType.getKey())) {
                    this.readChain(deployState, ancestor, chainElem, chainType.getValue(), outerSearcherTypeByComponentName);
                }
            }
        }
    }

    private void readChain(DeployState deployState, AbstractConfigProducer<?> ancestor, Element chainElem, Class<? extends DomChainBuilderBase<? extends COMPONENT, ? extends CHAIN>> builderClass, Map<String, ComponentsBuilder.ComponentType<?>> outerSearcherTypeByComponentName) {
        DomChainBuilderBase<COMPONENT, CHAIN> builder = DomBuilderCreator.create(builderClass, outerSearcherTypeByComponentName);
        this.chains.add((Chain)builder.build(deployState, ancestor, chainElem));
    }
}

